/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.io.GetTransmission;
import bsc.sdk.kernel.bus.messages.kernel.io.RequestNewTransmissionID;
import bsc.sdk.kernel.bus.messages.kernel.io.UpdateTransmission;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.idpool.IdPool;
import bsc.sdk.kernel.modules.idpool.IdPoolSettings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.listener.Handler;

@IKernelModule.ModuleSettings(supportedKernels={BasicApiKernel.class})
public class TransmissionManager
extends BasicApiKernel.BasicKernelModule {
    protected IdPool transmissionIdPool = this.createNewPool(new IdPoolSettings("Transmission", IdPool.GENERATOR_TYPE.RANDOM, TimeUnit.DAYS.toMillis(1L), "", "", 12, "", 0));
    protected SizedMap<String, ITransmission> transmissions = new SizedMap(250);

    public TransmissionManager(AApplicationKernel kernel) {
        super(kernel);
    }

    @Handler
    protected void getNewTransmissionID(RequestNewTransmissionID requestNewTransmissionID) {
        requestNewTransmissionID.setTransmissionID(this.transmissionIdPool.getId());
    }

    @Handler
    protected void updateTransmission(UpdateTransmission updateTransmission) {
        ITransmission transmission = updateTransmission.getTransmission();
        if (transmission != null) {
            this.transmissions.put(transmission.getTransmissionId(), transmission);
        }
    }

    @Handler
    protected void getTransmission(GetTransmission getTransmission) {
        getTransmission.setTransmission((ITransmission)this.transmissions.get(getTransmission.getTransmissionID()));
    }

    @Override
    public void unload() {
    }

    @Override
    public void init() {
    }

    public class SizedMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 225142148593042342L;
        private final int maxSize;

        public SizedMap(int size) {
            this.maxSize = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

