/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.Group;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.impl.UserCredential;
import bsc.sdk.api.user.group.Permission;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.module.handler.ObjectUpdated;
import bsc.sdk.tools.Tools;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.engio.mbassy.listener.Handler;

public class SimpleObjectManager
extends AApplicationKernel.KernelModule {
    protected Map<String, ADevice> devices = new HashMap<String, ADevice>();
    protected Map<Integer, Group> groups = new HashMap<Integer, Group>();

    public SimpleObjectManager(AApplicationKernel kernel) {
        super(kernel);
    }

    @Override
    public void unload() {
    }

    @Handler
    protected void updateObject(ObjectUpdated objectUpdated) {
        IIdentifiableApiObject object = (IIdentifiableApiObject)objectUpdated.getObject();
        this.updateObject(object);
    }

    protected void updateObject(IIdentifiableApiObject object) {
        if (object instanceof ADevice) {
            ADevice device = (ADevice)Tools.deepClone(object);
            SimpleObjectManager.updateDevice(this.devices, device);
        } else if (object instanceof ISensor) {
            ISensor sensor = (ISensor)Tools.deepClone(object);
            if (object instanceof AMetaInformation) {
                // empty if block
            }
            SimpleObjectManager.updateSensor(this.devices, sensor);
        } else if (object instanceof Group) {
            Group group = (Group)object;
            this.groups.put(group.getId(), group);
        }
    }

    protected IUserCredential getDefaultUser() {
        return new UserCredential("Admin", "admin");
    }

    protected EnumSet<Permission> getDefaultPermission() {
        return EnumSet.allOf(Permission.class);
    }

    protected static void updateDevice(Map<String, ADevice> cache, ADevice device) {
        if (cache != null) {
            cache.put(device.getDeviceID(), device);
        }
    }

    protected static void updateSensor(Map<String, ADevice> cache, ISensor sensor) {
        String deviceID;
        ADevice device;
        if (cache != null && (device = cache.get(deviceID = sensor.getDeviceID())) != null) {
            ISensor s = device.getSensorByID(sensor.getSensorID());
            device.removeSensor(s);
            device.addSensor(sensor);
        }
    }

    public ADevice getDevice(String deviceID) {
        return this.devices.get(deviceID);
    }

    public Collection<ADevice> getAllDevices() {
        return Collections.unmodifiableCollection(this.devices.values());
    }

    public Group getGroup(int groupID) {
        return this.groups.get(groupID);
    }

    public Collection<Group> getAllGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public void init() {
    }
}

