/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.ApplicationSettings;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.kernel.io.GetTransmission;
import bsc.sdk.kernel.bus.messages.kernel.io.ReceivedMisc;
import bsc.sdk.kernel.bus.messages.kernel.io.ReceivedObject;
import bsc.sdk.kernel.bus.messages.kernel.io.ReceivedResult;
import bsc.sdk.kernel.bus.messages.kernel.io.RequestNewTransmissionID;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverExceptionOccurred;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.bus.messages.kernel.io.UpdateTransmission;
import bsc.sdk.kernel.bus.messages.kernel.user.AddUser;
import bsc.sdk.kernel.bus.messages.module.api.RegisterApiExtensionModule;
import bsc.sdk.kernel.bus.messages.module.api.UnregisterApiExtensionModule;
import bsc.sdk.kernel.bus.messages.module.handler.HandleCommand;
import bsc.sdk.kernel.bus.messages.module.user.GetSession;
import bsc.sdk.kernel.bus.messages.module.user.RequestNewSessionID;
import bsc.sdk.kernel.bus.messages.module.user.UpdateSession;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.api.IApiExtensionModule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.engio.mbassy.listener.Handler;

public abstract class AConnector
extends BasicApiKernel.BasicKernelModule {
    protected Set<String> apiExtensions = new HashSet<String>();

    public AConnector(AApplicationKernel kernel) {
        super(kernel);
        Collection<IApiExtensionModule> apiModules = kernel.getAssignableModules(IApiExtensionModule.class);
        for (IApiExtensionModule iApiExtensionModule : apiModules) {
            this.apiExtensions.addAll(iApiExtensionModule.getSupportedExtensions());
        }
    }

    public String getNewSessionID() {
        RequestNewSessionID request = new RequestNewSessionID();
        this.postKernelMessage(request).now();
        return request.getSessionID();
    }

    @Handler
    protected void registerApiExtensionModule(RegisterApiExtensionModule message) {
        this.apiExtensions.addAll(message.getModule().getSupportedExtensions());
    }

    @Handler
    protected void unregisterApiExtensionModule(UnregisterApiExtensionModule message) {
        this.apiExtensions.addAll(message.getModule().getSupportedExtensions());
    }

    public Set<String> getApiExtensionSet() {
        return Collections.unmodifiableSet(this.apiExtensions);
    }

    public Enumerations.ApiVersion getApiVersion() {
        return Enumerations.ApiVersion.Ver_2_1_0;
    }

    public ITransmission getTransmission(String transmissionID) {
        GetTransmission request = new GetTransmission(transmissionID);
        this.postKernelMessage(request).now();
        return request.getTransmission();
    }

    public String getNewTransmissionID() {
        RequestNewTransmissionID request = new RequestNewTransmissionID();
        this.postKernelMessage(request).now();
        return request.getTransmissionID();
    }

    public boolean hasOpenConnectionSlots(String userName) {
        return true;
    }

    public synchronized void execute(Runnable runnable) {
        this.priorityExecute(runnable);
    }

    public void errorOccured(TransceiverExceptionOccurred e) {
        this.postKernelMessage(e).now();
    }

    public void transceiverStateChanged(TransceiverState changedState) {
        this.postKernelMessage(changedState).now();
    }

    public Result handle(String source, Object object) {
        Result result = null;
        if (object instanceof TransmissionObject) {
            TransmissionObject transmissionObject = (TransmissionObject)object;
            String transmissionID = transmissionObject.getID();
            ITransmission transmission = this.getTransmission(transmissionID);
            IApiObject obj = transmissionObject.getObject();
            if (obj instanceof IIdentifiableApiObject) {
                IIdentifiableApiObject apiObject = (IIdentifiableApiObject)obj;
                ReceivedObject receivedObject = new ReceivedObject(source, apiObject, transmission);
                this.postKernelMessage(receivedObject).now();
                result = receivedObject.getResult();
            } else if (obj instanceof Command) {
                Command command = (Command)obj;
                HandleCommand handle = new HandleCommand(source, command, transmission);
                this.postKernelMessage(handle).now();
                result = handle.getResult();
            } else if (obj instanceof Result) {
                Result r = (Result)obj;
                if (transmission != null) {
                    transmission.setResult(r);
                }
                ReceivedResult rr = new ReceivedResult(source, r, transmission);
                this.postKernelMessage(rr).now();
            } else if (obj instanceof IApiObject) {
                IApiObject apiObject = obj;
                ReceivedMisc receivedMisc = new ReceivedMisc(source, apiObject, transmission);
                this.postKernelMessage(receivedMisc).now();
                result = receivedMisc.getResult();
            } else {
                this.logger.error("No handler for: " + object.getClass().getName());
            }
        } else {
            this.logger.error("No handler for: " + object.getClass().getName());
        }
        if (result == null) {
            result = new FailResult(Enumerations.ErrorType.UNSUPPORTED_OPERATION);
        }
        return result;
    }

    public abstract ApplicationSettings getApplicationSettings();

    public ISession getSession(String sessionID) {
        GetSession getSession = new GetSession(sessionID);
        this.postKernelMessage(getSession).now();
        return getSession.getSession();
    }

    public void sessionUpdated(UpdateSession sessionUpdate) {
        this.postKernelMessage(sessionUpdate).now();
    }

    public void updateUser(AddUser updateUserCredential) {
        this.postKernelMessage(updateUserCredential).now();
    }

    public void updateTransmission(ITransmission transmission) {
        this.postKernelMessage(new UpdateTransmission(transmission)).now();
        this.logger.trace("Transmission updated: " + transmission);
    }

    public void updateObject(Object object) {
        System.out.println("Object updated: " + object);
    }
}

