/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.ApplicationSettings;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.impl.UserCredential;
import bsc.sdk.api.user.session.ASessionFactory;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverExceptionOccurred;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.bus.messages.kernel.user.AddUser;
import bsc.sdk.kernel.bus.messages.module.user.UpdateSession;
import bsc.sdk.kernel.modules.io.AConnector;
import bsc.sdk.kernel.modules.io.ClientConnector;
import bsc.sdk.kernel.modules.io.IConnectionAdapter;
import bsc.sdk.kernel.transceiver.ATransceiver;
import bsc.sdk.kernel.transceiver.ChannelHandlerCompletionSync;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;
import bsc.sdk.net.ISocket;
import bsc.sdk.net.SocketFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AConnection
implements IConnectionAdapter {
    protected final Logger logger;
    protected ISession session = null;
    protected IUserCredential user = null;
    protected final ClientConnector.ConnectionProfile connectionProfile;
    protected ATransceiver transceiver;
    protected final AConnector connector;
    protected TransceiverState.STATE transceiverState;

    public AConnection(ClientConnector.ConnectionProfile connectionProfile, AConnector connector) {
        this.connectionProfile = connectionProfile;
        this.user = new UserCredential(connectionProfile.getUser(), connectionProfile.getPassword());
        this.connector = connector;
        this.logger = LoggerFactory.getLogger((String)this.getId());
        this.transceiver = this.connect();
    }

    @Override
    public String getId() {
        return this.connector.getUniqueItemID(this.connectionProfile + "#" + this.hashCode());
    }

    @Override
    public ATransceiver getTransceiver() {
        return this.transceiver;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    @Override
    public ISession getSession(String sessionID) {
        if (this.session != null && this.session.getSessionID().equals(sessionID)) {
            return this.session;
        }
        return null;
    }

    @Override
    public IUserCredential getUser() {
        return this.user;
    }

    @Override
    public IUserCredential getUser(String userName) {
        if (this.user != null && this.user.getUserName().equals(userName)) {
            return this.user;
        }
        return null;
    }

    @Override
    public void objectUpdated(Object object) {
        if (object instanceof ITransmission) {
            ITransmission transmission = (ITransmission)object;
            this.connector.updateTransmission(transmission);
        } else if (object instanceof IIdentifiableApiObject) {
            this.connector.updateObject(object);
        } else if (object instanceof ISession) {
            ISession session = (ISession)object;
            if (this.session == null || session.getSessionID().equals(this.session.getSessionID())) {
                this.session = session;
                this.connector.sessionUpdated(new UpdateSession(this.getId(), session));
            }
        } else if (object instanceof IUserCredential) {
            IUserCredential user = (IUserCredential)object;
            if (this.user != null && user.getUserName().equals(this.user.getUserName())) {
                this.user = user;
                this.connector.updateUser(new AddUser(user));
            }
        }
    }

    @Override
    public Result handle(Object object) {
        return this.connector.handle(this.getId(), object);
    }

    @Override
    public Set<String> getApiExtensionSet() {
        return this.connector.getApiExtensionSet();
    }

    @Override
    public ApplicationSettings getApplicationSettings() {
        return this.connector.getApplicationSettings();
    }

    @Override
    public String getNewTransmissionID() {
        return this.connector.getNewTransmissionID();
    }

    @Override
    public String getNewSessionID() {
        return this.connector.getNewSessionID();
    }

    @Override
    public boolean hasOpenConnectionSlots(String userName) {
        return this.connector.hasOpenConnectionSlots(userName);
    }

    @Override
    public Enumerations.ApiVersion getApiVersion() {
        return this.connector.getApiVersion();
    }

    @Override
    public ITransmission getTransmission(String transmissionID) {
        return this.connector.getTransmission(transmissionID);
    }

    @Override
    public void execute(Runnable runnable) {
        this.connector.execute(runnable);
    }

    @Override
    public void errorOccured(TransceiverException e) {
        this.connector.errorOccured(new TransceiverExceptionOccurred(this.getId(), e));
    }

    @Override
    public ITransmission sendCommand(Command command) {
        return this.transceiver.sendCommand(command);
    }

    public ITransmission sendObject(IApiObject object) {
        return this.transceiver.sendObject(object);
    }

    public ATransceiver connect() {
        Socket socket = null;
        try {
            socket = new Socket(this.connectionProfile.getServer(), this.connectionProfile.getPort());
        }
        catch (IOException e1) {
            this.logger.error(e1.getMessage(), (Throwable)e1);
            this.errorOccured(new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e1));
        }
        if (socket != null) {
            ISocket iSocket = null;
            try {
                iSocket = SocketFactory.createNewMobileInstance(socket, socket.getInputStream(), socket.getOutputStream());
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage(), (Throwable)e1);
                this.errorOccured(new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e1));
            }
            if (iSocket != null) {
                ChannelHandlerCompletionSync worker = new ChannelHandlerCompletionSync(iSocket, this);
                ISession iSession = this.session = this.connectionProfile.getSessionID() != null ? this.connector.getSession(this.connectionProfile.getSessionID()) : null;
                if (this.session == null || !this.connectionProfile.getUser().equals(this.session.getUserCredentialID())) {
                    this.session = ASessionFactory.createNewInstance();
                    this.session.setUserCredentialID(this.connectionProfile.getUser());
                }
                StateConfiguration stateConfiguration = new StateConfiguration(StateFactory.TYPE.CLIENT, StateFactory.STATE.INIT, this);
                stateConfiguration.setSession(this.session);
                try {
                    this.transceiver = new ATransceiver(this.getId(), worker, StateFactory.getDefaultFactory().createState(stateConfiguration), this);
                }
                catch (SocketException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.errorOccured(new TransceiverException(Enumerations.ErrorType.EXCEPTION, (Throwable)e));
                }
                if (this.transceiver != null) {
                    this.transceiver.connect();
                    this.logger.trace("Connecting...");
                }
            }
        }
        return this.transceiver;
    }

    @Override
    public void disconnect(boolean terminate) {
        if (this.transceiver != null) {
            this.logger.trace("Disconnect...");
            this.transceiver.disconnect(terminate);
            long timeout = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
            while (System.currentTimeMillis() < timeout && !this.transceiver.getState().equals((Object)TransceiverState.STATE.TERMINATED)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void transceiverStateChanged(TransceiverState.STATE newState, String stage) {
        this.transceiverState = newState;
        this.connector.transceiverStateChanged(new TransceiverState(this.getId(), newState, stage));
    }

    @Override
    public ClientConnector.ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public boolean isConnectionReadyForOperation() {
        return TransceiverState.STATE.WORK.equals((Object)this.transceiverState);
    }
}

