/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.impl;

import bsc.api.basic.commands.Command;
import bsc.api.transport.result.OkResult;
import bsc.sdk.kernel.bus.messages.AReceivedObject;
import bsc.sdk.kernel.bus.messages.kernel.io.SendCommand;
import bsc.sdk.kernel.bus.messages.module.ConnectionRequest;
import bsc.sdk.kernel.bus.messages.module.DisconnectRequest;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.io.ClientConnector;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAnalyserClient
extends BasicApiKernel {
    protected static Logger logger = LoggerFactory.getLogger(ConnectionAnalyserClient.class);
    private String connectionID = null;

    public ConnectionAnalyserClient(String user, String password, String server, int port) {
        logger.info("Connecting to " + server + ":" + port + "...");
        this.connect(user, password, server, port);
    }

    public String connect(String user, String password, String server, int port) {
        ClientConnector.ConnectionProfile profile = new ClientConnector.ConnectionProfile(user, DigestUtils.sha256Hex((String)password).toUpperCase(), server, port, null, null);
        ConnectionRequest connectionRequest = new ConnectionRequest(profile);
        this.postKernelMessage(connectionRequest).now();
        this.connectionID = connectionRequest.getCreatedTarget();
        return connectionRequest.getCreatedTarget();
    }

    public void disconnect() {
        DisconnectRequest disconnectRequest = new DisconnectRequest(this.connectionID);
        this.connectionID = null;
        this.postKernelMessage(disconnectRequest).now();
    }

    public void sendCommand(Command command) {
        if (command != null) {
            SendCommand c = new SendCommand(this.connectionID, command);
            this.postKernelMessage(c).now();
        }
    }

    @Handler
    private void handle(AReceivedObject<?> object) {
        logger.info("Recceived: " + object);
        object.setResult(new OkResult());
    }
}

