/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.executors;

import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.kernel.executors.DynamicNamedThread;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public class NamedPriorityThreadFactory
implements ThreadFactory {
    private static final String seperator = "->";
    private final String baseName;
    private final int priority;
    private IdPool idPool;

    public NamedPriorityThreadFactory(String baseName) {
        this(baseName, 5);
    }

    public NamedPriorityThreadFactory(String baseName, int priority) {
        this.baseName = Objects.requireNonNull(baseName, "baseName must not be null!");
        this.priority = priority;
        this.idPool = new IdPool(IdPool.GENERATOR_TYPE.SEQUENCE_LONG, this.getClass().getName());
    }

    @Override
    public Thread newThread(Runnable r) {
        DynamicNamedThread result = new DynamicNamedThread(r, this.baseName + seperator + this.idPool.getId());
        result.setPriority(this.priority);
        result.setDaemon(true);
        return result;
    }
}

