/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel;

import bsc.sdk.kernel.AKernelSettings;
import bsc.sdk.kernel.IApplicationKernel;
import bsc.sdk.kernel.IKernelSettings;
import bsc.sdk.kernel.KernelParameters;
import bsc.sdk.kernel.bus.impl.DefaultMessageBus;
import bsc.sdk.kernel.bus.impl.MessageBusFactory;
import bsc.sdk.kernel.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.ModulePriorityComparator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.bus.publication.SyncAsyncPostCommand;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IApplicationKernel.KernelSettings
public abstract class AApplicationKernel
implements IApplicationKernel {
    protected Logger logger;
    protected KernelParameters kernelInitParameters;
    protected Map<Class<IKernelModule>, IKernelModule> kernelModules;
    protected Map<Object, DefaultMessageBus> messageBusMap;
    protected IKernelSettings kernelSettings = null;
    protected Map<String, String> kernelStats;
    protected DynamicScheduledCachedThreadPoolExecutor priorityExexutorPool;
    protected DynamicScheduledCachedThreadPoolExecutor backgroundExexutorPool;

    public AApplicationKernel() {
        this(new KernelParameters.NoKernelParameters());
    }

    public AApplicationKernel(Class<?> ... modules) {
        this(new KernelParameters(null, modules));
    }

    public AApplicationKernel(IKernelSettings kernelSettingsImpl, Class<?> ... modules) {
        this(new KernelParameters(kernelSettingsImpl, modules));
    }

    public AApplicationKernel(Collection<Class<? extends IKernelModule>> modules) {
        this(new KernelParameters(null, modules, null));
    }

    public AApplicationKernel(IKernelSettings kernelSettingsImpl, Collection<Class<? extends IKernelModule>> modules) {
        this(new KernelParameters(kernelSettingsImpl, modules, null));
    }

    public AApplicationKernel(IKernelSettings kernelSettingsImpl, Collection<Class<? extends IKernelModule>> dynamicModules, Collection<Class<? extends IKernelModule>> staticModules) {
        this(new KernelParameters(kernelSettingsImpl, dynamicModules, staticModules));
    }

    public AApplicationKernel(KernelParameters parameters) {
        this.initKernel(parameters);
    }

    protected String getKernelSetting(Enum<?> key) {
        return this.getKernelSetting(key.name());
    }

    protected String getKernelSetting(String key) {
        Map<String, String> setting;
        String result = null;
        Map<String, String> map = setting = key == null ? null : this.getKernelSettings(key);
        if (setting != null) {
            result = (String)setting.get(key);
        }
        return result;
    }

    protected Map<String, String> getKernelSettings() {
        return this.kernelSettings.getAllSettings();
    }

    protected Map<String, String> getKernelSettings(String ... keys) {
        return this.kernelSettings.getSettings(keys);
    }

    protected void removeKernelSetting(Enum<?> key) {
        if (key != null) {
            this.removeKernelSetting(key.name());
        }
    }

    protected void removeKernelSetting(String key) {
        this.kernelSettings.remove(key);
    }

    protected Map<String, String> getKernelSettings(Enum<?> ... keys) {
        String[] keyArray = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            keyArray[i] = keys[i].name();
        }
        return this.getKernelSettings(keyArray);
    }

    protected void putKernelSetting(Enum<?> key, String value) {
        this.putKernelSetting(key.name(), value);
    }

    protected void putKernelSetting(Enum<?> key, int value) {
        this.putKernelSetting(key, String.valueOf(value));
    }

    protected void putKernelSetting(Enum<?> key, long value) {
        this.putKernelSetting(key, String.valueOf(value));
    }

    protected void putKernelSetting(Enum<?> key, Enum<?> value) {
        this.putKernelSetting(key.name(), value.name());
    }

    protected Map<String, String> getKernelStats() {
        return Collections.unmodifiableMap(this.kernelStats);
    }

    protected Map<String, String> getKernelStats(String ... keys) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : keys) {
            String value = this.kernelStats.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    protected void putKernelSetting(String key, String value) {
        this.kernelSettings.put(key, value);
    }

    protected SyncAsyncPostCommand<Object> postKernelMessage(Object message) {
        if (this.messageBusMap.containsKey(this)) {
            return this.messageBusMap.get(this).post(message);
        }
        this.logger.warn("Kernel Message not posted. No mapping for 'AApplicationKernel' found");
        return null;
    }

    protected void subscribeKernelMessageListener(Object listener) {
        this.logger.trace("Subscribe for kernel message bus: " + listener);
        if (this.messageBusMap.containsKey(this)) {
            this.messageBusMap.get(this).subscribe(listener);
            return;
        }
        this.logger.warn("Could not subscribe for Kernel Message bus. No mapping for 'AApplicationKernel' found");
    }

    protected void unsubscribeKernelMessageListener(Object listener) {
        this.logger.trace("Unsubscribe for kernel message bus: " + listener);
        if (this.messageBusMap.containsKey(this)) {
            this.messageBusMap.get(this).unsubscribe(listener);
            return;
        }
        this.logger.warn("Could not unsubscribe from Kernel Message bus. No mapping for 'AApplicationKernel' found");
    }

    protected void createMessageBus(Object bindingObject, String name) {
        if (!this.messageBusMap.containsKey(bindingObject)) {
            DefaultMessageBus messageBus = MessageBusFactory.createDefaultMessageBus(name, this.logger);
            this.messageBusMap.put(bindingObject, messageBus);
        }
    }

    protected SyncAsyncPostCommand<Object> postMessage(Object bindingObject, Object message) {
        SyncAsyncPostCommand result = null;
        DefaultMessageBus messageBus = this.messageBusMap.get(bindingObject);
        if (messageBus != null) {
            result = messageBus.post(message);
        } else {
            this.logger.trace("No message bus exists for " + this.getObjectClassName(bindingObject) + "! Skip message: " + message);
        }
        return result;
    }

    protected void subscribeMessageListener(Object bindingObject, Object listener) {
        DefaultMessageBus messageBus = this.messageBusMap.get(bindingObject);
        if (messageBus == null) {
            this.logger.trace("Subscribe listener to unknown message bus. Auto create requested bus!");
            this.createMessageBus(bindingObject, "AutoCreated_" + this.getObjectClassName(bindingObject));
            messageBus = this.messageBusMap.get(bindingObject);
        }
        messageBus.subscribe(listener);
    }

    protected void unsubscribeMessageListener(Object bindingObject, Object listener) {
        DefaultMessageBus messageBus = this.messageBusMap.get(bindingObject);
        if (messageBus != null) {
            messageBus.unsubscribe(listener);
        }
    }

    protected void initKernel(KernelParameters parameters) {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        if (this.kernelInitParameters != null) {
            this.logger.error("Failed to initialize kernel, it is already done!");
            return;
        }
        this.kernelInitParameters = parameters;
        this.kernelSettings = this.kernelInitParameters.getKernelSettingsImpl();
        this.logger.trace("::::::::::: Initialize kernel :::::::::::");
        this.kernelModules = new ConcurrentHashMap<Class<IKernelModule>, IKernelModule>();
        IApplicationKernel.KernelSettings kernelSettingsAnnotation = this.getClass().getAnnotation(IApplicationKernel.KernelSettings.class);
        if (this.kernelSettings == null) {
            Class<? extends IKernelSettings> settingsImpl = kernelSettingsAnnotation.settingsImpl();
            if (!settingsImpl.isInterface()) {
                this.logger.debug("No kernel settings object exists, but found kernel settings impl annonation for class: " + settingsImpl.getName());
                try {
                    Constructor<? extends IKernelSettings> constructor = settingsImpl.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.kernelSettings = constructor.newInstance(new Object[0]);
                    this.logger.debug("Kernel settings object created using class: " + settingsImpl.getSimpleName());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.kernelSettings == null) {
                this.logger.debug("No kernel settings object exists, create dummy object without persistence!");
                this.kernelSettings = new AKernelSettings(){

                    @Override
                    public boolean importSettings(String ... args) {
                        return false;
                    }

                    @Override
                    public boolean exportSettings(String ... args) {
                        return false;
                    }
                };
            }
        }
        this.kernelSettings.init();
        parameters.getBlacklistedModules().addAll(kernelSettingsAnnotation.blacklistedModules() == null ? null : Arrays.asList(kernelSettingsAnnotation.blacklistedModules()));
        this.priorityExexutorPool = new DynamicScheduledCachedThreadPoolExecutor("Priority", Runtime.getRuntime().availableProcessors(), 1024, 1L, TimeUnit.MINUTES, 8);
        this.logger.trace("Priority executor pool created.");
        this.backgroundExexutorPool = new DynamicScheduledCachedThreadPoolExecutor("Background", 2, 1024, 1L, TimeUnit.MINUTES, 6);
        this.logger.trace("Background executor pool created.");
        this.messageBusMap = new HashMap<Object, DefaultMessageBus>();
        DefaultMessageBus messageBus = MessageBusFactory.createDefaultMessageBus(this.getClass().getSimpleName(), this.logger);
        this.messageBusMap.put(this, messageBus);
        messageBus.subscribe(this);
        this.logger.trace("######### Loading kernel modules ########");
        if (kernelSettingsAnnotation != null && kernelSettingsAnnotation.staticModules() != null) {
            parameters.getStaticModules().addAll(Arrays.asList(kernelSettingsAnnotation.staticModules()));
        }
        if (!parameters.getStaticModules().isEmpty()) {
            this.logger.trace("############ Static modules #############");
            this.loadModules(parameters.getStaticModules());
            parameters.dynamicModules.removeAll(parameters.getStaticModules());
        }
        if (!parameters.getDynamicModules().isEmpty()) {
            this.logger.trace("############ Dynamic modules ############");
            this.loadModules(parameters.getDynamicModules());
        }
        this.logger.trace("#########################################");
        this.logger.trace("::::::::::: Kernel initialized ::::::::::");
        this.logger.trace("");
        this.printModuleSummary();
        this.logger.trace("");
    }

    protected void printModuleSummary() {
        LinkedList<String> moduleNames = new LinkedList<String>();
        for (Class<IKernelModule> moduleClass : this.kernelModules.keySet()) {
            moduleNames.add(moduleClass.getSimpleName());
        }
        this.logger.debug("*****************************************");
        this.logger.debug("Module summary:");
        this.logger.debug("*****************************************");
        Collections.sort(moduleNames);
        for (String name : moduleNames) {
            this.logger.debug(name);
        }
        this.logger.debug("*****************************************");
    }

    @Override
    public <T extends IKernelModule> T getModule(Class<T> moduleClass) {
        return (T)this.kernelModules.get(moduleClass);
    }

    @Override
    public <T extends IKernelModule> Collection<T> getAssignableModules(Class<T> moduleClass) {
        HashSet<IKernelModule> result = new HashSet<IKernelModule>();
        for (Map.Entry<Class<IKernelModule>, IKernelModule> moduleEntry : this.kernelModules.entrySet()) {
            if (!moduleClass.isAssignableFrom(moduleEntry.getKey())) continue;
            result.add(moduleEntry.getValue());
        }
        return result;
    }

    public boolean loadModules(Collection<Class<? extends IKernelModule>> modules) {
        boolean result = true;
        LinkedList<Class<? extends IKernelModule>> modulesToLoad = new LinkedList<Class<? extends IKernelModule>>(modules);
        Collections.sort(modulesToLoad, ModulePriorityComparator.getInstance());
        int i = 0;
        for (Class clazz : modulesToLoad) {
            if (i == 0) {
                this.logger.trace("-----------------------------------------");
            }
            result &= this.loadModule(clazz);
            this.logger.trace("-----------------------------------------");
            ++i;
        }
        return result;
    }

    @Override
    public <T extends IKernelModule> boolean loadModule(Class<T> clazz) {
        boolean result;
        if (this.kernelInitParameters.getBlacklistedModules().contains(clazz)) {
            this.logger.trace("Skip blacklisted module: " + clazz.getName());
            return false;
        }
        this.logger.trace("Try to load module " + clazz.getName());
        boolean bl = clazz != null ? !this.kernelModules.containsKey(clazz) : (result = false);
        if (result) {
            IKernelModule module = null;
            IKernelModule.ModuleSettings moduleSettings = clazz.getAnnotation(IKernelModule.ModuleSettings.class);
            result = moduleSettings != null;
            if (result) {
                Class<? extends IApplicationKernel> knl;
                boolean kernelIsSupported = false;
                Class<? extends IApplicationKernel>[] arr$ = moduleSettings.supportedKernels();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(kernelIsSupported = (knl = arr$[i$]).isAssignableFrom(this.getClass())); ++i$) {
                }
                result = kernelIsSupported;
                if (result) {
                    boolean dependenciesloaded;
                    boolean bl2 = dependenciesloaded = moduleSettings.dependencies().length == 0;
                    if (!dependenciesloaded) {
                        Class<? extends IKernelModule> dep;
                        this.logger.trace("Try to load module dependencies...");
                        this.logger.trace("++++++++++++++++++++++++++++++++++");
                        Class<? extends IKernelModule>[] arr$2 = moduleSettings.dependencies();
                        int len$2 = arr$2.length;
                        for (int i$ = 0; i$ < len$2 && (dependenciesloaded = this.loadModule(dep = arr$2[i$])); ++i$) {
                        }
                        this.logger.trace("++++++++++++++++++++++++++++++++++");
                    }
                    if (dependenciesloaded) {
                        try {
                            Constructor<T> constructor = clazz.getDeclaredConstructor(AApplicationKernel.class);
                            constructor.setAccessible(true);
                            module = (IKernelModule)constructor.newInstance(this);
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            this.logger.warn("No constructor with kernel parameter found! Fallback to default constructor.", (Throwable)e);
                        }
                        if (module == null) {
                            try {
                                module = (IKernelModule)clazz.newInstance();
                            }
                            catch (Exception e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                        boolean bl3 = result = module != null;
                        if (result) {
                            this.kernelModules.put(clazz, module);
                            module.init();
                            if (moduleSettings.kernelMsgBusEnabled()) {
                                this.subscribeKernelMessageListener(module);
                            }
                            this.logger.debug(clazz.getName() + " successfully loaded!");
                        } else {
                            this.logger.error("Faild to load " + clazz.getName());
                        }
                    } else {
                        this.logger.error("Failed to load dependencies! Skip loading of module " + clazz.getName() + ".");
                    }
                } else {
                    this.logger.error("Failed to load " + clazz.getName() + ". This module is not compatible with the used kernel.");
                }
            } else {
                this.logger.error("Needed annotation not found! Skip loading!");
            }
        } else {
            this.logger.trace(clazz.getName() + " is already loaded and will be skipped!");
            result = true;
        }
        return result;
    }

    @Override
    public <T extends IKernelModule> boolean unloadModule(Class<T> clazz) {
        boolean result = false;
        if (clazz == null) {
            return result;
        }
        if (this.isUnloadAllowed(clazz)) {
            IKernelModule module = this.kernelModules.remove(clazz);
            boolean bl = result = module != null;
            if (result) {
                module.unload();
                this.unsubscribeKernelMessageListener(module);
            }
        } else {
            this.logger.error("It is not allowed to unload module: " + clazz.getName());
        }
        return result;
    }

    protected boolean isUnloadAllowed(Class<? extends IKernelModule> module) {
        IApplicationKernel.KernelSettings kernelSettings = this.getClass().getAnnotation(IApplicationKernel.KernelSettings.class);
        List<Class<? extends IKernelModule>> staticModules = kernelSettings.staticModules() == null ? null : Arrays.asList(kernelSettings.staticModules());
        return !staticModules.contains(module);
    }

    protected boolean exportKernelSettings() {
        return this.kernelSettings.exportSettings();
    }

    protected boolean importKernelSettings() {
        return this.kernelSettings.importSettings();
    }

    @Override
    public void shutdown() {
        this.logger.trace("::::::::::::: Shutdown kernel :::::::::::");
        this.logger.trace("########## Unload kernel modules ########");
        Iterator<IKernelModule> itr = this.kernelModules.values().iterator();
        while (itr.hasNext()) {
            IKernelModule module = itr.next();
            this.logger.trace(module.getClass().getName());
            module.unload();
            this.unsubscribeKernelMessageListener(module);
            itr.remove();
        }
        this.logger.trace("#########################################");
        this.exportKernelSettings();
        this.kernelSettings.shutdown();
        this.logger.trace("Kernel settings exported.");
        this.logger.trace("Shutdown background executor pool...");
        this.backgroundExexutorPool.shutdown();
        this.logger.trace("Shutdown priority executor pool...");
        this.priorityExexutorPool.shutdown();
        for (DefaultMessageBus bus : this.messageBusMap.values()) {
            this.logger.trace("Shutdown " + bus.getName() + "...");
            bus.shutdown();
        }
        this.messageBusMap.clear();
        this.logger.trace("::::::::::: Shutdown completed ::::::::::");
    }

    protected String getObjectClassName(Object object) {
        String name = null;
        if (object instanceof Class) {
            Class clazz = (Class)object;
            name = clazz.getName();
        } else {
            name = object.getClass().getName();
        }
        return name;
    }

    @IKernelModule.ModuleSettings(supportedKernels={AApplicationKernel.class})
    public static abstract class KernelModule
    implements IKernelModule {
        protected final AApplicationKernel kernel;
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        protected final String uniqueID;

        public KernelModule(AApplicationKernel kernel) {
            this.kernel = Objects.requireNonNull(kernel, "kernel must not be null!");
            this.uniqueID = KernelModule.getUniqueID(this.getClass());
        }

        protected SyncAsyncPostCommand<Object> postKernelMessage(Object message) {
            return this.kernel.postKernelMessage(message);
        }

        protected void subscribeKernelMessageListener(Object listener) {
            this.kernel.subscribeKernelMessageListener(listener);
        }

        protected void unsubscribeKernelMessageListener(Object listener) {
            this.kernel.unsubscribeKernelMessageListener(listener);
        }

        protected void createMessageBus(Object bindingObject, String name) {
            this.kernel.createMessageBus(bindingObject, name);
        }

        protected SyncAsyncPostCommand<Object> postMessage(Object bindingObject, Object message) {
            return this.kernel.postMessage(bindingObject, message);
        }

        protected void subscribeMessageListener(Object bindingObject, Object listener) {
            this.kernel.subscribeMessageListener(bindingObject, listener);
        }

        protected void unsubscribeMessageListener(Object bindingObject, Object listener) {
            this.kernel.unsubscribeMessageListener(bindingObject, listener);
        }

        protected Map<String, String> getKernelSettings() {
            return this.kernel.getKernelSettings();
        }

        protected String getKernelSetting(Enum<?> key) {
            return this.kernel.getKernelSetting(key);
        }

        protected String getKernelSetting(String key) {
            return this.kernel.getKernelSetting(key);
        }

        protected Map<String, String> getKernelSettings(String ... keys) {
            return this.kernel.getKernelSettings(keys);
        }

        protected Map<String, String> getKernelSettings(Enum<?> ... keys) {
            return this.kernel.getKernelSettings(keys);
        }

        protected Map<String, String> getKernelStats() {
            return this.kernel.getKernelStats();
        }

        protected Map<String, String> getKernelStats(String ... keys) {
            return this.kernel.getKernelStats(keys);
        }

        protected void backgroundExecute(Runnable command) {
            this.kernel.backgroundExexutorPool.execute(command);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask backgroundScheduleAtFixedDelay(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
            return this.kernel.backgroundExexutorPool.scheduleAtFixedDelay(runnable, delay, interval, timeUnit);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask backgroundScheduleAtFixedDelayAndCount(Runnable runnable, long delay, long interval, TimeUnit timeUnit, long executeCount) {
            return this.kernel.backgroundExexutorPool.scheduleAtFixedDelayAndCount(runnable, delay, interval, timeUnit, executeCount);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask backgroundScheduleAtFixedRate(Runnable runnable, long delay, long rate, TimeUnit timeUnit) {
            return this.kernel.backgroundExexutorPool.scheduleAtFixedRate(runnable, delay, rate, timeUnit);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask backgroundScheduleAtFixedRateAndCount(Runnable runnable, long delay, long rate, TimeUnit timeUnit, long executeCount) {
            return this.kernel.backgroundExexutorPool.scheduleAtFixedRateAndCount(runnable, delay, rate, timeUnit, executeCount);
        }

        protected void putKernelSetting(String key, String value) {
            this.kernel.putKernelSetting(key, value);
        }

        protected void putKernelSetting(Enum<?> key, String value) {
            this.kernel.putKernelSetting(key, value);
        }

        protected boolean exportKernelSettings() {
            return this.kernel.exportKernelSettings();
        }

        protected void priorityExecute(Runnable command) {
            this.kernel.priorityExexutorPool.execute(command);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask priorityScheduleAtFixedDelay(Runnable runnable, long delay, long interval, TimeUnit timeUnit) {
            return this.kernel.priorityExexutorPool.scheduleAtFixedDelay(runnable, delay, interval, timeUnit);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask priorityScheduleAtFixedDelayAndCount(Runnable runnable, long delay, long interval, TimeUnit timeUnit, long executeCount) {
            return this.kernel.priorityExexutorPool.scheduleAtFixedDelayAndCount(runnable, delay, interval, timeUnit, executeCount);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask priorityScheduleAtFixedRate(Runnable runnable, long delay, long rate, TimeUnit timeUnit) {
            return this.kernel.priorityExexutorPool.scheduleAtFixedRate(runnable, delay, rate, timeUnit);
        }

        protected DynamicScheduledCachedThreadPoolExecutor.ScheduledTask priorityScheduleAtFixedRateAndCount(Runnable runnable, long delay, long rate, TimeUnit timeUnit, long executeCount) {
            return this.kernel.priorityExexutorPool.scheduleAtFixedRateAndCount(runnable, delay, rate, timeUnit, executeCount);
        }

        @Override
        public String getUniqueID() {
            return this.uniqueID;
        }

        public String getUniqueItemID(String appendedValue) {
            if (appendedValue == null) {
                return null;
            }
            return "[" + this.uniqueID + "]" + appendedValue;
        }

        public static String getUniqueID(Class<? extends IKernelModule> clazz) {
            String result = "";
            if (clazz != null) {
                IKernelModule.ModuleSettings moduleSettings = clazz.getAnnotation(IKernelModule.ModuleSettings.class);
                result = moduleSettings != null && !moduleSettings.uniqueID().isEmpty() ? moduleSettings.uniqueID() : new String(Hex.encodeHex((byte[])DigestUtils.md5((String)clazz.getName())));
            }
            return result;
        }
    }
}

