/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.session.manager;

import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionIdentifier
extends AIdentifier<ISession> {
    public static int SESSION_ID_PART = 0;
    private final String sessionID = this.getPathPart(SESSION_ID_PART);

    public SessionIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public static URI generateURI(String sessionID, String applicationID, String host) {
        if (sessionID != null && applicationID != null && host != null) {
            try {
                String uriString = ISession.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(sessionID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String sessionID, Environment environment) {
        return SessionIdentifier.generateURI(sessionID, Objects.requireNonNull(environment, "enviromentSettings must not be null!").getApplicationId(), environment.getHostID());
    }

    public static SessionIdentifier createIdentifierInstance(String sessionID, Environment environment) throws URISyntaxException {
        return new SessionIdentifier(SessionIdentifier.generateURI(sessionID, environment));
    }

    public static SessionIdentifier createIdentifierInstance(ISession session, Environment environment) throws URISyntaxException {
        return new SessionIdentifier(SessionIdentifier.generateURI(Objects.requireNonNull(session, "userCredential must not be null!").getSessionID(), environment));
    }

    @Override
    public ISession getObjectInstance() {
        return (ISession)this.environment.getSessionManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getSessionManager().removeObject(this);
    }

    @Override
    public boolean updateObject(ISession objectInstance) {
        return this.environment.getSessionManager().updateObject(objectInstance);
    }

    @Override
    public boolean saveObject() {
        return this.environment.getSessionManager().save(this);
    }

    public UserCredentialIdentifier getUserCredentialIdentifier() {
        ISession session = this.getObjectInstance();
        UserCredentialIdentifier userCredentialIdentifier = null;
        if (session != null) {
            userCredentialIdentifier = this.getEnvironment().getUserCredentialManager().getUserCredential(session.getUserCredentialID());
        }
        return userCredentialIdentifier;
    }

    public List<TransceiverController> getTransceiverControllers() {
        return this.getEnvironment().getTransceiverManager().getTransceiverControllersForSession(this);
    }

    public Map<String, String> getCapsMetaData() {
        return this.getObjectInstance().getCapsMetaData();
    }

    public boolean disconnect() {
        return this.getEnvironment().getTransceiverManager().disconnect(this);
    }

    public boolean isConnected() {
        return this.getEnvironment().getTransceiverManager().isConnected(this);
    }
}

