/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.session.impl;

import bsc.api.Enumerations;
import bsc.api.IUpdateableObject;
import bsc.sdk.api.user.session.ISession;
import bsc.sdk.api.user.session.SessionType;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Session
implements ISession {
    private static final long serialVersionUID = -1185359605229543442L;
    protected String sessionID = null;
    protected long timestamp = 0L;
    protected long lastUsedTimestamp = 0L;
    protected String userCredential;
    protected byte[] sharedSecret = null;
    protected Enumerations.ApiVersion apiVersion = null;
    protected Enumerations.CompressionType compressionType = null;
    protected Enumerations.EncryptionType encryptionType = null;
    protected Enumerations.ProtocolType protocolType = null;
    protected List<String> apiExtensions = null;
    protected Map<String, String> capsMetaData = null;
    protected SessionType sessionType = null;

    public Session() {
    }

    public Session(String sessionID) {
        this.setSessionID(sessionID);
    }

    public Session(ISession session) {
        this.updateObject(session);
    }

    @Override
    public boolean setSessionID(String sessionID) {
        boolean result;
        boolean bl = result = this.sessionID == null && sessionID != null && sessionID.length() != 0;
        if (result) {
            this.sessionID = sessionID;
        }
        return result;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean setTimestamp(long timestamp) {
        boolean result;
        boolean bl = result = this.timestamp == 0L;
        if (result) {
            this.timestamp = timestamp;
        }
        return result;
    }

    @Override
    public String getUserCredentialID() {
        return this.userCredential;
    }

    @Override
    public boolean setUserCredentialID(String userCredentialID) {
        boolean result;
        boolean bl = result = this.userCredential == null;
        if (result) {
            this.userCredential = userCredentialID;
        }
        return result;
    }

    @Override
    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    @Override
    public boolean setSharedSecret(byte[] sharedSecret) {
        boolean result;
        boolean bl = result = this.sharedSecret == null;
        if (result) {
            this.sharedSecret = sharedSecret;
        }
        return result;
    }

    @Override
    public Enumerations.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean setApiVersion(Enumerations.ApiVersion apiVersion) {
        boolean result;
        boolean bl = result = this.apiVersion == null;
        if (result) {
            this.apiVersion = apiVersion;
        }
        return result;
    }

    @Override
    public Enumerations.CompressionType getCompressionType() {
        return this.compressionType;
    }

    @Override
    public boolean setCompressionType(Enumerations.CompressionType compressionType) {
        boolean result;
        boolean bl = result = this.compressionType == null;
        if (result) {
            this.compressionType = compressionType;
        }
        return result;
    }

    @Override
    public Enumerations.EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    @Override
    public boolean setEncryptionType(Enumerations.EncryptionType encryptionType) {
        boolean result;
        boolean bl = result = this.encryptionType == null;
        if (result) {
            this.encryptionType = encryptionType;
        }
        return result;
    }

    @Override
    public Enumerations.ProtocolType getProtocolType() {
        return this.protocolType;
    }

    @Override
    public boolean setProtocolType(Enumerations.ProtocolType protocolType) {
        boolean result;
        boolean bl = result = this.protocolType == null;
        if (result) {
            this.protocolType = protocolType;
        }
        return result;
    }

    @Override
    public List<String> getApiExtensions() {
        if (this.apiExtensions == null) {
            return new ArrayList<String>();
        }
        return this.apiExtensions;
    }

    @Override
    public boolean setApiExtensions(List<String> apiExtensions) {
        boolean result;
        boolean bl = result = this.apiExtensions == null;
        if (result) {
            this.apiExtensions = apiExtensions;
        }
        return result;
    }

    @Override
    public int compareTo(ISession o) {
        long diff = this.getTimestamp() - o.getTimestamp();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public Map<String, String> getCapsMetaData() {
        if (this.capsMetaData == null) {
            return new HashMap<String, String>();
        }
        return this.capsMetaData;
    }

    @Override
    public boolean setCapsMetaData(Map<String, String> capsMetaData) {
        boolean result;
        boolean bl = result = this.capsMetaData == null;
        if (result) {
            this.capsMetaData = capsMetaData;
        }
        return result;
    }

    @Override
    public URI getURI(String applicationID, String host) {
        return SessionIdentifier.generateURI(this.sessionID, applicationID, host);
    }

    @Override
    public boolean setType(SessionType sessionType) {
        boolean result;
        boolean bl = result = this.sessionType == null;
        if (result) {
            this.sessionType = sessionType;
        }
        return result;
    }

    @Override
    public SessionType getType() {
        if (this.sessionType == null) {
            return SessionType.PRIVATE;
        }
        return this.sessionType;
    }

    @Override
    public boolean updateObject(IUpdateableObject objectInstance) {
        boolean result = objectInstance instanceof ISession;
        if (result) {
            ISession session = (ISession)objectInstance;
            result &= this.setSessionID(session.getSessionID());
            result &= this.setTimestamp(session.getTimestamp());
            result &= this.setUserCredentialID(session.getUserCredentialID());
            result &= this.setSharedSecret(session.getSharedSecret());
            result &= this.setApiVersion(session.getApiVersion());
            result &= this.setCompressionType(session.getCompressionType());
            result &= this.setEncryptionType(session.getEncryptionType());
            result &= this.setProtocolType(session.getProtocolType());
            result &= this.setApiExtensions(session.getApiExtensions());
            result &= this.setCapsMetaData(session.getCapsMetaData());
            result &= this.setType(session.getType());
        }
        return result;
    }

    @Override
    public boolean dataEquals(IUpdateableObject objectInstance) {
        boolean equals;
        block2: {
            equals = objectInstance instanceof ISession;
            if (!equals) break block2;
            ISession session = (ISession)objectInstance;
            equals &= this.getSessionID().equals(session.getSessionID());
            equals &= this.getTimestamp() == session.getTimestamp();
            equals &= this.getUserCredentialID().equals(session.getUserCredentialID());
            equals &= this.getSharedSecret().equals(session.getSessionID());
            equals &= this.getApiVersion().equals((Object)session.getApiVersion());
            equals &= this.getCompressionType().equals((Object)session.getCompressionType());
            equals &= this.getEncryptionType().equals((Object)session.getEncryptionType());
            equals &= this.getProtocolType().equals((Object)session.getProtocolType());
            equals &= this.getType().equals((Object)session.getType());
            equals &= this.getApiExtensions().size() == session.getApiExtensions().size() && this.getApiExtensions().containsAll(session.getApiExtensions());
            Map<String, String> cMeta = this.getCapsMetaData();
            if (equals &= cMeta.size() == session.getCapsMetaData().size()) {
                Map.Entry<String, String> entry;
                String value;
                Iterator<Map.Entry<String, String>> i$ = session.getCapsMetaData().entrySet().iterator();
                while (i$.hasNext() && (equals &= (value = cMeta.get((entry = i$.next()).getKey())) != null && value.equals(entry.getValue()))) {
                }
            }
        }
        return equals;
    }

    @Override
    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    @Override
    public void setLastUsedTimestamp(long lastUsedTimestamp) {
        this.lastUsedTimestamp = lastUsedTimestamp;
    }
}

