/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.group;

import bsc.sdk.api.user.group.IUserGroup;
import bsc.sdk.api.user.group.UserGroup;

public abstract class UserGroupFactory {
    private static UserGroupFactory defaultFactory = null;

    public static UserGroupFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = UserGroupFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(UserGroupFactory factory) {
        defaultFactory = factory;
    }

    public static UserGroupFactory createDefaultFactory() {
        return new UserGroupFactory(){

            @Override
            public IUserGroup createInstance(String name) {
                return new UserGroup(name);
            }

            @Override
            public IUserGroup createInstance(IUserGroup userGroup) {
                return new UserGroup(userGroup);
            }
        };
    }

    public static IUserGroup createNewInstance(String name) {
        return UserGroupFactory.getDefaultFactory().createInstance(name);
    }

    public static IUserGroup createNewInstance(IUserGroup userGroup) {
        return UserGroupFactory.getDefaultFactory().createInstance(userGroup);
    }

    public abstract IUserGroup createInstance(String var1);

    public abstract IUserGroup createInstance(IUserGroup var1);
}

