/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.credential;

import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.impl.DefaultUserCredentialFactory;
import java.util.Objects;

public abstract class AUserCredentialFactory {
    private static AUserCredentialFactory defaultFactory = null;

    public static AUserCredentialFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = AUserCredentialFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(AUserCredentialFactory factory) {
        defaultFactory = factory;
    }

    public static AUserCredentialFactory createDefaultFactory() {
        return new DefaultUserCredentialFactory();
    }

    public static IUserCredential createNewInstance(String user, String password) {
        return AUserCredentialFactory.getDefaultFactory().createInstance(Objects.requireNonNull(user, "user must not be null"), Objects.requireNonNull(password, "password must not be null"));
    }

    public static IUserCredential createNewInstance(IUserCredential userCredential) {
        return AUserCredentialFactory.getDefaultFactory().createInstance(Objects.requireNonNull(userCredential, "user must not be null"));
    }

    public abstract IUserCredential createInstance(String var1, String var2);

    public abstract IUserCredential createInstance(IUserCredential var1);
}

