/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.transmission.manager;

import bsc.api.transport.model.ProgressStatus;
import bsc.api.transport.result.Result;
import bsc.sdk.api.AManager;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.application.executors.INamedRunnable;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.idpool.IdPoolSettings;
import bsc.sdk.api.notification.transmission.error.TransmissionErrorNoResult;
import bsc.sdk.api.notification.transmission.status.TransmissionCreated;
import bsc.sdk.api.notification.transmission.status.TransmissionRemoved;
import bsc.sdk.api.notification.transmission.status.TransmissionResultDropped;
import bsc.sdk.api.notification.transmission.status.TransmissionResultReceived;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.transceiver.transmission.Progress;
import bsc.sdk.api.transceiver.transmission.manager.ITransmissionManager;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class ATransmissionManager
extends AManager<TransmissionIdentifier, ITransmission>
implements ITransmissionManager {
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask scheduledTask = null;
    private Executor command;
    private long timerPeriod = TimeUnit.MINUTES.toMillis(1L);
    private long noResultTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long keepTransmissionTimeout = TimeUnit.DAYS.toMillis(1L);
    private int keepMaxTransmissionObjects = 50;
    private HashMap<String, String> transmissionIDProgressMapping = new HashMap();
    private HashMap<String, Progress> progressObjects = new HashMap();

    public ATransmissionManager() {
    }

    public ATransmissionManager(long timerPeriod, long noResultTimeout, long keepTransmissionTimeout, int keepMaxResultObjects) {
        this.timerPeriod = timerPeriod;
        this.noResultTimeout = noResultTimeout;
        this.keepTransmissionTimeout = keepTransmissionTimeout;
        this.keepMaxTransmissionObjects = keepMaxResultObjects;
    }

    private void startTimer() {
        if (this.scheduledTask == null) {
            this.scheduledTask = this.getEnvironment().getApplication().getExecutorServiceBackgroundTasks().scheduleAtFixedDelay(this.command, this.timerPeriod, this.timerPeriod, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void _shutdown() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
        }
    }

    @Override
    protected void _init() {
        this.command = new Executor();
        this.startTimer();
    }

    @Override
    protected IdPoolSettings getIdPoolSettings() {
        return new IdPoolSettings(this.getClass().getName(), IdPool.GENERATOR_TYPE.RANDOM, this.keepTransmissionTimeout, "", "", 25, "", 0);
    }

    @Override
    protected ITransmission getNewObjectInstance(ITransmission orgObject) {
        return orgObject;
    }

    public long getNoResultTimeout() {
        return this.noResultTimeout;
    }

    public void setNoResultTimeout(long noResultTimeout) {
        this.noResultTimeout = noResultTimeout;
    }

    public long getKeepTransmissionTimeout() {
        return this.keepTransmissionTimeout;
    }

    public void setKeepTransmissionTimeout(long keepTransmissionTimeout) {
        this.keepTransmissionTimeout = keepTransmissionTimeout;
        this.idPool.setTimeToLive(keepTransmissionTimeout);
    }

    public int getKeepMaxTransmissionObjects() {
        return this.keepMaxTransmissionObjects;
    }

    public void setKeepMaxTransmissionObjects(int keepMaxTransmissionObjects) {
        this.keepMaxTransmissionObjects = keepMaxTransmissionObjects;
    }

    @Override
    public boolean attachResult(String transmissionId, Result result) {
        ITransmission transmission;
        TransmissionIdentifier identifier = null;
        try {
            identifier = TransmissionIdentifier.createIdentifierInstance(transmissionId, this.getEnvironment());
        }
        catch (URISyntaxException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (identifier != null && (transmission = (ITransmission)this.objects.get(identifier.getFullQualifiedIdentifiableString())) != null) {
            if (transmission.getResult() == null) {
                transmission.setResult(result);
                this.fireNotification(new TransmissionResultReceived(identifier, result));
                return true;
            }
            this.fireNotification(new TransmissionResultDropped(identifier, TransmissionResultDropped.REASON.TRANSMISSION_HAS_RESULT));
        }
        return false;
    }

    @Override
    public String getUniqueTransmissionId() {
        return this.getUniqueID();
    }

    @Override
    public TransmissionIdentifier addObject(ITransmission object) {
        TransmissionIdentifier identifier = (TransmissionIdentifier)super.addObject(object);
        this.fireNotification(new TransmissionCreated(identifier));
        return identifier;
    }

    @Override
    public Collection<TransmissionIdentifier> addObject(Collection<ITransmission> object) {
        HashSet<TransmissionIdentifier> result = new HashSet<TransmissionIdentifier>();
        for (ITransmission transmission : object) {
            result.add((TransmissionIdentifier)super.addObject(transmission));
        }
        return result;
    }

    @Override
    public boolean attachProgressStatus(ProgressStatus progressStatus) {
        boolean result = false;
        String progressID = progressStatus.getProgressID();
        Progress progress = this.progressObjects.get(progressID);
        if (progress != null) {
            result = progress.attachProgressStatus(progressStatus);
        }
        return result;
    }

    @Override
    public boolean removeObject(TransmissionIdentifier objectIdentifier) {
        Progress progress;
        String progressID = this.transmissionIDProgressMapping.get(objectIdentifier.getTransmissionID());
        if (progressID != null && (progress = this.progressObjects.get(progressID)) != null) {
            if (!progress.isFinished()) {
                progress.attachProgressStatus(new ProgressStatus(progress.getProgressID(), ProgressStatus.STATE.DROPPED));
            }
            this.progressObjects.remove(progressID);
        }
        this.freeID(objectIdentifier.getTransmissionID());
        return super.removeObject(objectIdentifier);
    }

    @Override
    public void objectReceived(String tag, Object object) {
    }

    private class Executor
    implements INamedRunnable {
        private Executor() {
        }

        @Override
        public void run() {
            ATransmissionManager.this.logger.trace("Cleanup transmissions (interval=" + ATransmissionManager.this.timerPeriod + "ms)");
            int toRemoveCount_old = ATransmissionManager.this.objects.size() - ATransmissionManager.this.keepMaxTransmissionObjects;
            if (toRemoveCount_old > 0) {
                ArrayList list = new ArrayList(ATransmissionManager.this.objects.values());
                Collections.sort(list);
                List toRemove = list.subList(ATransmissionManager.this.keepMaxTransmissionObjects, list.size());
                for (ITransmission iTransmission : toRemove) {
                    ATransmissionManager.this.fireNotification(new TransmissionRemoved((TransmissionIdentifier)ATransmissionManager.this.getIdentifierInstance(iTransmission), TransmissionRemoved.REASON.MAX_OBJECTS_REACHED));
                    ATransmissionManager.this.removeObject((TransmissionIdentifier)ATransmissionManager.this.getIdentifierInstance(iTransmission));
                }
            } else {
                toRemoveCount_old = 0;
            }
            int toRemoveCount_missing = 0;
            int toRemoveCount_timeout = 0;
            for (ITransmission transmission : ATransmissionManager.this.objects.values()) {
                TransmissionIdentifier identifier = (TransmissionIdentifier)ATransmissionManager.this.getEnvironment().getTransmissionManager().getIdentifierInstance(transmission);
                long timestamp = System.currentTimeMillis();
                if (transmission.getResult() == null && transmission.getCreationTimestamp() + ATransmissionManager.this.noResultTimeout < timestamp) {
                    ATransmissionManager.this.fireNotification(new TransmissionErrorNoResult(identifier));
                    ATransmissionManager.this.fireNotification(new TransmissionRemoved(identifier, TransmissionRemoved.REASON.NO_RESULT));
                    ATransmissionManager.this.removeObject(identifier);
                    ++toRemoveCount_missing;
                    continue;
                }
                if (transmission.getCreationTimestamp() + ATransmissionManager.this.keepTransmissionTimeout >= timestamp) continue;
                ATransmissionManager.this.fireNotification(new TransmissionRemoved(identifier, TransmissionRemoved.REASON.TRANSMISSION_TTL));
                ATransmissionManager.this.removeObject(identifier);
                ++toRemoveCount_timeout;
            }
            int toRemoveCount = toRemoveCount_missing + toRemoveCount_old + toRemoveCount_timeout;
            ATransmissionManager.this.logger.trace("Remove " + toRemoveCount + " transmissions (old=" + toRemoveCount_old + " no_result=" + toRemoveCount_missing + " timeout=" + toRemoveCount_timeout + ")");
        }

        @Override
        public String getName() {
            return this.getClass().getSimpleName() + "->Worker";
        }
    }
}

