/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.state;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.transceiver.RemoteException;
import bsc.sdk.api.notification.INotification;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;

public abstract class ATransceiverState
implements ITransceiverState {
    public static final int LEVEL_0 = 0;
    public static final int LEVEL_1 = 1;
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    public static final int LEVEL_4 = 4;
    public static final int LEVEL_5 = 5;
    protected TransceiverIdentifier identifier;
    protected Environment environment;
    protected TransceiverController controller;

    public ATransceiverState(StateConfiguration stateSettings) {
        this.identifier = stateSettings.getTransceiverIdentifier();
        this.environment = stateSettings.getEnvironment();
        this.controller = this.environment.getTransceiverManager().getTransceiverControllerInstance(this.identifier);
    }

    protected void fireNotification(INotification notification) {
        if (this.environment != null) {
            this.environment.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)notification);
        }
    }

    protected void checkResult(Result result) throws TransceiverException {
        if (result instanceof FailResult) {
            FailResult failResult = (FailResult)result;
            throw new RemoteException(failResult);
        }
    }

    protected void checkResult(Object object) throws TransceiverException {
        if (object instanceof FailResult) {
            FailResult failResult = (FailResult)object;
            throw new RemoteException(failResult);
        }
    }

    protected void checkResult(TransmissionObject transmissionObject) throws TransceiverException {
        IApiObject object = transmissionObject.getObject();
        this.checkResult(object);
    }

    protected <T> T checkResult(Object object, Class<?> clazz) throws TransceiverException {
        if (object instanceof FailResult) {
            FailResult failResult = (FailResult)object;
            throw new RemoteException(failResult);
        }
        if (object instanceof ObjectResult) {
            ObjectResult objectResult = (ObjectResult)object;
            object = objectResult.getObject();
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new TransceiverException(Enumerations.ErrorType.UNEXPECTED_RESULT, "Unexpected result from client");
        }
        return (T)object;
    }

    protected <T> T checkResult(TransmissionObject transmissionObject, Class<?> clazz) throws TransceiverException {
        IApiObject object = transmissionObject.getObject();
        return this.checkResult(object, clazz);
    }

    protected String getNewTransmissionId() {
        return this.getEnvironment().getTransmissionManager().getUniqueTransmissionId();
    }

    protected Environment getEnvironment() {
        return this.environment;
    }
}

