/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.manager;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.basic.commands.Command;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.transmission.FutureTransmission;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.session.manager.SessionIdentifier;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.Set;

public class TransceiverIdentifier
extends AIdentifier<ITransceiver> {
    public static int TRANSCEIVER_ID_PART = 0;
    private final String transceiverID = this.getPathPart(TRANSCEIVER_ID_PART);

    public TransceiverIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public static URI generateURI(String transceiverID, String applicationID, String host) {
        if (transceiverID != null && applicationID != null && host != null) {
            try {
                String uriString = ITransceiver.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(transceiverID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String transceiverID, Environment enviromentSettings) {
        return TransceiverIdentifier.generateURI(transceiverID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static TransceiverIdentifier createIdentifierInstance(String transceiverID, Environment enviromentSettings) throws URISyntaxException {
        return new TransceiverIdentifier(TransceiverIdentifier.generateURI(transceiverID, enviromentSettings));
    }

    public static TransceiverIdentifier createIdentifierInstance(ITransceiver transceiver, Environment enviromentSettings) throws URISyntaxException {
        return new TransceiverIdentifier(TransceiverIdentifier.generateURI(Objects.requireNonNull(transceiver, "userCredential must not be null!").getTransceiverID(), enviromentSettings));
    }

    public String getTransceiverID() {
        return this.transceiverID;
    }

    public TransceiverController getControllerInstance() {
        return this.environment.getTransceiverManager().getTransceiverControllerInstance(this);
    }

    public FutureTransmission sendCommand(Command command) {
        TransceiverController controller = this.getControllerInstance();
        if (controller != null && command != null) {
            return controller.sendCommand(command);
        }
        return null;
    }

    public FutureTransmission sendObject(IApiObject object) {
        TransceiverController controller;
        if (object != null && (controller = this.getControllerInstance()) != null) {
            return controller.sendObject(object);
        }
        return null;
    }

    public SessionIdentifier getSessionIdentifier() {
        TransceiverController controller = this.getControllerInstance();
        if (controller != null) {
            return controller.getCurrentSessionID();
        }
        return null;
    }

    public UserCredentialIdentifier getUserCredentialIdentifier() {
        SessionIdentifier sessionIdentifier = this.getSessionIdentifier();
        UserCredentialIdentifier userCredentialIdentifier = null;
        if (sessionIdentifier != null) {
            userCredentialIdentifier = sessionIdentifier.getUserCredentialIdentifier();
        }
        return userCredentialIdentifier;
    }

    public Set<String> getSubscriptionList() {
        return this.environment.getExtensionManager().getSubscriptionList(this);
    }

    @Override
    public ITransceiver getObjectInstance() {
        return (ITransceiver)this.environment.getTransceiverManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getTransceiverManager().removeObject(this);
    }

    @Override
    public boolean updateObject(ITransceiver objectInstance) {
        return false;
    }

    @Override
    public boolean saveObject() {
        return this.environment.getTransceiverManager().save(this);
    }

    public InetSocketAddress getRemoteAddress() {
        return this.getControllerInstance().getRemoteAddress();
    }

    public double getIncomingThroughputPerSecond() {
        return this.getControllerInstance().getThroughputIn();
    }

    public double getOutgoingThroughputPerSecond() {
        return this.getControllerInstance().getThroughputOut();
    }

    public long getAverageLatency() {
        return this.getControllerInstance().getAverageLatency();
    }

    public boolean isSubscribedFor(Enumerations.EXTENSION_ID extension) {
        return this.environment.getExtensionManager().isSubscribedFor(this, extension);
    }

    public boolean isSubscribedFor(String extensionID) {
        return this.environment.getExtensionManager().isSubscribedFor(this, extensionID);
    }
}

