/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.controller.qos;

import bsc.api.transport.model.Ping;
import bsc.sdk.api.application.executors.INamedRunnable;
import bsc.sdk.api.transceiver.controller.ATransceiverController;
import bsc.sdk.api.transceiver.transmission.FutureTransmission;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyChecker
implements INamedRunnable {
    public static final long timeout = TimeUnit.SECONDS.toMillis(45L);
    protected final ATransceiverController controller;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long[] latencyTimes;
    private int latencyTimesCurrentIndex = 0;

    public LatencyChecker(ATransceiverController controller, int latencyCacheSize) {
        this.controller = controller;
        this.latencyTimes = new long[latencyCacheSize];
        do {
            this.addLatencyTime(0L);
        } while (this.latencyTimesCurrentIndex != 0);
    }

    @Override
    public void run() {
        this.addLatencyTime(this.determineLatency());
    }

    protected long determineLatency() {
        this.logger.trace("Determine latency");
        FutureTransmission ft = this.controller.sendObject(new Ping());
        TransmissionIdentifier ti = ft.getTransmissionIdentifier(true);
        long maxRuntime = System.currentTimeMillis() + timeout;
        while (ti.getResult() == null && maxRuntime > System.currentTimeMillis()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ti.getResult() == null) {
            return timeout;
        }
        return ti.getResultTimestamp() - ti.getCreationTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageLatency() {
        long[] lArray = this.latencyTimes;
        synchronized (this.latencyTimes) {
            long sum = 0L;
            int zeros = 0;
            for (int i = 0; i < this.latencyTimes.length; ++i) {
                long value = this.latencyTimes[i];
                if (value == 0L) {
                    ++zeros;
                    continue;
                }
                sum += value;
            }
            long latencyCounter = this.latencyTimes.length - zeros;
            if (latencyCounter == 0L) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sum / latencyCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLatencyTime(long latencyTime) {
        if (latencyTime <= 0L) {
            return;
        }
        long[] lArray = this.latencyTimes;
        synchronized (this.latencyTimes) {
            this.latencyTimes[this.latencyTimesCurrentIndex] = latencyTime;
            ++this.latencyTimesCurrentIndex;
            if (this.latencyTimesCurrentIndex == this.latencyTimes.length) {
                this.latencyTimesCurrentIndex = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "->" + this.controller.getTransceiverIdentifier().getTransceiverID();
    }
}

