/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.controller.impl;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.commands.Command;
import bsc.api.basic.container.ObjectContainer;
import bsc.api.basic.container.TYPE;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.camera.model.CameraFrame;
import bsc.api.modules.camera.model.FrameContainer;
import bsc.api.modules.camera.model.IModelCamera;
import bsc.api.modules.qos.QoSMode;
import bsc.api.modules.qos.model.QoSConfiguration;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.extension.modules.qos.notification.AddMetaDataHandler;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.transceiver.ITransceiver;
import bsc.sdk.api.transceiver.controller.ATransceiverController;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.controller.qos.IDynamicQoS;
import bsc.sdk.api.transceiver.controller.qos.LatencyChecker;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import bsc.sdk.api.transceiver.transmission.FutureTransmission;
import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicQoS
implements IDynamicQoS,
ITransceiverListener {
    private static Logger logger = LoggerFactory.getLogger(DynamicQoS.class);
    private final TransceiverController controller;
    private final String transceiverID;
    private final HashSet<Integer> grpIdWhitelist = new HashSet();
    private final HashSet<String> deviceIdWhitelist = new HashSet();
    private QoSMode mode = QoSMode.MEDIA_PRIORITY;
    private int updateIntervalObjects = 1;
    private int updateIntervalFrames = 1;
    protected final Map<String, IIdentifiableApiObject> pendingUpdates = new ConcurrentHashMap<String, IIdentifiableApiObject>();
    protected final Map<Command, FutureTransmission> pendingCommands = new LinkedHashMap<Command, FutureTransmission>();
    protected final Map<String, CameraFrame> pendingCameraFrames = new ConcurrentHashMap<String, CameraFrame>();
    private final Environment environment;
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask objectUpdatesScheduledTask = null;
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask framesScheduledTask = null;
    private DynamicScheduledCachedThreadPoolExecutor.ScheduledTask latencyScheduledTask = null;
    private final DynamicScheduledCachedThreadPoolExecutor executorService;
    private FutureTransmission currentFurureTransmission = new FutureTransmission();
    private FutureTransmission currentCameraFrameFurureTransmission = new FutureTransmission();
    private boolean transceiverIsReady = false;
    private long averageLatency = 0L;
    private long autoLatencyThresholdLow = 0L;
    private long autoLatencyThresholdHigh = 0L;
    private AUTO_MODE_LEVEL autoModeLevel = AUTO_MODE_LEVEL.LOW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureTransmission flushPendingUpdates() {
        FutureTransmission result = this.currentFurureTransmission;
        if (this.transceiverIsReady) {
            Map<String, IIdentifiableApiObject> map = this.pendingUpdates;
            synchronized (map) {
                int pendingUpdatesSize = this.pendingUpdates.size();
                if (pendingUpdatesSize > 0) {
                    logger.trace("Process " + pendingUpdatesSize + " pending object updates for transceiver " + this.transceiverID + " (update interval " + this.updateIntervalObjects + ")");
                }
                TransmissionIdentifier transmissionIdentifier = null;
                if (pendingUpdatesSize > 1) {
                    ObjectContainer objectContainer = new ObjectContainer(TYPE.INCREMENTAL, this.pendingUpdates.values());
                    this.pendingUpdates.clear();
                    transmissionIdentifier = this.sendObjectToTransceiver(objectContainer).getTransmissionIdentifier(true);
                } else if (pendingUpdatesSize == 1) {
                    Iterator<IIdentifiableApiObject> i$ = this.pendingUpdates.values().iterator();
                    if (i$.hasNext()) {
                        IIdentifiableApiObject object = i$.next();
                        transmissionIdentifier = this.sendObjectToTransceiver(object).getTransmissionIdentifier(true);
                    }
                    this.pendingUpdates.clear();
                }
                if (transmissionIdentifier != null) {
                    this.currentFurureTransmission.setTransmissionIdentifier(transmissionIdentifier);
                    this.currentFurureTransmission = new FutureTransmission();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushPendingCommands() {
        if (this.transceiverIsReady) {
            Map<Command, FutureTransmission> map = this.pendingCommands;
            synchronized (map) {
                int pendingCommandsSize = this.pendingCommands.size();
                if (pendingCommandsSize > 0) {
                    logger.trace("Process " + pendingCommandsSize + " pending commands for transceiver " + this.transceiverID + " (update interval " + this.updateIntervalObjects + ")");
                    for (Map.Entry<Command, FutureTransmission> entry : this.pendingCommands.entrySet()) {
                        FutureTransmission ft = this.sendCommandToTransceiver(entry.getKey());
                        entry.getValue().setTransmissionIdentifier(ft.getTransmissionIdentifier(true));
                    }
                    this.pendingCommands.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureTransmission flushPendingFrames() {
        FutureTransmission result = this.currentCameraFrameFurureTransmission;
        Map<String, CameraFrame> map = this.pendingCameraFrames;
        synchronized (map) {
            if (!this.pendingCameraFrames.isEmpty()) {
                logger.trace(this.pendingCameraFrames.size() + " pending camera frames for transceiver " + this.transceiverID + " (update interval " + this.updateIntervalObjects + ")");
            }
            for (CameraFrame frame : this.pendingCameraFrames.values()) {
                this.sendObjectToTransceiver(frame);
            }
            this.pendingCameraFrames.clear();
            if (!this.pendingCameraFrames.isEmpty()) {
                int pendingFramesSize = this.pendingCameraFrames.size();
                logger.trace("Sending " + pendingFramesSize + " pending camera frames for transceiver " + this.transceiverID + " (update interval " + this.updateIntervalObjects + ")");
                IModelCamera objectToSend = null;
                if (pendingFramesSize == 1) {
                    for (CameraFrame frame : this.pendingCameraFrames.values()) {
                        objectToSend = frame;
                    }
                } else {
                    FrameContainer container = new FrameContainer();
                    container.addAllFrames(this.pendingCameraFrames.values());
                    objectToSend = container;
                }
                this.pendingCameraFrames.clear();
                TransmissionIdentifier transmissionIdentifier = null;
                if (objectToSend != null) {
                    transmissionIdentifier = this.sendObjectToTransceiver(objectToSend).getTransmissionIdentifier(true);
                }
                if (transmissionIdentifier != null) {
                    this.currentCameraFrameFurureTransmission.setTransmissionIdentifier(transmissionIdentifier);
                    this.currentCameraFrameFurureTransmission = new FutureTransmission();
                }
            }
        }
        return result;
    }

    public DynamicQoS(ATransceiverController controller) {
        if (!(controller instanceof TransceiverController)) {
            throw new InvalidParameterException("controller must be an instance of TransceiverController!");
        }
        this.controller = (TransceiverController)Objects.requireNonNull(controller, "controller must not be null!");
        this.environment = controller.getTransceiver().getEnvironment();
        this.controller.getTransceiver().addTransceiverListener(this);
        this.transceiverID = this.controller.getTransceiver().getTransceiverID();
        this.executorService = this.environment.getApplication().getExecutorServiceBackgroundTasks();
        this.applyMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureTransmission sendCommand(Command command) {
        if (this.transceiverIsReady) {
            return this.sendCommandToTransceiver(command);
        }
        FutureTransmission ft = new FutureTransmission();
        Map<Command, FutureTransmission> map = this.pendingCommands;
        synchronized (map) {
            this.pendingCommands.put(command, ft);
        }
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FutureTransmission sendObject(IApiObject object) {
        ADevice device;
        boolean force = false;
        boolean isDevice = object instanceof ADevice;
        boolean isSensor = false;
        boolean isCameraFrame = false;
        if (!isDevice && !(isSensor = object instanceof ISensor)) {
            isCameraFrame = object instanceof CameraFrame;
        }
        ObjectIdentifier identifier = null;
        if (this.isEnabled()) {
            void var7_12;
            Object var7_7 = null;
            ArrayList<Integer> grpIDs = new ArrayList<Integer>();
            if (isDevice) {
                ADevice dev = (ADevice)object;
                identifier = (ObjectIdentifier)this.environment.getObjectManager().getIdentifierInstance(dev);
                String string = dev.getDeviceID();
                grpIDs.addAll(dev.getGrpIDs());
            } else if (isSensor) {
                ISensor sensor = (ISensor)object;
                identifier = (ObjectIdentifier)this.environment.getObjectManager().getIdentifierInstance(sensor);
                try {
                    DeviceIdentifier deviceIdentifier = DeviceIdentifier.createIdentifierInstance(sensor.getDeviceID(), this.environment);
                    device = (ADevice)deviceIdentifier.getObjectInstance();
                    String string = device.getDeviceID();
                    grpIDs.addAll(device.getGrpIDs());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            } else if (isCameraFrame) {
                CameraFrame frame = (CameraFrame)object;
                String string = frame.getCameraID();
                try {
                    identifier = DeviceIdentifier.createIdentifierInstance(string, this.environment);
                    ADevice device2 = (ADevice)identifier.getObjectInstance();
                    grpIDs.addAll(device2.getGrpIDs());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (var7_12 != null && this.deviceIdWhitelist.contains(var7_12)) {
                force = true;
            } else {
                for (Integer grpID : grpIDs) {
                    if (!this.grpIdWhitelist.contains(grpID)) continue;
                    force = true;
                    break;
                }
            }
            if (force) {
                logger.trace("Object (" + identifier.getFullQualifiedIdentifiableString() + ") is whitelisted, skip QoS cache!");
            }
        }
        if (force || identifier == null) return this.sendObjectToTransceiver(object);
        if (isCameraFrame) {
            Map<String, CameraFrame> map = this.pendingCameraFrames;
            synchronized (map) {
                CameraFrame frame = (CameraFrame)object;
                this.pendingCameraFrames.put(frame.getCameraID(), frame);
            }
            logger.trace("Add frame to pending camera frames (" + identifier.getFullQualifiedIdentifiableString() + ")");
        } else {
            Map<String, IIdentifiableApiObject> map = this.pendingUpdates;
            synchronized (map) {
                if (isDevice) {
                    ADevice device3 = (ADevice)object;
                    for (ISensor sensor : device3.getSensors()) {
                        try {
                            SensorIdentifier sensorIdentifier = SensorIdentifier.createIdentifierInstance(sensor, this.environment);
                            String fqis = sensorIdentifier.getFullQualifiedIdentifiableString();
                            if (!this.pendingUpdates.containsKey(fqis)) continue;
                            this.pendingUpdates.remove(fqis);
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    logger.trace("Add device to pending updates " + identifier.getFullQualifiedIdentifiableString());
                    this.pendingUpdates.put(identifier.getFullQualifiedIdentifiableString(), (IIdentifiableApiObject)object);
                } else if (isSensor) {
                    try {
                        ISensor sensor = (ISensor)object;
                        DeviceIdentifier deviceIdentifier = DeviceIdentifier.createIdentifierInstance(sensor.getDeviceID(), this.environment);
                        String fqis = deviceIdentifier.getFullQualifiedIdentifiableString();
                        if (this.pendingUpdates.containsKey(fqis)) {
                            logger.trace("Update sensor inside device on pending updates " + identifier.getFullQualifiedIdentifiableString());
                            device = (ADevice)this.pendingUpdates.get(fqis);
                            device.removeSensor(device.getSensorByName(sensor.getName()));
                            device.addSensor(sensor);
                        } else {
                            logger.trace("Add sensor to pending updates " + identifier.getFullQualifiedIdentifiableString());
                            this.pendingUpdates.put(identifier.getFullQualifiedIdentifiableString(), (IIdentifiableApiObject)object);
                        }
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (!isCameraFrame) return this.currentFurureTransmission;
        return this.currentCameraFrameFurureTransmission;
    }

    private FutureTransmission sendCommandToTransceiver(Command command) {
        return this.controller.sendCommand(command, false);
    }

    private FutureTransmission sendObjectToTransceiver(IApiObject object) {
        return this.controller.sendObjectWithoutChecksAndValidation(object);
    }

    @Override
    public boolean isEnabled() {
        return !this.mode.equals((Object)QoSMode.DISABLED);
    }

    @Override
    public void setMode(QoSMode mode) {
        this.mode = mode;
        this.applyMode();
    }

    private void applyMode() {
        this.disableLatencyChecker();
        switch (this.mode) {
            case CUSTOM: {
                break;
            }
            case AUTO: {
                this.enableLatencyChecker();
            }
            default: {
                this.updateIntervalObjects = 1;
                this.updateIntervalFrames = 1;
                break;
            }
            case RESPONSE_PRIORITY: {
                this.updateIntervalObjects = 1;
                this.updateIntervalFrames = 5;
                break;
            }
            case POLLING: {
                this.mode = QoSMode.POLLING;
                this.updateIntervalObjects = 0;
                this.updateIntervalFrames = 0;
                break;
            }
            case DISABLED: {
                this.flushPendingUpdates();
                this.flushPendingFrames();
                this.flushPendingCommands();
                this.updateIntervalObjects = -1;
                this.updateIntervalFrames = -1;
            }
        }
        this.disableUpdateHandler();
        this.enableUpdateHandler();
    }

    @Override
    public void stateChanged(ITransceiver transceiver, ITransceiver.TransceiverState state) {
        switch (state) {
            case CONNECTED: {
                break;
            }
            case DISCONNECTED: {
                this.disableLatencyChecker();
                this.disableUpdateHandler();
                this.controller.getTransceiver().removeTransceiverListener(this);
                break;
            }
            case READY: {
                this.transceiverIsReady = true;
                String initMode = this.controller.getCurrentSessionID().getCapsMetaData().get(AMetaInformation.buildExtensionKey(Enumerations.EXTENSION_ID.QoS.name(), AddMetaDataHandler.KEYS.INIT_MODE.name()));
                if (initMode != null) {
                    QoSMode preferredMode = QoSMode.valueOf(initMode);
                    if (preferredMode != null) {
                        this.mode = preferredMode;
                    }
                } else if (this.controller.getTransceiverIdentifier().isSubscribedFor(Enumerations.EXTENSION_ID.QoS)) {
                    this.mode = QoSMode.AUTO;
                    this.sendQoSConfigurationAfterDelay(1000L);
                } else {
                    this.mode = QoSMode.DISABLED;
                }
                this.applyMode();
            }
        }
    }

    protected void sendQoSConfigurationAfterDelay(long delay) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DynamicQoS.this.sendObjectToTransceiver(DynamicQoS.this.getQoSConfiguration());
            }
        };
        this.environment.getApplication().getExecutorServiceBackgroundTasks().scheduleOnce(runnable, delay, TimeUnit.MILLISECONDS);
    }

    private void enableLatencyChecker() {
        if (this.latencyScheduledTask == null) {
            logger.trace(this.transceiverID + " | Enable latency monitoring");
            this.latencyScheduledTask = this.executorService.scheduleAtFixedDelay(new AutoModeLatencyMonitor(this.controller), 20L, 20L, TimeUnit.SECONDS);
        }
    }

    private void disableLatencyChecker() {
        if (this.latencyScheduledTask != null) {
            logger.trace(this.transceiverID + " | Disable latency monitoring");
            this.latencyScheduledTask.cancel();
            this.latencyScheduledTask = null;
        }
    }

    private void enableUpdateHandler() {
        if (this.objectUpdatesScheduledTask == null && this.updateIntervalObjects > 0) {
            logger.trace("Enable pending update handler");
            this.objectUpdatesScheduledTask = this.executorService.scheduleAtFixedDelay(new PendingUpdateHandler(), this.updateIntervalObjects, this.updateIntervalObjects, TimeUnit.SECONDS);
        }
        if (this.framesScheduledTask == null && this.updateIntervalFrames > 0) {
            logger.trace("Enable pending frames handler");
            this.framesScheduledTask = this.executorService.scheduleAtFixedDelay(new PendingFrameHandler(), this.updateIntervalFrames, this.updateIntervalFrames, TimeUnit.SECONDS);
        }
    }

    private void disableUpdateHandler() {
        if (this.objectUpdatesScheduledTask != null) {
            logger.trace("Disable pending update handler");
            this.objectUpdatesScheduledTask.cancel();
            this.objectUpdatesScheduledTask = null;
        }
        if (this.framesScheduledTask != null) {
            logger.trace("Disable pending frames handler");
            this.framesScheduledTask.cancel();
            this.framesScheduledTask = null;
        }
    }

    @Override
    public void errorOccurred(ITransceiver transceiver, TransceiverException transceiverException) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceWhitelist(Collection<String> deviceIDs) {
        HashSet<String> hashSet = this.deviceIdWhitelist;
        synchronized (hashSet) {
            this.deviceIdWhitelist.clear();
            if (deviceIDs != null) {
                this.deviceIdWhitelist.addAll(this.deviceIdWhitelist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getDeviceWhitelist() {
        HashSet<String> hashSet = this.deviceIdWhitelist;
        synchronized (hashSet) {
            return new HashSet<String>(this.deviceIdWhitelist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroupWhitelist(Collection<Integer> grpIDs) {
        HashSet<Integer> hashSet = this.grpIdWhitelist;
        synchronized (hashSet) {
            this.grpIdWhitelist.clear();
            if (grpIDs != null) {
                this.grpIdWhitelist.addAll(grpIDs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getGroupWhitelist() {
        HashSet<Integer> hashSet = this.grpIdWhitelist;
        synchronized (hashSet) {
            return new HashSet<Integer>(this.grpIdWhitelist);
        }
    }

    @Override
    public int getUpdateIntervalObjects() {
        return this.updateIntervalObjects;
    }

    @Override
    public int getUpdateIntervalFrames() {
        return this.updateIntervalFrames;
    }

    @Override
    public void setUpdateIntervalObjects(int updateIntervalObjects) {
        if (updateIntervalObjects != this.updateIntervalObjects && this.mode.equals((Object)QoSMode.CUSTOM)) {
            this.disableUpdateHandler();
            this.updateIntervalObjects = updateIntervalObjects;
            if (this.updateIntervalObjects > 0) {
                this.enableUpdateHandler();
            }
        }
    }

    @Override
    public void setUpdateIntervalFrames(int updateIntervalFrames) {
        if (updateIntervalFrames != this.updateIntervalObjects && this.mode.equals((Object)QoSMode.CUSTOM)) {
            this.disableUpdateHandler();
            this.updateIntervalObjects = updateIntervalFrames;
            if (this.updateIntervalObjects > 0) {
                this.enableUpdateHandler();
            }
        }
    }

    @Override
    public long getAverageLatency() {
        return this.averageLatency;
    }

    @Override
    public QoSMode getMode() {
        return this.mode;
    }

    public long getAutoLatencyThresholdLow() {
        return this.autoLatencyThresholdLow;
    }

    public long getAutoLatencyThresholdHigh() {
        return this.autoLatencyThresholdHigh;
    }

    public AUTO_MODE_LEVEL getAutoModeLevel() {
        return this.autoModeLevel;
    }

    @Override
    public QoSConfiguration getQoSConfiguration() {
        ArrayList<String> devices = new ArrayList<String>();
        devices.addAll(this.getDeviceWhitelist());
        ArrayList<String> groups = new ArrayList<String>();
        for (Integer grpID : this.getGroupWhitelist()) {
            groups.add(String.valueOf(grpID));
        }
        return new QoSConfiguration(this.getMode(), String.valueOf(this.getUpdateIntervalObjects()), String.valueOf(this.getUpdateIntervalFrames()), devices, groups);
    }

    private class AutoModeLatencyMonitor
    extends LatencyChecker {
        private int levelCounter;
        private static final int interval = 20;
        private static final int latencyCacheSize = 3;
        private static final int minUpdateIntervalFrames = 1;
        private static final int minUpdateIntervalObjects = 1;
        private static final int maxUpdateIntervalFrames = 30;
        private static final int maxUpdateIntervalObjects = 3;
        private static final long latencyThresholdHigh = 3000L;
        private static final long latencyThresholdLow = 1000L;
        private final long autoLatencyThresholdDiff = 2000L;
        private final long autoLatencyThresholdAddition = 500L;
        private final LatencyChecker latencyHistory;

        public AutoModeLatencyMonitor(TransceiverController controller) {
            super(controller, 3);
            this.levelCounter = 0;
            this.autoLatencyThresholdDiff = 2000L;
            this.autoLatencyThresholdAddition = 500L;
            DynamicQoS.this.autoLatencyThresholdLow = 1000L;
            DynamicQoS.this.autoLatencyThresholdHigh = 3000L;
            this.latencyHistory = new LatencyChecker(controller, 100);
        }

        @Override
        public void run() {
            boolean somethingChanged;
            super.run();
            DynamicQoS.this.averageLatency = this.getAverageLatency();
            this.latencyHistory.addLatencyTime(DynamicQoS.this.averageLatency);
            long autoThresholdLatency = this.latencyHistory.getAverageLatency();
            if (autoThresholdLatency <= 1000L) {
                DynamicQoS.this.autoLatencyThresholdLow = 1000L;
                DynamicQoS.this.autoLatencyThresholdHigh = 3000L;
            } else if (autoThresholdLatency + 500L >= 3000L) {
                DynamicQoS.this.autoLatencyThresholdLow = 3000L;
                DynamicQoS.this.autoLatencyThresholdHigh = 5000L;
            } else {
                DynamicQoS.this.autoLatencyThresholdLow = autoThresholdLatency + 500L;
                DynamicQoS.this.autoLatencyThresholdHigh = DynamicQoS.this.autoLatencyThresholdLow + 2000L;
            }
            int tmpIntFrames = DynamicQoS.this.updateIntervalFrames;
            int tmpIntObjects = DynamicQoS.this.updateIntervalObjects;
            AUTO_MODE_LEVEL oldLevel = DynamicQoS.this.autoModeLevel;
            AUTO_MODE_LEVEL newLevel = AUTO_MODE_LEVEL.MID;
            if (DynamicQoS.this.averageLatency > DynamicQoS.this.autoLatencyThresholdHigh) {
                newLevel = AUTO_MODE_LEVEL.HIGH;
            } else if (DynamicQoS.this.averageLatency < DynamicQoS.this.autoLatencyThresholdLow) {
                newLevel = AUTO_MODE_LEVEL.LOW;
            }
            if (DynamicQoS.this.autoModeLevel != newLevel) {
                DynamicQoS.this.autoModeLevel = newLevel;
                this.levelCounter = 0;
            }
            ++this.levelCounter;
            switch (DynamicQoS.this.autoModeLevel) {
                case HIGH: {
                    if (DynamicQoS.this.updateIntervalFrames < 30) {
                        DynamicQoS.this.updateIntervalFrames++;
                    }
                    if (DynamicQoS.this.updateIntervalFrames <= 20 || DynamicQoS.this.updateIntervalObjects >= 3) break;
                    DynamicQoS.this.updateIntervalObjects++;
                    break;
                }
                case MID: {
                    if (this.levelCounter == 1) {
                        if (!oldLevel.equals((Object)AUTO_MODE_LEVEL.HIGH) && DynamicQoS.this.updateIntervalFrames < 30) {
                            DynamicQoS.this.updateIntervalFrames++;
                        }
                        if (oldLevel.equals((Object)AUTO_MODE_LEVEL.LOW) || DynamicQoS.this.updateIntervalObjects <= 1) break;
                        DynamicQoS.this.updateIntervalObjects--;
                        break;
                    }
                    if (this.levelCounter != 5) break;
                    this.levelCounter = 0;
                    break;
                }
                case LOW: {
                    if (this.levelCounter == 10) {
                        if (DynamicQoS.this.updateIntervalFrames > 1) {
                            DynamicQoS.this.updateIntervalFrames--;
                        }
                        if (DynamicQoS.this.updateIntervalObjects <= 1) break;
                        DynamicQoS.this.updateIntervalObjects--;
                        break;
                    }
                    if (this.levelCounter != 20) break;
                    this.levelCounter = 0;
                }
            }
            boolean bl = somethingChanged = tmpIntFrames != DynamicQoS.this.updateIntervalFrames || tmpIntObjects != DynamicQoS.this.updateIntervalObjects;
            if (somethingChanged) {
                switch (DynamicQoS.this.autoModeLevel) {
                    case HIGH: {
                        this.logger.trace(DynamicQoS.this.transceiverID + " | High latency detected (" + DynamicQoS.this.averageLatency + ")! Apply new settings: updateIntervalFrames=" + DynamicQoS.this.updateIntervalFrames + ", updateIntervalObjects=" + DynamicQoS.this.updateIntervalObjects);
                        break;
                    }
                    case MID: {
                        this.logger.trace(DynamicQoS.this.transceiverID + " | Mid latency detected (" + DynamicQoS.this.averageLatency + ")! Apply new settings: updateIntervalFrames=" + DynamicQoS.this.updateIntervalFrames + ", updateIntervalObjects=" + DynamicQoS.this.updateIntervalObjects);
                        break;
                    }
                    case LOW: {
                        this.logger.trace(DynamicQoS.this.transceiverID + " | Low latency detected (" + DynamicQoS.this.averageLatency + ")! Apply new settings: updateIntervalFrames=" + DynamicQoS.this.updateIntervalFrames + ", updateIntervalObjects=" + DynamicQoS.this.updateIntervalObjects);
                    }
                }
                DynamicQoS.this.disableUpdateHandler();
                DynamicQoS.this.enableUpdateHandler();
            }
        }
    }

    private class PendingFrameHandler
    implements Runnable {
        private PendingFrameHandler() {
        }

        @Override
        public void run() {
            DynamicQoS.this.flushPendingFrames();
        }
    }

    private class PendingUpdateHandler
    implements Runnable {
        private PendingUpdateHandler() {
        }

        @Override
        public void run() {
            DynamicQoS.this.flushPendingUpdates();
            DynamicQoS.this.flushPendingCommands();
        }
    }

    private static enum AUTO_MODE_LEVEL {
        LOW,
        MID,
        HIGH;

    }
}

