/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.stats;

import bsc.sdk.api.stats.IValueCollector;

public class AvarageValue
implements IValueCollector<Long> {
    private static final long MAX_COUNT_VALUE = 0x7FFFFFFFFFFFFFFEL;
    private volatile long count = 0L;
    private volatile long sum = 0L;

    public long getCount() {
        return this.count;
    }

    @Override
    public synchronized void addValue(Long value) {
        long maxSum = Long.MAX_VALUE - value;
        if (this.sum >= maxSum || this.count >= 0x7FFFFFFFFFFFFFFEL) {
            this.count = 0L;
            this.sum = 0L;
        }
        this.sum += value.longValue();
        ++this.count;
    }

    @Override
    public synchronized Long getValue() {
        if (this.sum > 0L) {
            return Math.round((double)this.sum / (double)this.count);
        }
        return 0L;
    }
}

