/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.stats;

import bsc.sdk.api.stats.IStatsCollector;
import bsc.sdk.api.stats.IValueCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AStatsCollector<K, T>
implements IStatsCollector<K, T> {
    protected final Map<K, IValueCollector<T>> stats;

    protected AStatsCollector(boolean statsEnabled) {
        this.stats = statsEnabled ? new ConcurrentHashMap() : null;
    }

    @Override
    public void addValue(K key, T value) {
        if (this.stats != null) {
            IValueCollector<T> vc = this.stats.get(key);
            if (vc == null) {
                vc = this.createNewValueCollector();
                this.stats.put(key, vc);
            }
            vc.addValue(value);
        }
    }

    @Override
    public Map<K, IValueCollector<T>> getStats() {
        return this.stats;
    }

    @Override
    public boolean isStatsCollectionEnabled() {
        return this.stats != null;
    }

    protected abstract IValueCollector<T> createNewValueCollector();
}

