/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.manager.cache;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.IIdentifiableApiObject;
import bsc.api.basic.AMetaInformation;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.DeviceDeleted;
import bsc.api.modules.core.model.Group;
import bsc.api.modules.core.model.GroupDeleted;
import bsc.api.modules.metainfo.model.container.MetaInformationContainer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.executors.DynamicScheduledCachedThreadPoolExecutor;
import bsc.sdk.api.extension.modules.metainfo.MetaInfoExtension;
import bsc.sdk.api.notification.INotification;
import bsc.sdk.api.notification.alexa.AddAlexaCacheObjects;
import bsc.sdk.api.notification.alexa.RemoveAlexaCacheDevice;
import bsc.sdk.api.notification.alexa.UpdateAlexaCacheObjects;
import bsc.sdk.api.notification.objects.UserObjectCacheStatus;
import bsc.sdk.api.objects.IObjectProcessor;
import bsc.sdk.api.objects.manager.AObjectManager;
import bsc.sdk.api.objects.manager.DeviceIdentifier;
import bsc.sdk.api.objects.manager.ObjectIdentifier;
import bsc.sdk.api.objects.manager.SensorIdentifier;
import bsc.sdk.api.objects.manager.cache.IDeviceCacheProcessor;
import bsc.sdk.api.objects.manager.cache.IUserObjectCache;
import bsc.sdk.api.stats.AStatsCollector;
import bsc.sdk.api.stats.AvarageValue;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.IUserGroup;
import bsc.sdk.api.user.group.Permission;
import bsc.sdk.api.user.group.UserGroupIdentifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AUserObjectCache
extends AStatsCollector<String, Long>
implements IUserObjectCache {
    private static final Logger logger = LoggerFactory.getLogger(AUserObjectCache.class);
    private static Comparator<IObjectProcessor> objectProcessorComparator = null;
    private Environment environment;
    private AObjectManager objectManager;
    private Map<String, Map<String, EnumSet<Permission>>> userPermissionCache;
    private Map<String, Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>>> userObjectCache;
    protected DynamicScheduledCachedThreadPoolExecutor executorService;
    private AsyncWorkerCollector workerCollector;
    protected List<IObjectProcessor> objectProcessor = new LinkedList<IObjectProcessor>();
    protected Map<String, Set<String>> currentWork;
    protected Map<String, Set<String>> currentWorkRunning;
    protected final Set<Worker> workerQueue;
    protected boolean environmentIsReady = false;
    protected Set<IDeviceCacheProcessor> deviceCacheProcessors = new HashSet<IDeviceCacheProcessor>();

    protected AUserObjectCache(boolean enableStats) {
        super(enableStats);
        this.workerQueue = Collections.newSetFromMap(new ConcurrentHashMap());
        this.workerCollector = new AsyncWorkerCollector();
    }

    @Override
    public void waitForCacheRebuild(UserCredentialIdentifier user) {
        Set<String> currentWork = this.getCurrentUserWork(user);
        Set<String> currentWorkRunning = this.getCurrentUserWorkRunning(user);
        while (!currentWork.isEmpty() || !currentWorkRunning.isEmpty()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void waitForCacheRebuild(ObjectIdentifier object) {
        String objKey = object.getFullQualifiedIdentifiableString();
        boolean objectInQueue = false;
        do {
            objectInQueue = false;
            for (Set<String> objSet : this.currentWork.values()) {
                if (!objSet.contains(objKey)) continue;
                objectInQueue = true;
                break;
            }
            for (Set<String> objSet : this.currentWorkRunning.values()) {
                if (!objSet.contains(objKey)) continue;
                objectInQueue = true;
                break;
            }
            if (!objectInQueue) continue;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (objectInQueue);
    }

    @Override
    public void waitForCacheRebuild(UserCredentialIdentifier user, ObjectIdentifier object) {
        String objKey = object.getFullQualifiedIdentifiableString();
        Set<String> currentWork = this.getCurrentUserWork(user);
        Set<String> currentWorkRunning = this.getCurrentUserWorkRunning(user);
        while (currentWork.contains(objKey) || currentWorkRunning.contains(objKey)) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getCurrentUserWork(UserCredentialIdentifier user) {
        Map<String, Set<String>> map = this.currentWork;
        synchronized (map) {
            String userKey = Objects.requireNonNull(user, "user must not be null!").getFullQualifiedIdentifiableString();
            Set<String> result = this.currentWork.get(userKey);
            if (result == null) {
                result = Collections.newSetFromMap(new ConcurrentHashMap());
                this.currentWork.put(userKey, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getCurrentUserWorkRunning(UserCredentialIdentifier user) {
        Map<String, Set<String>> map = this.currentWorkRunning;
        synchronized (map) {
            String userKey = Objects.requireNonNull(user, "user must not be null!").getFullQualifiedIdentifiableString();
            Set<String> result = this.currentWorkRunning.get(userKey);
            if (result == null) {
                result = Collections.newSetFromMap(new ConcurrentHashMap());
                this.currentWorkRunning.put(userKey, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean spawnWorker(UserCredentialIdentifier user, ObjectIdentifier object) {
        if (user != null && object != null && this.executorService != null && !this.executorService.isShutdown()) {
            String objStr;
            Set<String> currentUserWork = this.getCurrentUserWork(user);
            if (!currentUserWork.contains(objStr = object.getFullQualifiedIdentifiableString())) {
                Set<Worker> set = this.workerQueue;
                synchronized (set) {
                    this.workerQueue.add(new Worker(user, object));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void refreshObject(UserCredentialIdentifier user, ObjectIdentifier object) {
        boolean rebuildWasInProgressBefore = this.isRebuildInProgress();
        if (this.spawnWorker(user, object) && !rebuildWasInProgressBefore) {
            this.fireNotification(new UserObjectCacheStatus(UserObjectCacheStatus.STATUS.WORKING));
        }
    }

    @Override
    public void refreshObject(ObjectIdentifier object) {
        for (UserCredentialIdentifier user : this.getEnvironment().getUserCredentialManager().getUserCredentialList()) {
            this.refreshObject(user, object);
        }
    }

    @Override
    public void removeObject(ObjectIdentifier object) {
        if (object == null) {
            return;
        }
        String key = object.getFullQualifiedIdentifiableString();
        for (Map.Entry<String, Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>>> entry : this.userObjectCache.entrySet()) {
            Map<String, EnumSet<Permission>> permissionCache;
            UserCredentialIdentifier userIdentifier;
            IIdentifiableApiObject removedObj;
            Map<String, IIdentifiableApiObject> typedCache;
            Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> uoc = entry.getValue();
            Map<String, IIdentifiableApiObject> map = typedCache = uoc == null ? null : uoc.get((Object)object.getObjectType());
            if (typedCache != null && (removedObj = typedCache.remove(key)) != null && (userIdentifier = (UserCredentialIdentifier)this.getEnvironment().getUserCredentialManager().getIdentifierInstance(entry.getKey())) != null) {
                if (removedObj instanceof ADevice) {
                    ADevice device = (ADevice)removedObj;
                    userIdentifier.sendObject(new DeviceDeleted(device.getDeviceID()));
                    this.removeFromDeviceCache(userIdentifier, device.getDeviceID());
                } else if (removedObj instanceof Group) {
                    Group group = (Group)removedObj;
                    userIdentifier.sendObject(new GroupDeleted(group.getId()));
                }
            }
            if ((permissionCache = this.userPermissionCache.get(entry.getKey())) == null) continue;
            permissionCache.remove(key);
        }
    }

    @Override
    public void removeObjectForUser(UserCredentialIdentifier user, ObjectIdentifier object) {
        String objectKey = Objects.requireNonNull(object, "object must not be null!").getFullQualifiedIdentifiableString();
        this.getUserObjectCache(user).remove(objectKey);
        this.getUserPermissionCache(user).remove(objectKey);
    }

    @Override
    public void clearUserCache(UserCredentialIdentifier user) {
        this.getUserObjectCache(user).clear();
        this.getUserPermissionCache(user).clear();
    }

    @Override
    public void shutdown() {
        if (this.workerCollector != null) {
            this.workerCollector.setRunning(false);
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        try {
            this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.deviceCacheProcessors.clear();
    }

    private synchronized Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> createCacheMap(String userIdentifierString) {
        Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> cache = this.userObjectCache.get(userIdentifierString);
        if (cache == null) {
            cache = this.createTypedCache();
            logger.trace("Create blank cache for: " + userIdentifierString + ", " + Thread.currentThread());
            Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> oldCache = this.userObjectCache.put(userIdentifierString, cache);
            if (oldCache != null) {
                logger.error("Found old Cache! (GROUP size=" + oldCache.get((Object)ObjectIdentifier.OBJECT_TYPE.GROUP).keySet().size() + "), for: " + userIdentifierString + ", " + Thread.currentThread());
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildCachedObjectForUser(UserCredentialIdentifier user, ObjectIdentifier object) throws Exception {
        if (user == null || object == null) {
            return;
        }
        String userIdentifierString = user.getFullQualifiedIdentifiableString();
        String objectIdentifierString = object.getFullQualifiedIdentifiableString();
        long start = System.currentTimeMillis();
        logger.trace("Rebuild cache for " + user.getUserCredentialID() + "->" + objectIdentifierString);
        Map<String, EnumSet<Permission>> userPermission = this.getUserPermissionCache(user);
        Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> cache = this.createCacheMap(userIdentifierString);
        Map<String, IIdentifiableApiObject> typedCache = cache.get((Object)object.getObjectType());
        EnumSet<Permission> effectivePermissions = this.calculateEffectivePermissions(user, object);
        userPermission.put(objectIdentifierString, effectivePermissions);
        if (effectivePermissions.contains((Object)Permission.VIEW) && object.objectExists()) {
            IIdentifiableApiObject obj = object.getObjectInstance();
            IIdentifiableApiObject newObject = this.prepareObjectForUser(user, obj);
            IIdentifiableApiObject oldObject = typedCache.put(objectIdentifierString, newObject);
            boolean existsBefore = oldObject != null;
            HashSet<IIdentifiableApiObject> objectsToSend = new HashSet<IIdentifiableApiObject>();
            HashSet<MetaInformationContainer> metaInfosToSend = new HashSet<MetaInformationContainer>();
            switch (object.getObjectType()) {
                case DEVICE: {
                    AMetaInformation container;
                    if (!existsBefore) {
                        this.addToDeviceCache(user, newObject);
                    }
                    ADevice device = (ADevice)newObject;
                    ADevice oldDevice = (ADevice)oldObject;
                    boolean deviceDataEquals = device.dataEqual(oldDevice, true, false, true);
                    Map<String, IIdentifiableApiObject> sensorCache = cache.get((Object)ObjectIdentifier.OBJECT_TYPE.SENSOR);
                    if (existsBefore && !deviceDataEquals) {
                        ObjectIdentifier sensIdent;
                        ADevice aDevice = oldDevice;
                        synchronized (aDevice) {
                            for (ISensor sens : oldDevice.getSensors()) {
                                sensIdent = (ObjectIdentifier)this.objectManager.getIdentifierInstance(sens);
                                sensorCache.remove(sensIdent.getFullQualifiedIdentifiableString());
                            }
                        }
                        aDevice = device;
                        synchronized (aDevice) {
                            for (ISensor sens : device.getSensors()) {
                                sensIdent = (ObjectIdentifier)this.objectManager.getIdentifierInstance(sens);
                                sensorCache.put(sensIdent.getFullQualifiedIdentifiableString(), sens);
                            }
                        }
                    }
                    if (!deviceDataEquals) break;
                    String metaID = MetaInfoExtension.getMetaIDfromMetaInfoObject(device);
                    Map<String, String> metaInfoDifference = AMetaInformation.getMetaInformationDifference(oldDevice, device);
                    if (!metaInfoDifference.isEmpty()) {
                        container = new MetaInformationContainer(metaID);
                        for (Map.Entry entry : metaInfoDifference.entrySet()) {
                            container.addMetaInformation((String)entry.getKey(), (String)entry.getValue());
                        }
                        metaInfosToSend.add((MetaInformationContainer)container);
                    }
                    container = device;
                    synchronized (container) {
                        for (ISensor iSensor : device.getSensors()) {
                            ISensor oldSensor = oldDevice.getSensorByName(iSensor.getName());
                            if (oldSensor == null || iSensor.dataEquals(oldSensor)) continue;
                            objectsToSend.add(iSensor);
                        }
                        break;
                    }
                }
                case SENSOR: {
                    SensorIdentifier sensor = (SensorIdentifier)object;
                    ObjectIdentifier di = (ObjectIdentifier)this.getEnvironment().getObjectManager().getIdentifierInstance(DeviceIdentifier.generateURI(sensor.getDeviceID(), this.getEnvironment()));
                    Map<String, IIdentifiableApiObject> deviceCache = cache.get((Object)ObjectIdentifier.OBJECT_TYPE.DEVICE);
                    ADevice deviceInst = (ADevice)deviceCache.get(di.getFullQualifiedIdentifiableString());
                    if (deviceInst != null) {
                        ADevice aDevice = deviceInst;
                        synchronized (aDevice) {
                            ISensor toRemove = deviceInst.getSensorByID(sensor.getSensorID());
                            deviceInst.removeSensor(toRemove);
                            deviceInst.addSensor((ISensor)obj);
                        }
                    }
                    objectsToSend.add(newObject);
                }
            }
            if (!existsBefore || objectsToSend.isEmpty() && metaInfosToSend.isEmpty() && !newObject.dataEquals(oldObject)) {
                objectsToSend.add(newObject);
            }
            this.notifyUserOfUpdates(user, objectsToSend);
            this.notifyUserOfMetaInfoUpdates(user, metaInfosToSend);
        } else {
            boolean existsBefore;
            boolean bl = existsBefore = typedCache.remove(objectIdentifierString) != null;
            if (existsBefore) {
                switch (object.getObjectType()) {
                    case DEVICE: {
                        DeviceIdentifier di = (DeviceIdentifier)object;
                        user.sendObject(new DeviceDeleted(di.getDeviceID()));
                        this.fireNotification(new RemoveAlexaCacheDevice(user, di.getDeviceID()));
                        break;
                    }
                    case GROUP: {
                        break;
                    }
                    case SENSOR: {
                        break;
                    }
                }
            }
        }
        long rebuildTime = System.currentTimeMillis() - start;
        this.addValue("avarage object rebuild time", rebuildTime);
        logger.trace("Finished rebuild after " + rebuildTime + " ms for " + user.getUserCredentialID() + "->" + object.getFullQualifiedIdentifiableString());
    }

    protected void notifyUserOfUpdates(UserCredentialIdentifier user, Set<IIdentifiableApiObject> objectsToSend) {
        if (!objectsToSend.isEmpty()) {
            for (IIdentifiableApiObject cachedObject : objectsToSend) {
                user.sendObject(cachedObject);
            }
            this.updateDeviceCache(user, objectsToSend);
        }
    }

    protected void notifyUserOfMetaInfoUpdates(UserCredentialIdentifier user, Set<MetaInformationContainer> metaInfosToSend) {
        for (MetaInformationContainer metaInfoContainer : metaInfosToSend) {
            user.sendObject(metaInfoContainer);
        }
    }

    protected EnumSet<Permission> calculateEffectivePermissions(UserCredentialIdentifier userIdentifier, ObjectIdentifier objectIdentifier) {
        EnumSet<Permission> result = EnumSet.noneOf(Permission.class);
        if (objectIdentifier != null && userIdentifier != null) {
            Set<UserGroupIdentifier> groups = userIdentifier.getUserGroupIdentifiers();
            for (UserGroupIdentifier userGroupIdentifier : groups) {
                EnumSet<Permission> permissions;
                IUserGroup group = userGroupIdentifier.getObjectInstance();
                if (group == null || (permissions = group.getPermissions(objectIdentifier)) == null) continue;
                result.addAll(permissions);
            }
        }
        return result;
    }

    @Override
    public EnumSet<Permission> getUserPermissionFromCache(UserCredentialIdentifier user, ObjectIdentifier object) {
        return this.getUserPermissionFromCache(user, object, false);
    }

    private EnumSet<Permission> getUserPermissionFromCache(UserCredentialIdentifier user, ObjectIdentifier object, boolean selfCalled) {
        EnumSet<Permission> result = null;
        Map<String, EnumSet<Permission>> cache = this.getUserPermissionCache(Objects.requireNonNull(user, "user must not be null"));
        if (!cache.isEmpty()) {
            String objectKey = Objects.requireNonNull(object, "object must not be null").getFullQualifiedIdentifiableString();
            result = cache.get(objectKey);
            if (result == null && !selfCalled) {
                logger.trace("No cache entry found! Rebuild this one...");
                try {
                    this.rebuildCachedObjectForUser(user, object);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                result = this.getUserPermissionFromCache(user, object, true);
            }
        } else if (!selfCalled) {
            logger.trace("No Cache found, rebuild!");
            try {
                this.rebuildCachedObjectForUser(user, null);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            result = this.getUserPermissionFromCache(user, object, true);
        }
        if (result == null) {
            return EnumSet.noneOf(Permission.class);
        }
        return result;
    }

    @Override
    public Map<String, EnumSet<Permission>> getUserPermissionCache(UserCredentialIdentifier user) {
        String userIdentifierString = Objects.requireNonNull(user, "user must not be null!").getFullQualifiedIdentifiableString();
        Map<String, EnumSet<Permission>> result = this.userPermissionCache.get(userIdentifierString);
        if (result == null) {
            result = new ConcurrentHashMap<String, EnumSet<Permission>>();
            this.userPermissionCache.put(userIdentifierString, result);
        }
        return result;
    }

    @Override
    public Map<String, IIdentifiableApiObject> getUserObjectCache(UserCredentialIdentifier user) {
        return this.getUserObjectCacheByType(user, EnumSet.allOf(ObjectIdentifier.OBJECT_TYPE.class));
    }

    @Override
    public Map<String, IIdentifiableApiObject> getUserObjectCacheByType(UserCredentialIdentifier user, EnumSet<ObjectIdentifier.OBJECT_TYPE> types) {
        String userIdentifierString = Objects.requireNonNull(user, "user must not be null!").getFullQualifiedIdentifiableString();
        Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> cache = this.createCacheMap(userIdentifierString);
        if (types == null) {
            types = EnumSet.allOf(ObjectIdentifier.OBJECT_TYPE.class);
        }
        ConcurrentHashMap<String, IIdentifiableApiObject> result = new ConcurrentHashMap<String, IIdentifiableApiObject>();
        for (ObjectIdentifier.OBJECT_TYPE t : types) {
            Map<String, IIdentifiableApiObject> tmp = cache.get((Object)t);
            if (tmp == null) continue;
            result.putAll(tmp);
        }
        return result;
    }

    private Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> createTypedCache() {
        ConcurrentHashMap<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> result = new ConcurrentHashMap<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>>();
        for (ObjectIdentifier.OBJECT_TYPE t : ObjectIdentifier.OBJECT_TYPE.values()) {
            result.put(t, new ConcurrentHashMap());
        }
        return result;
    }

    @Override
    public IIdentifiableApiObject getObjectFromCache(UserCredentialIdentifier user, ObjectIdentifier object) {
        IIdentifiableApiObject result = null;
        if (user != null && object != null) {
            Map<String, IIdentifiableApiObject> typedCache = this.getUserObjectCacheByType(user, EnumSet.of(object.getObjectType()));
            result = typedCache.get(object.getFullQualifiedIdentifiableString());
        }
        return result;
    }

    @Override
    public Set<IIdentifiableApiObject> getObjectFromCache(UserCredentialIdentifier user, ObjectIdentifier ... objects) {
        HashSet<IIdentifiableApiObject> result = new HashSet<IIdentifiableApiObject>();
        if (user != null && objects != null) {
            Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>> cache = this.userObjectCache.get(user.getFullQualifiedIdentifiableString());
            for (ObjectIdentifier objectIdentifier : objects) {
                IIdentifiableApiObject obj;
                Map<String, IIdentifiableApiObject> typedCache;
                if (objectIdentifier == null || (typedCache = cache.get((Object)objectIdentifier.getObjectType())) == null || (obj = typedCache.get(objectIdentifier.getFullQualifiedIdentifiableString())) == null) continue;
                result.add(obj);
            }
        }
        return result;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    protected <T extends IApiObject> T prepareObjectForUser(UserCredentialIdentifier user, T object) {
        long start = System.currentTimeMillis();
        if (object != null) {
            for (IObjectProcessor processor : this.objectProcessor) {
                long s = System.currentTimeMillis();
                logger.trace(processor.getClass().getName() + " working on: " + object.toString());
                try {
                    processor.processObject(user, object);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                this.addValue(processor.getClass().getName(), System.currentTimeMillis() - s);
            }
        }
        logger.trace("Finished object preparation after " + (System.currentTimeMillis() - start) + " ms");
        return object;
    }

    @Override
    public boolean isRebuildInProgress() {
        boolean result;
        block1: {
            Set<String> set;
            boolean bl = result = this.currentWork != null && !this.currentWork.isEmpty();
            if (!result) break block1;
            Iterator<Set<String>> i$ = this.currentWork.values().iterator();
            while (i$.hasNext() && !(result = !(set = i$.next()).isEmpty())) {
            }
        }
        return result;
    }

    @Override
    public int getCurrentWorkerCount() {
        int result = 0;
        if (!this.currentWork.isEmpty()) {
            for (Map.Entry<String, Set<String>> set : this.currentWork.entrySet()) {
                result += set.getValue().size();
            }
        }
        return result;
    }

    public static Comparator<IObjectProcessor> getObjectProcessorComparator() {
        if (objectProcessorComparator == null) {
            objectProcessorComparator = new Comparator<IObjectProcessor>(){

                @Override
                public int compare(IObjectProcessor o1, IObjectProcessor o2) {
                    return o1.getExecutePosition() - o2.getExecutePosition();
                }
            };
        }
        return objectProcessorComparator;
    }

    @Override
    public void init(Environment environment) {
        this.environment = Objects.requireNonNull(environment, "environment must not be null!");
        if (!(environment.getObjectManager() instanceof AObjectManager)) {
            this.objectManager = null;
            throw new UnsupportedClassVersionError("The class '" + environment.getObjectManager().getClass().getName() + "' is not derived from '" + AObjectManager.class.getName() + "'! " + this.getClass().getSimpleName() + " can only used with an instance of " + AObjectManager.class.getSimpleName() + ".");
        }
        this.objectManager = (AObjectManager)environment.getObjectManager();
        this.currentWork = new ConcurrentHashMap<String, Set<String>>();
        this.currentWorkRunning = new ConcurrentHashMap<String, Set<String>>();
        this.userObjectCache = new ConcurrentHashMap<String, Map<ObjectIdentifier.OBJECT_TYPE, Map<String, IIdentifiableApiObject>>>();
        this.userPermissionCache = new ConcurrentHashMap<String, Map<String, EnumSet<Permission>>>();
        int availableThreads = Runtime.getRuntime().availableProcessors();
        this.executorService = new DynamicScheduledCachedThreadPoolExecutor(environment.getApplication().getFullName() + " UserCache", availableThreads, 10, 5L, TimeUnit.MINUTES, 5);
        this.objectProcessor.addAll(this.getEnvironment().getExtensionManager().getObjectProcessorSet());
        Collections.sort(this.objectProcessor, AUserObjectCache.getObjectProcessorComparator());
        environment.getApplication().getExecutorServiceBackgroundTasks().execute(this.workerCollector);
        this.registerDeviceCacheProcessor(new IDeviceCacheProcessor(){

            @Override
            public void updateDeviceCache(UserCredentialIdentifier user, Set<IIdentifiableApiObject> objects) {
                AUserObjectCache.this.fireNotification(new UpdateAlexaCacheObjects(user, objects));
            }

            @Override
            public void removeFromDeviceCache(UserCredentialIdentifier user, String id) {
                AUserObjectCache.this.fireNotification(new RemoveAlexaCacheDevice(user, id));
            }

            @Override
            public void addToDeviceCache(UserCredentialIdentifier user, IIdentifiableApiObject object) {
                AUserObjectCache.this.fireNotification(new AddAlexaCacheObjects(user, object));
            }
        });
    }

    protected void addToDeviceCache(UserCredentialIdentifier user, IIdentifiableApiObject object) {
        for (IDeviceCacheProcessor iDeviceCacheProcessor : this.deviceCacheProcessors) {
            iDeviceCacheProcessor.addToDeviceCache(user, object);
        }
    }

    protected void updateDeviceCache(UserCredentialIdentifier user, Set<IIdentifiableApiObject> objects) {
        for (IDeviceCacheProcessor iDeviceCacheProcessor : this.deviceCacheProcessors) {
            iDeviceCacheProcessor.updateDeviceCache(user, objects);
        }
    }

    protected void removeFromDeviceCache(UserCredentialIdentifier user, String id) {
        for (IDeviceCacheProcessor iDeviceCacheProcessor : this.deviceCacheProcessors) {
            iDeviceCacheProcessor.removeFromDeviceCache(user, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDeviceCacheProcessor(IDeviceCacheProcessor processor) {
        Set<IDeviceCacheProcessor> set = this.deviceCacheProcessors;
        synchronized (set) {
            this.deviceCacheProcessors.add(processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterDeviceCacheProcessor(IDeviceCacheProcessor processor) {
        Set<IDeviceCacheProcessor> set = this.deviceCacheProcessors;
        synchronized (set) {
            this.deviceCacheProcessors.remove(processor);
        }
    }

    protected void fireNotification(INotification notification) {
        if (this.environment != null) {
            this.environment.getApplication().publishObject(Enumerations.OBJECT_BUS_TAGS.PUBLISH_NOTIFICATION, (Object)notification);
        }
    }

    protected boolean isEnvironmentReady() {
        if (!this.environmentIsReady) {
            boolean result = true;
            result &= this.getEnvironment() != null;
            result &= this.getEnvironment().getApplication() != null;
            result &= this.getEnvironment().getApplication().getEnvironment() != null;
            result &= this.getEnvironment().getExtensionManager() != null;
            result &= this.getEnvironment().getExtensionManager().getEnvironment() != null;
            result &= this.getEnvironment().getHandleManager() != null;
            result &= this.getEnvironment().getHandleManager().getEnvironment() != null;
            result &= this.getEnvironment().getIdPoolManager() != null;
            result &= this.getEnvironment().getObjectManager() != null;
            result &= this.getEnvironment().getObjectManager().getEnvironment() != null;
            result &= this.getEnvironment().getSessionManager() != null;
            result &= this.getEnvironment().getSessionManager().getEnvironment() != null;
            result &= this.getEnvironment().getTransceiverManager() != null;
            result &= this.getEnvironment().getTransceiverManager().getEnvironment() != null;
            result &= this.getEnvironment().getTransmissionManager() != null;
            result &= this.getEnvironment().getTransmissionManager().getEnvironment() != null;
            result &= this.getEnvironment().getUserCredentialManager() != null;
            result &= this.getEnvironment().getUserCredentialManager().getEnvironment() != null;
            result &= this.getEnvironment().getUserGroupManager() != null;
            if (result &= this.getEnvironment().getUserGroupManager().getEnvironment() != null) {
                this.environmentIsReady = result;
            }
        }
        return this.environmentIsReady;
    }

    protected AvarageValue createNewValueCollector() {
        return new AvarageValue();
    }

    protected class AsyncWorkerCollector
    implements Runnable {
        private boolean rebuildInProgressBefore;
        private boolean running;

        protected AsyncWorkerCollector() {
            this.rebuildInProgressBefore = AUserObjectCache.this.isRebuildInProgress();
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    boolean rebuild;
                    if (AUserObjectCache.this.executorService != null && AUserObjectCache.this.isEnvironmentReady()) {
                        Set<Worker> set = AUserObjectCache.this.workerQueue;
                        synchronized (set) {
                            Iterator<Worker> itr = AUserObjectCache.this.workerQueue.iterator();
                            while (itr.hasNext()) {
                                AUserObjectCache.this.executorService.execute(itr.next());
                                itr.remove();
                            }
                        }
                    }
                    if ((rebuild = AUserObjectCache.this.isRebuildInProgress()) != this.rebuildInProgressBefore) {
                        if (rebuild) {
                            AUserObjectCache.this.fireNotification(new UserObjectCacheStatus(UserObjectCacheStatus.STATUS.WORKING));
                        } else {
                            AUserObjectCache.this.fireNotification(new UserObjectCacheStatus(UserObjectCacheStatus.STATUS.IDLE));
                        }
                        this.rebuildInProgressBefore = rebuild;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }

    protected class Worker
    implements Runnable {
        private final UserCredentialIdentifier user;
        private final ObjectIdentifier object;
        private final String fqis;

        public Worker(UserCredentialIdentifier user, ObjectIdentifier object) {
            this.user = Objects.requireNonNull(user, "user must not be null!");
            this.object = Objects.requireNonNull(object, "object must not be null!");
            this.fqis = object.getFullQualifiedIdentifiableString();
            AUserObjectCache.this.getCurrentUserWork(user).add(this.fqis);
        }

        @Override
        public void run() {
            if (AUserObjectCache.this.workerCollector != null && AUserObjectCache.this.workerCollector.isRunning()) {
                AUserObjectCache.this.getCurrentUserWorkRunning(this.user).add(this.fqis);
                AUserObjectCache.this.getCurrentUserWork(this.user).remove(this.fqis);
                try {
                    AUserObjectCache.this.rebuildCachedObjectForUser(this.user, this.object);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                AUserObjectCache.this.getCurrentUserWorkRunning(this.user).remove(this.fqis);
            }
        }

        public UserCredentialIdentifier getUser() {
            return this.user;
        }

        public ObjectIdentifier getObject() {
            return this.object;
        }
    }
}

