/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.switches;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.api.modules.core.model.sensor.state.on.RelayOn;
import bsc.api.modules.core.model.sensor.state.on.RelaySwitchOn;
import bsc.api.modules.core.model.sensor.state.on.SummerSettingOn;
import bsc.api.modules.core.model.sensor.state.on.SwitchOn;
import bsc.api.modules.core.model.sensor.value.SceneSwitch;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.GenericOnConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.GenericOnPriorityConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.SceneSwitchConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.SwitchEnergyBowConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.TwoChannelOnPriorityConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.TwoRockerConfiguration;
import bsc.sdk.api.objects.device.type.switches.configuration.TwoRockerEnergyBowConfiguration;

public class SwitchFactory
extends DeviceFactory {
    private static SwitchFactory defaultFactory = null;

    public static SwitchFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = SwitchFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(SwitchFactory factory) {
        defaultFactory = factory;
    }

    public static SwitchFactory createDefaultFactory() {
        return new SwitchFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return SwitchFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericOn: {
                return this.createGenericOn((GenericOnConfiguration)deviceConfiguration);
            }
            case GenericOnPriority: {
                if (deviceConfiguration instanceof TwoChannelOnPriorityConfiguration) {
                    return this.createTwoChannelPriority((TwoChannelOnPriorityConfiguration)deviceConfiguration);
                }
                return this.createGenericOnPriority((GenericOnPriorityConfiguration)deviceConfiguration);
            }
            case SceneSwitch: {
                return this.createSceneSwitch((SceneSwitchConfiguration)deviceConfiguration);
            }
            case SwitchEnergyBow: {
                return this.createSwitchEnergyBow((SwitchEnergyBowConfiguration)deviceConfiguration);
            }
            case TwoRocker: {
                return this.createTwoRocker((TwoRockerConfiguration)deviceConfiguration);
            }
            case TwoRockerEnergyBow: {
                return this.createTwoRockerEnergyBow((TwoRockerEnergyBowConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private ADevice createTwoChannelPriority(TwoChannelOnPriorityConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        SwitchOn switchOnCh1 = new SwitchOn(device.getDeviceID());
        switchOnCh1.setSwitchType(deviceConfiguration.getSwitchType());
        this.fillStateSensor(Enumerations.SensorName.Channel1, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), switchOnCh1);
        device.addSensor(switchOnCh1);
        PrioritySensor prioCh1 = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority1, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), prioCh1);
        device.addSensor(prioCh1);
        SwitchOn switchOnCh2 = new SwitchOn(device.getDeviceID());
        switchOnCh2.setSwitchType(deviceConfiguration.getSwitchType());
        this.fillStateSensor(Enumerations.SensorName.Channel2, deviceConfiguration.getSensorIdCh2(), deviceConfiguration.getCurrentStateCh2(), switchOnCh2);
        device.addSensor(switchOnCh2);
        PrioritySensor prioCh2 = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority2, deviceConfiguration.getPrioritySensorIdCh2(), deviceConfiguration.getPriorityStateCh2(), prioCh2);
        device.addSensor(prioCh2);
        return device;
    }

    protected Device createTwoRockerEnergyBow(TwoRockerEnergyBowConfiguration deviceConfiguration) {
        Device device = this.createTwoRocker(deviceConfiguration);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.EnergyBow, deviceConfiguration.getEnergyBowSensorId(), deviceConfiguration.getEnergyBowState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createTwoRocker(TwoRockerConfiguration deviceConfiguration) {
        Device device = this.createGenericOn(deviceConfiguration);
        SwitchOn p = new SwitchOn(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.On, deviceConfiguration.getRockerBSensorId(), deviceConfiguration.getRockerBState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createSwitchEnergyBow(SwitchEnergyBowConfiguration deviceConfiguration) {
        Device device = this.createGenericOn(deviceConfiguration);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.EnergyBow, deviceConfiguration.getEnergyBowSensorId(), deviceConfiguration.getEnergyBowState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createSceneSwitch(SceneSwitchConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        SceneSwitch sensor = new SceneSwitch(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SceneSwitch, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericOnPriority(GenericOnPriorityConfiguration deviceConfiguration) {
        Device device = this.createGenericOn(deviceConfiguration);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createGenericOn(GenericOnConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        OnSensor sensor = null;
        switch (deviceConfiguration.getSensorType()) {
            case SWITCH_ON: {
                SwitchOn s = new SwitchOn(device.getDeviceID());
                s.setSwitchType(deviceConfiguration.getSwitchType());
                sensor = s;
                break;
            }
            case RELAY_SWITCH_ON: {
                RelaySwitchOn rs = new RelaySwitchOn(device.getDeviceID());
                rs.setSwitchType(deviceConfiguration.getSwitchType());
                sensor = rs;
                break;
            }
            case PRIORITY: {
                sensor = new PrioritySensor(device.getDeviceID());
                break;
            }
            case RELAY: {
                sensor = new RelayOn(device.getDeviceID());
                break;
            }
            case SUMMER_SETTING: {
                sensor = new SummerSettingOn(device.getDeviceID());
                break;
            }
            default: {
                sensor = new OnSensor(device.getDeviceID());
            }
        }
        this.fillStateSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

