/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.setpoint;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.OperatingMode;
import bsc.api.modules.core.model.sensor.state.OperatingModeRestriction;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.api.modules.core.model.sensor.value.SetPointSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.setpoint.configuration.SetPointConfiguration;
import bsc.sdk.api.objects.device.type.setpoint.configuration.SetPointOperatingModeConfiguration;
import bsc.sdk.api.objects.device.type.setpoint.configuration.SetPointOperatingModePriorityConfiguration;
import bsc.sdk.api.objects.device.type.setpoint.configuration.SetPointOperatingModeRestrictionConfiguration;
import bsc.sdk.api.objects.device.type.setpoint.configuration.SetPointOperatingModeRestrictionPriorityConfiguration;
import bsc.sdk.api.objects.device.type.setpoint.configuration.SetPointPriorityConfiguration;

public class SetPointFactory
extends DeviceFactory {
    private static SetPointFactory defaultFactory = null;

    public static SetPointFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = SetPointFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(SetPointFactory factory) {
        defaultFactory = factory;
    }

    public static SetPointFactory createDefaultFactory() {
        return new SetPointFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return SetPointFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case SetPoint: {
                return this.createSetPoint((SetPointConfiguration)deviceConfiguration);
            }
            case SetPointOperatingMode: {
                return this.createSetPointOperatingMode((SetPointOperatingModeConfiguration)deviceConfiguration);
            }
            case SetPointOperatingModePriority: {
                return this.createSetPointOperatingModePriority((SetPointOperatingModePriorityConfiguration)deviceConfiguration);
            }
            case SetPointOperatingModeRestriction: {
                return this.createSetPointOperatingModeRestriction((SetPointOperatingModeRestrictionConfiguration)deviceConfiguration);
            }
            case SetPointOperatingModeRestrictionPriority: {
                return this.createSetPointOperatingModeRestrictionPriority((SetPointOperatingModeRestrictionPriorityConfiguration)deviceConfiguration);
            }
            case SetPointPriority: {
                return this.createSetPointPriority((SetPointPriorityConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createSetPoint(SetPointConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        SetPointSensor sensor = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createSetPointOperatingMode(SetPointOperatingModeConfiguration deviceConfiguration) {
        Device device = this.createSetPoint(deviceConfiguration);
        OperatingMode op = new OperatingMode(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeSensorId(), deviceConfiguration.getOperatingModeState(), op);
        device.addSensor(op);
        return device;
    }

    protected Device createSetPointOperatingModePriority(SetPointOperatingModePriorityConfiguration deviceConfiguration) {
        Device device = this.createSetPoint(deviceConfiguration);
        OperatingMode op = new OperatingMode(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeSensorId(), deviceConfiguration.getOperatingModeState(), op);
        device.addSensor(op);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createSetPointOperatingModeRestriction(SetPointOperatingModeRestrictionConfiguration deviceConfiguration) {
        Device device = this.createSetPoint(deviceConfiguration);
        OperatingModeRestriction opr = new OperatingModeRestriction(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeRestrictionSensorId(), deviceConfiguration.getOperatingModeRestrictionState(), opr);
        device.addSensor(opr);
        return device;
    }

    protected Device createSetPointOperatingModeRestrictionPriority(SetPointOperatingModeRestrictionPriorityConfiguration deviceConfiguration) {
        Device device = this.createSetPoint(deviceConfiguration);
        OperatingModeRestriction opr = new OperatingModeRestriction(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeRestrictionSensorId(), deviceConfiguration.getOperatingModeRestrictionState(), opr);
        device.addSensor(opr);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        return device;
    }

    protected Device createSetPointPriority(SetPointPriorityConfiguration deviceConfiguration) {
        Device device = this.createSetPoint(deviceConfiguration);
        PrioritySensor p = new PrioritySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        return device;
    }
}

