/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.roomcontroller;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.api.modules.core.model.sensor.state.FanSpeedStateSensor;
import bsc.api.modules.core.model.sensor.state.OperatingMode;
import bsc.api.modules.core.model.sensor.state.OperatingModeRestriction;
import bsc.api.modules.core.model.sensor.state.ThreeStatePriority;
import bsc.api.modules.core.model.sensor.state.detection.ErrorDetection;
import bsc.api.modules.core.model.sensor.state.on.PrioritySensor;
import bsc.api.modules.core.model.sensor.state.on.RelayOn;
import bsc.api.modules.core.model.sensor.value.SetPointSensor;
import bsc.api.modules.core.model.sensor.value.SetedSetPointActuatorSensor;
import bsc.api.modules.core.model.sensor.value.TempSensor;
import bsc.api.modules.core.model.sensor.value.ValueSensor;
import bsc.api.modules.core.model.sensor.value.temp.InnerTemp;
import bsc.api.modules.core.model.sensor.value.temp.OutherTemp;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.GenericHeaterControlConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.GenericHeaterControlErrorDeviceConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.GenericHeaterValveControlConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.GenericVentilationControlConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.HeaterControlDetectionConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.HeaterControlThreeStatePriorityConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.HeaterControlThreeStatePriorityMinorConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.HeaterControlThreeStatePriorityMinorWithRelayConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.HeaterControlThreeStatePriorityWithRelaisConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.PriorityHeaterControlConfiguration;
import bsc.sdk.api.objects.device.type.roomcontroller.configuration.SetpointHeaterControlConfiguration;

public class RoomControllerFactory
extends DeviceFactory {
    private static RoomControllerFactory defaultFactory = null;

    public static RoomControllerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = RoomControllerFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(RoomControllerFactory factory) {
        defaultFactory = factory;
    }

    public static RoomControllerFactory createDefaultFactory() {
        return new RoomControllerFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return RoomControllerFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericHeaterControl: {
                return this.createGenericHeaterControl((GenericHeaterControlConfiguration)deviceConfiguration);
            }
            case GenericHeaterValveControl: {
                return this.createGenericHeaterValveControl((GenericHeaterValveControlConfiguration)deviceConfiguration);
            }
            case SetpointHeaterControl: {
                return this.createSetpointHeaterControl((SetpointHeaterControlConfiguration)deviceConfiguration);
            }
            case HeaterControlDetection: {
                return this.createHeaterControlDetection((HeaterControlDetectionConfiguration)deviceConfiguration);
            }
            case PriorityHeaterControl: {
                return this.createPriorityHeaterControl((PriorityHeaterControlConfiguration)deviceConfiguration);
            }
            case GenericVentilationControl: {
                return this.createGenericVentilationControl((GenericVentilationControlConfiguration)deviceConfiguration);
            }
            case HeaterControlThreeStatePriority: {
                return this.createThreeStatePriorityHeaterControl((HeaterControlThreeStatePriorityMinorConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private ADevice createThreeStatePriorityHeaterControl(HeaterControlThreeStatePriorityMinorConfiguration deviceConfiguration) {
        RelayOn relayOn;
        HeaterControlThreeStatePriorityMinorConfiguration relaisConfig;
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), setPoint);
        device.addSensor(setPoint);
        ThreeStatePriority priority = new ThreeStatePriority(deviceConfiguration.getDeviceID());
        priority.setName(Enumerations.SensorName.Priority.getSensorName());
        priority.setSensorID(deviceConfiguration.getPrioritySensorId());
        priority.setState(deviceConfiguration.getPrioritySensorCurrentState());
        device.addSensor(priority);
        if (deviceConfiguration instanceof HeaterControlThreeStatePriorityConfiguration) {
            HeaterControlThreeStatePriorityConfiguration devConfig = (HeaterControlThreeStatePriorityConfiguration)deviceConfiguration;
            OperatingMode operatingMode = new OperatingMode(deviceConfiguration.getDeviceID());
            this.fillStateSensor(Enumerations.SensorName.OperatingMode, devConfig.getOperatingModeSensorId(), devConfig.getOperatingModeCurrentState(), operatingMode);
            device.addSensor(operatingMode);
            ErrorDetection errorDetection = new ErrorDetection(deviceConfiguration.getDeviceID());
            errorDetection.setName(Enumerations.SensorName.ErrorDetection.getSensorName());
            errorDetection.setSensorID(devConfig.getErrorModeSensorId());
            errorDetection.setState(devConfig.getErrorDetectionState());
            device.addSensor(errorDetection);
        }
        SetedSetPointActuatorSensor setedSetpointActuator = new SetedSetPointActuatorSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetedSetpointActuator, deviceConfiguration.getActuatorSetpointSensorId(), deviceConfiguration.getActuatorSetpointValue(), setedSetpointActuator);
        device.addSensor(setedSetpointActuator);
        if (deviceConfiguration instanceof HeaterControlThreeStatePriorityWithRelaisConfiguration) {
            relaisConfig = (HeaterControlThreeStatePriorityWithRelaisConfiguration)deviceConfiguration;
            relayOn = new RelayOn(relaisConfig.getDeviceID());
            relayOn.setName(Enumerations.SensorName.Relay.getSensorName());
            relayOn.setSensorID(((HeaterControlThreeStatePriorityWithRelaisConfiguration)relaisConfig).getRelaisSensorId());
            relayOn.setState(((HeaterControlThreeStatePriorityWithRelaisConfiguration)relaisConfig).getRelaisState());
            device.addSensor(relayOn);
        }
        if (deviceConfiguration instanceof HeaterControlThreeStatePriorityMinorWithRelayConfiguration) {
            relaisConfig = (HeaterControlThreeStatePriorityMinorWithRelayConfiguration)deviceConfiguration;
            relayOn = new RelayOn(relaisConfig.getDeviceID());
            relayOn.setName(Enumerations.SensorName.Relay.getSensorName());
            relayOn.setSensorID(((HeaterControlThreeStatePriorityMinorWithRelayConfiguration)relaisConfig).getRelaisSensorId());
            relayOn.setState(((HeaterControlThreeStatePriorityMinorWithRelayConfiguration)relaisConfig).getRelaisState());
            device.addSensor(relayOn);
        }
        return device;
    }

    protected Device createGenericVentilationControl(GenericVentilationControlConfiguration deviceConfiguration) {
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), setPoint);
        device.addSensor(setPoint);
        FanSpeedStateSensor fanSpeed = new FanSpeedStateSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.FanSpeed, deviceConfiguration.getFanSpeedSensorId(), deviceConfiguration.getFanSpeedCurrentState(), fanSpeed);
        device.addSensor(fanSpeed);
        return device;
    }

    protected Device createSetpointHeaterControl(SetpointHeaterControlConfiguration deviceConfiguration) {
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), setPoint);
        device.addSensor(setPoint);
        OperatingMode operatingMode = new OperatingMode(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeSensorId(), deviceConfiguration.getOperatingModeCurrentState(), operatingMode);
        device.addSensor(operatingMode);
        return device;
    }

    protected Device createGenericHeaterControl(GenericHeaterControlConfiguration deviceConfiguration) {
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), setPoint);
        device.addSensor(setPoint);
        PrioritySensor p = new PrioritySensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        OperatingMode operatingMode = new OperatingMode(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeSensorId(), deviceConfiguration.getOperatingModeCurrentState(), operatingMode);
        device.addSensor(operatingMode);
        if (deviceConfiguration instanceof GenericHeaterControlErrorDeviceConfiguration) {
            GenericHeaterControlErrorDeviceConfiguration errDevConfig = (GenericHeaterControlErrorDeviceConfiguration)deviceConfiguration;
            ErrorDetection errorDetection = new ErrorDetection(deviceConfiguration.getDeviceID());
            errorDetection.setName(Enumerations.SensorName.ErrorDetection.getSensorName());
            errorDetection.setSensorID(errDevConfig.getErrorModeSensorId());
            errorDetection.setState(errDevConfig.getErrorDetectionState());
            device.addSensor(errorDetection);
        }
        return device;
    }

    protected Device createGenericHeaterValveControl(GenericHeaterValveControlConfiguration deviceConfiguration) {
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), setPoint);
        device.addSensor(setPoint);
        PrioritySensor p = new PrioritySensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), p);
        device.addSensor(p);
        ValueSensor valve = new ValueSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Value, deviceConfiguration.getValveSensorId(), deviceConfiguration.getValveSettings(), valve);
        device.addSensor(valve);
        OperatingMode operatingMode = new OperatingMode(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeSensorId(), deviceConfiguration.getOperatingModeCurrentState(), operatingMode);
        device.addSensor(operatingMode);
        return device;
    }

    protected Device createHeaterControlDetection(HeaterControlDetectionConfiguration deviceConfiguration) {
        TempSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case INNER: {
                sensor = new InnerTemp(deviceConfiguration.getDeviceID());
                break;
            }
            case OUTER: {
                sensor = new OutherTemp(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new TempSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetPointSensorId(), deviceConfiguration.getSetPointValueSettings(), setPoint);
        device.addSensor(setPoint);
        OperatingModeRestriction operatingModeRestriction = new OperatingModeRestriction(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeRestrictionSensorId(), deviceConfiguration.getOperatingModeRestrictionCurrentState(), operatingModeRestriction);
        device.addSensor(operatingModeRestriction);
        DetectionSensor detectionSensor = new DetectionSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Detection, deviceConfiguration.getDetectionSensorId(), deviceConfiguration.getDetectionCurrentState(), detectionSensor);
        device.addSensor(detectionSensor);
        return device;
    }

    protected Device createPriorityHeaterControl(PriorityHeaterControlConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        SetPointSensor setPoint = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), setPoint);
        device.addSensor(setPoint);
        PrioritySensor priority = new PrioritySensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Priority, deviceConfiguration.getPrioritySensorId(), deviceConfiguration.getPriorityState(), priority);
        device.addSensor(priority);
        OperatingMode operatingMode = new OperatingMode(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.OperatingMode, deviceConfiguration.getOperatingModeCurrentStateSensorId(), deviceConfiguration.getOperatingModeCurrentState(), operatingMode);
        device.addSensor(operatingMode);
        return device;
    }
}

