/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.open;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.AlarmSensor;
import bsc.api.modules.core.model.sensor.state.BatterySensor;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.OpenSensor;
import bsc.api.modules.core.model.sensor.state.TriggerSensor;
import bsc.api.modules.core.model.sensor.state.WindowSensor;
import bsc.api.modules.core.model.sensor.state.check.BatteryCheck;
import bsc.api.modules.core.model.sensor.state.open.Contact;
import bsc.api.modules.core.model.sensor.state.open.Valve;
import bsc.api.modules.core.model.sensor.state.open.contact.DoorContact;
import bsc.api.modules.core.model.sensor.state.open.contact.MagnetContact;
import bsc.api.modules.core.model.sensor.state.open.contact.WindowContact;
import bsc.api.modules.core.model.sensor.value.BatteryValue;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.GenericLockConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.GenericOpenConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.GenericWindowConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.OpenBatteryChargeValueConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.OpenBatteryChargeValueEnergyStorageConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.OpenBatteryConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.WindowBatteryAlarmConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.WindowBatteryConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.WindowVoltageConfiguration;
import bsc.sdk.api.objects.device.type.open.configuration.WindowVoltageVibrationConfiguration;

public class OpenFactory
extends DeviceFactory {
    private static OpenFactory defaultFactory = null;

    public static OpenFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = OpenFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(OpenFactory factory) {
        defaultFactory = factory;
    }

    public static OpenFactory createDefaultFactory() {
        return new OpenFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return OpenFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericWindow: {
                return this.createGenericWindow((GenericWindowConfiguration)deviceConfiguration);
            }
            case GenericOpen: {
                return this.createGenericOpen((GenericOpenConfiguration)deviceConfiguration);
            }
            case GenericLock: {
                return this.createBurgSchloss((GenericLockConfiguration)deviceConfiguration);
            }
            case OpenBattery: {
                return this.createOpenBattery((OpenBatteryConfiguration)deviceConfiguration);
            }
            case OpenVoltage: {
                return this.createOpenCharge((OpenBatteryChargeValueConfiguration)deviceConfiguration);
            }
            case WindowBattery: {
                return this.createWindowBattery((WindowBatteryConfiguration)deviceConfiguration);
            }
            case WindowBatteryAlarm: {
                return this.createWindowBatteryAlarm((WindowBatteryAlarmConfiguration)deviceConfiguration);
            }
            case WindowVoltage: {
                return this.createWindowVoltage((WindowVoltageConfiguration)deviceConfiguration);
            }
            case WindowVoltageVibration: {
                return this.createWindowVoltageVibration((WindowVoltageVibrationConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericOpen(GenericOpenConfiguration deviceConfiguration) {
        OpenSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case CONTACT: {
                sensor = new Contact(deviceConfiguration.getDeviceID());
                break;
            }
            case DOOR_CONTACT: {
                sensor = new DoorContact(deviceConfiguration.getDeviceID());
                break;
            }
            case MAGNET_CONTACT: {
                sensor = new MagnetContact(deviceConfiguration.getDeviceID());
                break;
            }
            case WINDOW_CONTACT: {
                sensor = new WindowContact(deviceConfiguration.getDeviceID());
                break;
            }
            case VALVE: {
                sensor = new Valve(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new OpenSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillStateSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericWindow(GenericWindowConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        WindowSensor sensor = new WindowSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Window, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createBurgSchloss(GenericLockConfiguration deviceConfiguration) {
        Device device = this.createGenericOpen(deviceConfiguration);
        BatteryValue battery = new BatteryValue(device.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getChargeStateSensorID(), deviceConfiguration.getChargeState(), battery);
        device.addSensor(battery);
        EnabledSensor access = new EnabledSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Enabled, deviceConfiguration.getAccessControlStateSensorID(), deviceConfiguration.getAccessControlState(), access);
        device.addSensor(access);
        return device;
    }

    protected Device createOpenBattery(OpenBatteryConfiguration deviceConfiguration) {
        Device device = this.createGenericOpen(deviceConfiguration);
        BatteryCheck battery = new BatteryCheck(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Battery, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentState(), battery);
        device.addSensor(battery);
        return device;
    }

    protected Device createOpenCharge(OpenBatteryChargeValueConfiguration deviceConfiguration) {
        Device device = this.createGenericOpen(deviceConfiguration);
        ElectricitySensor sensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentValue(), sensor);
        device.addSensor(sensor);
        if (deviceConfiguration instanceof OpenBatteryChargeValueEnergyStorageConfiguration) {
            OpenBatteryChargeValueEnergyStorageConfiguration config = (OpenBatteryChargeValueEnergyStorageConfiguration)deviceConfiguration;
            ElectricitySensor esSensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
            this.fillValueSensor(Enumerations.SensorName.EnergyStorage, config.getEnergyStorageSensorId(), config.getEnergyStorageCurrentValue(), esSensor);
            device.addSensor(esSensor);
        }
        return device;
    }

    protected Device createWindowBattery(WindowBatteryConfiguration deviceConfiguration) {
        Device device = this.createGenericWindow(deviceConfiguration);
        BatterySensor battery = new BatterySensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.WindowBattery, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentState(), battery);
        device.addSensor(battery);
        return device;
    }

    protected Device createWindowBatteryAlarm(WindowBatteryAlarmConfiguration deviceConfiguration) {
        Device device = this.createWindowBattery(deviceConfiguration);
        AlarmSensor alarm = new AlarmSensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.WindowAlarm, deviceConfiguration.getAlarmSensorId(), deviceConfiguration.getAlarmCurrentState(), alarm);
        device.addSensor(alarm);
        return device;
    }

    protected Device createWindowVoltage(WindowVoltageConfiguration deviceConfiguration) {
        Device device = this.createGenericWindow(deviceConfiguration);
        ElectricitySensor voltage = new ElectricitySensor(device.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentState(), voltage);
        device.addSensor(voltage);
        return device;
    }

    protected Device createWindowVoltageVibration(WindowVoltageVibrationConfiguration deviceConfiguration) {
        Device device = this.createWindowVoltage(deviceConfiguration);
        TriggerSensor vibration = new TriggerSensor(device.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.WindowAlarm, deviceConfiguration.getAlarmSensorId(), deviceConfiguration.getAlarmCurrentState(), vibration);
        device.addSensor(vibration);
        return device;
    }
}

