/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.multisensor;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.AStateSensor;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.modules.core.model.sensor.state.AccelerationStatusSensor;
import bsc.api.modules.core.model.sensor.state.open.Contact;
import bsc.api.modules.core.model.sensor.value.AccelerationSensor;
import bsc.api.modules.core.model.sensor.value.BrightnessSensor;
import bsc.api.modules.core.model.sensor.value.HumintySensor;
import bsc.api.modules.core.model.sensor.value.TempSensor;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.ValueSettings;
import bsc.sdk.api.objects.device.type.multisensor.configuration.MultiSensorConfiguration;
import java.util.Objects;

public class MultiSensorFactory {
    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case MultiSensorAcceleration: {
                return MultiSensorFactory.createMultiSensorAcceleration((MultiSensorConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private static ADevice createMultiSensorAcceleration(MultiSensorConfiguration deviceConfiguration) {
        Device device = MultiSensorFactory.createBasicDevice(deviceConfiguration);
        AValueSensor valueSensor = new TempSensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillValueSensor(Enumerations.SensorName.Temperature, deviceConfiguration.getSensorId(), deviceConfiguration.getValueSettings(), valueSensor);
        device.addSensor(valueSensor);
        valueSensor = new HumintySensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillValueSensor(Enumerations.SensorName.Humidity, deviceConfiguration.getSensorIDHum(), deviceConfiguration.getValueSettingsHum(), valueSensor);
        device.addSensor(valueSensor);
        valueSensor = new BrightnessSensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillValueSensor(Enumerations.SensorName.Brightness, deviceConfiguration.getSensorIDIll(), deviceConfiguration.getValueSettingsIll(), valueSensor);
        device.addSensor(valueSensor);
        AStateSensor stateSensor = new AccelerationStatusSensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillStateSensor(Enumerations.SensorName.Acceleration_State, deviceConfiguration.getSensorIDACCState(), deviceConfiguration.getAccState(), stateSensor);
        device.addSensor(stateSensor);
        valueSensor = new AccelerationSensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillValueSensor(Enumerations.SensorName.Acceleration_X, deviceConfiguration.getSensorIDACCx(), deviceConfiguration.getValueSettingsAccx(), valueSensor);
        device.addSensor(valueSensor);
        valueSensor = new AccelerationSensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillValueSensor(Enumerations.SensorName.Acceleration_Y, deviceConfiguration.getSensorIDACCy(), deviceConfiguration.getValueSettingsAccy(), valueSensor);
        device.addSensor(valueSensor);
        valueSensor = new AccelerationSensor(deviceConfiguration.getDeviceID());
        MultiSensorFactory.fillValueSensor(Enumerations.SensorName.Acceleration_Z, deviceConfiguration.getSensorIDACCz(), deviceConfiguration.getValueSettingsAccz(), valueSensor);
        device.addSensor(valueSensor);
        if (deviceConfiguration.getSensorIDContact() != null) {
            stateSensor = new Contact(deviceConfiguration.getDeviceID());
            MultiSensorFactory.fillStateSensor(Enumerations.SensorName.Open, deviceConfiguration.getSensorIDContact(), deviceConfiguration.getContactState(), stateSensor);
            device.addSensor(stateSensor);
        }
        return device;
    }

    protected static <T extends Enum<T>> void fillStateSensor(Enumerations.SensorName sensorName, String sensorId, T currentState, AStateSensor<T> sensor) {
        MultiSensorFactory.fillSensor(sensorName, sensorId, sensor);
        MultiSensorFactory.fillStates(currentState, sensor);
    }

    protected static <T extends Enum<T>> void fillStates(T currentState, AStateSensor<T> sensor) {
        sensor.setState(currentState);
    }

    protected static Device createBasicDevice(ADeviceConfiguration deviceConfiguration) {
        Device device = new Device(deviceConfiguration.getDeviceType());
        MultiSensorFactory.fillDevice(deviceConfiguration, device);
        return device;
    }

    protected static void fillDevice(ADeviceConfiguration deviceConfiguration, ADevice device) {
        device.setName(deviceConfiguration.getName());
        device.setDeviceID(deviceConfiguration.getDeviceID());
        device.setGrpIDs(deviceConfiguration.getGrpIDs());
        device.setState(deviceConfiguration.getState());
        device.setActuator(deviceConfiguration.isActor());
    }

    protected static void fillSensor(Enumerations.SensorName sensorName, String sensorId, ISensor sensor) {
        sensor.setSensorID(Objects.requireNonNull(sensorId, "sensorId must not be null!"));
        sensor.setName(Objects.requireNonNull(sensorName, "sensorName must not be null!").name());
    }

    protected static void fillValueSensor(Enumerations.SensorName sensorName, String sensorId, ValueSettings valueSettings, AValueSensor sensor) {
        MultiSensorFactory.fillSensor(sensorName, sensorId, sensor);
        MultiSensorFactory.fillValues(valueSettings.getCurrentValue(), valueSettings.getMaxValue(), valueSettings.getMinValue(), valueSettings.getStepping(), valueSettings.getMeasuringUnit(), sensor);
    }

    protected static void fillValues(ValueSettings valueSettings, AValueSensor sensor) {
        MultiSensorFactory.fillValues(valueSettings.getCurrentValue(), valueSettings.getMaxValue(), valueSettings.getMinValue(), valueSettings.getStepping(), valueSettings.getMeasuringUnit(), sensor);
    }

    protected static void fillValues(double currentValue, double maxValue, double minValue, double stepping, String measureingUnit, AValueSensor sensor) {
        if (currentValue >= maxValue) {
            currentValue = maxValue;
        } else if (currentValue <= minValue) {
            currentValue = minValue;
        }
        sensor.setValue(currentValue);
        sensor.setMaxValue(maxValue);
        sensor.setMinValue(minValue);
        sensor.setMeasuringUnit(Objects.requireNonNull(measureingUnit, "measureingUnit must not be null!"));
        sensor.setStepping(stepping);
    }
}

