/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.meter;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.api.modules.core.model.sensor.state.on.RelayOn;
import bsc.api.modules.core.model.sensor.value.AMRCollectionSensor;
import bsc.api.modules.core.model.sensor.value.Counter;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.api.modules.core.model.sensor.value.GasSensor;
import bsc.api.modules.core.model.sensor.value.ThermalSensor;
import bsc.api.modules.core.model.sensor.value.WaterSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.meter.configuration.GenericMeterConfiguration;

public class MeterFactory
extends DeviceFactory {
    private static MeterFactory defaultFactory = null;

    public static MeterFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = MeterFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(MeterFactory factory) {
        defaultFactory = factory;
    }

    public static MeterFactory createDefaultFactory() {
        return new MeterFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return MeterFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericMeter: {
                return this.createGenericMeter((GenericMeterConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericMeter(GenericMeterConfiguration deviceConfiguration) {
        AValueSensor consumption;
        Device device = this.createBasicDevice(deviceConfiguration);
        RelayOn sensor = new RelayOn(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Relay, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        switch (deviceConfiguration.getSensorType()) {
            case AMR_COLLECTION: {
                consumption = new AMRCollectionSensor(deviceConfiguration.getDeviceID());
                break;
            }
            case ELECTRICITY: {
                consumption = new ElectricitySensor(deviceConfiguration.getDeviceID());
                break;
            }
            case GAS: {
                consumption = new GasSensor(deviceConfiguration.getDeviceID());
                break;
            }
            case THERMAL: {
                consumption = new ThermalSensor(deviceConfiguration.getDeviceID());
                break;
            }
            case WATER: {
                consumption = new WaterSensor(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                consumption = new Counter(deviceConfiguration.getDeviceID());
            }
        }
        this.fillValueSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getConsumptionSensorId(), deviceConfiguration.getConsumptionValueSettings(), consumption);
        device.addSensor(consumption);
        Counter highCounter = new Counter(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.HighChargeCounter, deviceConfiguration.getHighChargeSensorId(), deviceConfiguration.getHighChargeValueSettings(), highCounter);
        device.addSensor(highCounter);
        Counter lowCounter = new Counter(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.LowChargeCounter, deviceConfiguration.getLowChargeSensorId(), deviceConfiguration.getLowChargeValueSettings(), lowCounter);
        device.addSensor(lowCounter);
        return device;
    }
}

