/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.keypad;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.ButtonSensor;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.keypad.configuration.KeypadVoltageConfiguration;
import java.util.List;

public class KeypadFactory
extends DeviceFactory {
    private static KeypadFactory defaultFactory = null;

    public static KeypadFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = KeypadFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(KeypadFactory factory) {
        defaultFactory = factory;
    }

    public static KeypadFactory createDefaultFactory() {
        return new KeypadFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return KeypadFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case F6TFKeypad: {
                return this.createF6Keypad((KeypadVoltageConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private ADevice createF6Keypad(KeypadVoltageConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        List<ButtonSensor> tempList = deviceConfiguration.getButtonSensorList();
        for (int i = 0; i < tempList.size(); ++i) {
            device.addSensor(tempList.get(i));
        }
        ElectricitySensor sensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        return device;
    }

    @Override
    protected Device createBasicDevice(ADeviceConfiguration deviceConfiguration) {
        Device device = new Device(deviceConfiguration.getDeviceType());
        this.fillDevice(deviceConfiguration, device);
        return device;
    }
}

