/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.jalousie.configuration;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.sensor.state.UpSensor;
import bsc.sdk.api.objects.device.type.AValueDeviceConfiguration;
import bsc.sdk.api.objects.device.type.ValueSettings;
import java.util.List;
import java.util.Objects;

public class GenericJalousieConfiguration
extends AValueDeviceConfiguration {
    private static final String measuringUnit = "%";
    private static final double stepping = 1.0;
    private static final double minValue = 0.0;
    private static final double maxValue = 100.0;
    private Enumerations.SensorName.SUBTYPE_JALOUSIE sensorType;
    private UpSensor.State direction;
    private final String directionSensorId;

    public GenericJalousieConfiguration(String deviceId, String sensorId, String directionSensorId, Enumerations.SensorName.SUBTYPE_JALOUSIE sensorType, ADevice.DeviceState state, String name, List<Integer> grpIDs, double currentValue, UpSensor.State directionCurrentState) {
        this(Enumerations.DeviceType.GenericJalousie, deviceId, sensorId, directionSensorId, sensorType, state, name, grpIDs, currentValue, directionCurrentState);
    }

    protected GenericJalousieConfiguration(Enumerations.DeviceType deviceType, String deviceId, String sensorId, String directionSensorId, Enumerations.SensorName.SUBTYPE_JALOUSIE sensorType, ADevice.DeviceState state, String name, List<Integer> grpIDs, double currentValue, UpSensor.State directionCurrentState) {
        super(deviceType, deviceId, sensorId, state, name, grpIDs, new ValueSettings(currentValue, 0.0, 100.0, 1.0, measuringUnit));
        this.sensorType = Objects.requireNonNull(sensorType, "sensorType must not be null!");
        this.direction = Objects.requireNonNull(directionCurrentState, "direction must not be null!");
        this.directionSensorId = Objects.requireNonNull(directionSensorId, "directionSensorId must not be null!");
        this.setActor(true);
    }

    public Enumerations.SensorName.SUBTYPE_JALOUSIE getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(Enumerations.SensorName.SUBTYPE_JALOUSIE sensorType) {
        this.sensorType = sensorType;
    }

    public UpSensor.State getDirection() {
        return this.direction;
    }

    public void setDirection(UpSensor.State direction) {
        this.direction = direction;
    }

    @Override
    public String toString() {
        return "GenericJalousieConfiguration [sensorType=" + (Object)((Object)this.sensorType) + ", direction=" + (Object)((Object)this.direction) + ", directionSensorId=" + this.directionSensorId + ", toString()=" + super.toString() + "]";
    }

    public String getDirectionSensorId() {
        return this.directionSensorId;
    }
}

