/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.enabled;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.enabled.DaylightHarvestingEnabled;
import bsc.api.modules.core.model.sensor.state.enabled.PowerRelayTimerEnabled;
import bsc.api.modules.core.model.sensor.state.enabled.RepeaterEnabled;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.enabled.configuration.GenericEnabledConfiguration;

public class EnabledFactory
extends DeviceFactory {
    private static EnabledFactory defaultFactory = null;

    public static EnabledFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = EnabledFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(EnabledFactory factory) {
        defaultFactory = factory;
    }

    public static EnabledFactory createDefaultFactory() {
        return new EnabledFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return EnabledFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericEnabled: {
                return this.createGenericEnabled((GenericEnabledConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createGenericEnabled(GenericEnabledConfiguration deviceConfiguration) {
        EnabledSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case DAYLIGHT_HARVESTING: {
                sensor = new DaylightHarvestingEnabled(deviceConfiguration.getDeviceID());
                break;
            }
            case POWER_RELAY: {
                sensor = new PowerRelayTimerEnabled(deviceConfiguration.getDeviceID());
                break;
            }
            case REPEATER: {
                sensor = new RepeaterEnabled(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new EnabledSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillStateSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

