/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.detection;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.CheckSensor;
import bsc.api.modules.core.model.sensor.state.DetectionSensor;
import bsc.api.modules.core.model.sensor.state.EnabledSensor;
import bsc.api.modules.core.model.sensor.state.OilWaterSensor;
import bsc.api.modules.core.model.sensor.state.OnSensor;
import bsc.api.modules.core.model.sensor.state.check.BatteryCheck;
import bsc.api.modules.core.model.sensor.state.detection.EmptyDetection;
import bsc.api.modules.core.model.sensor.state.detection.HeatingDetection;
import bsc.api.modules.core.model.sensor.state.detection.LeckageDetection;
import bsc.api.modules.core.model.sensor.state.detection.ManometerSetpointDetection;
import bsc.api.modules.core.model.sensor.state.detection.MinDetection;
import bsc.api.modules.core.model.sensor.state.detection.MoistureDetection;
import bsc.api.modules.core.model.sensor.state.detection.MotionDetection;
import bsc.api.modules.core.model.sensor.state.detection.OccupancyDetection;
import bsc.api.modules.core.model.sensor.state.detection.PresenceDetection;
import bsc.api.modules.core.model.sensor.state.detection.RainDetection;
import bsc.api.modules.core.model.sensor.state.detection.SmokeDetection;
import bsc.api.modules.core.model.sensor.state.detection.VoltageDetection;
import bsc.api.modules.core.model.sensor.state.detection.WaterDetection;
import bsc.api.modules.core.model.sensor.state.detection.presence.Seat;
import bsc.api.modules.core.model.sensor.state.detection.presence.Trap;
import bsc.api.modules.core.model.sensor.state.on.RelayOn;
import bsc.api.modules.core.model.sensor.value.ElectricitySensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.DetectionBatteryConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.DetectionModeConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.DetectionVoltageConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.DetectionVoltagePushButtonConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.GenericCheckConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.GenericDetectionConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.GenericOilWaterConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.SmokeDetectionConfiguration;
import bsc.sdk.api.objects.device.type.detection.configuration.SmokeDetectionRelaisConfiguration;

public class DetectionFactory
extends DeviceFactory {
    private static DetectionFactory defaultFactory = null;

    public static DetectionFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = DetectionFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(DetectionFactory factory) {
        defaultFactory = factory;
    }

    public static DetectionFactory createDefaultFactory() {
        return new DetectionFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return DetectionFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericDetection: 
            case SmokeDetection2ndChannelRelais: 
            case SmokeDetection: {
                return this.createGenericDetection((GenericDetectionConfiguration)deviceConfiguration);
            }
            case GenericCheck: {
                return this.createGenericCheck((GenericCheckConfiguration)deviceConfiguration);
            }
            case GenericOilWater: {
                return this.createGenericOilWater((GenericOilWaterConfiguration)deviceConfiguration);
            }
            case DetectionMode: {
                return this.createDetectionMode((DetectionModeConfiguration)deviceConfiguration);
            }
            case DetectionBattery: {
                return this.createDetectionBattery((DetectionBatteryConfiguration)deviceConfiguration);
            }
            case DetectionVoltage: {
                return this.createDetectionVoltage((DetectionVoltageConfiguration)deviceConfiguration);
            }
            case DetectionVoltagePushbutton: {
                return this.createDetectionVoltagePushbutton((DetectionVoltagePushButtonConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    private Device createGenericOilWater(GenericOilWaterConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        OilWaterSensor sensor = new OilWaterSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(deviceConfiguration.getSensorType(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericCheck(GenericCheckConfiguration deviceConfiguration) {
        CheckSensor sensor;
        Device device = this.createBasicDevice(deviceConfiguration);
        switch (deviceConfiguration.getSensorType()) {
            case BATTERY: {
                sensor = new BatteryCheck(deviceConfiguration.getDeviceID());
                break;
            }
            default: {
                sensor = new CheckSensor(deviceConfiguration.getDeviceID());
            }
        }
        this.fillStateSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericDetection(GenericDetectionConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        if (deviceConfiguration instanceof SmokeDetectionConfiguration) {
            SmokeDetectionConfiguration smokeDetectConfig = (SmokeDetectionConfiguration)deviceConfiguration;
            SmokeDetection smokeSensor = new SmokeDetection(deviceConfiguration.getDeviceID());
            this.fillStateSensor(smokeDetectConfig.getSensorType().getParent(), smokeDetectConfig.getSensorId(), smokeDetectConfig.getCurrentState(), smokeSensor);
            device.addSensor(smokeSensor);
            if (deviceConfiguration instanceof SmokeDetectionRelaisConfiguration) {
                SmokeDetectionRelaisConfiguration smokeRelaisConfig = (SmokeDetectionRelaisConfiguration)deviceConfiguration;
                RelayOn relayOnSensor = new RelayOn(deviceConfiguration.getDeviceID());
                relayOnSensor.setName(Enumerations.SensorName.Relay.getSensorName());
                relayOnSensor.setSensorID(smokeRelaisConfig.getSecondChannelId());
                relayOnSensor.setState(smokeRelaisConfig.getRelayState());
                device.addSensor(relayOnSensor);
            }
        } else {
            DetectionSensor sensor;
            switch (deviceConfiguration.getSensorType()) {
                case EMPTY: {
                    sensor = new EmptyDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case HEATING: {
                    sensor = new HeatingDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case LECKAGE: {
                    sensor = new LeckageDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case MANOMETER_SETPOINT: {
                    sensor = new ManometerSetpointDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case MIN: {
                    sensor = new MinDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case MOISTURE: {
                    sensor = new MoistureDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case MOTION: {
                    sensor = new MotionDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case OCCUPANCY: {
                    sensor = new OccupancyDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case PRESENCE: {
                    sensor = new PresenceDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case RAIN: {
                    sensor = new RainDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case SEAT: {
                    sensor = new Seat(deviceConfiguration.getDeviceID());
                    break;
                }
                case TRAP: {
                    sensor = new Trap(deviceConfiguration.getDeviceID());
                    break;
                }
                case VOLTAGE: {
                    sensor = new VoltageDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case WATER: {
                    sensor = new WaterDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                case SMOKE: {
                    sensor = new SmokeDetection(deviceConfiguration.getDeviceID());
                    break;
                }
                default: {
                    sensor = new DetectionSensor(deviceConfiguration.getDeviceID());
                }
            }
            this.fillStateSensor(deviceConfiguration.getSensorType().getParent(), deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
            device.addSensor(sensor);
        }
        return device;
    }

    protected Device createDetectionMode(DetectionModeConfiguration deviceConfiguration) {
        Device device = this.createGenericDetection(deviceConfiguration);
        EnabledSensor sensor = new EnabledSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Enabled, deviceConfiguration.getModeSensorId(), deviceConfiguration.getModeCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createDetectionBattery(DetectionBatteryConfiguration deviceConfiguration) {
        Device device = this.createGenericDetection(deviceConfiguration);
        BatteryCheck sensor = new BatteryCheck(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Battery, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private ADevice createDetectionVoltage(DetectionVoltageConfiguration deviceConfiguration) {
        Device device = this.createGenericDetection(deviceConfiguration);
        ElectricitySensor sensor = new ElectricitySensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.Voltage, deviceConfiguration.getVoltageSensorId(), deviceConfiguration.getVoltageValue(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private ADevice createDetectionVoltagePushbutton(DetectionVoltagePushButtonConfiguration deviceConfiguration) {
        Device device = (Device)this.createDetectionVoltage(deviceConfiguration);
        OnSensor sensor = new OnSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.On, deviceConfiguration.getPushButtonSensorId(), deviceConfiguration.getPushButtonState(), sensor);
        device.addSensor(sensor);
        return device;
    }
}

