/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device.type.binary;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.state.DigitalSensor;
import bsc.api.modules.core.model.sensor.state.WindowSensor;
import bsc.api.modules.core.model.sensor.state.check.BatteryCheck;
import bsc.api.modules.core.model.sensor.value.SetPointSensor;
import bsc.sdk.api.objects.device.DeviceFactory;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.binary.configuration.BinaryBatteryConfiguration;
import bsc.sdk.api.objects.device.type.binary.configuration.GenericBinaryConfiguration;
import bsc.sdk.api.objects.device.type.binary.configuration.SetpointBinaryBatteryConfiguration;

public class BinaryFactory
extends DeviceFactory {
    private static BinaryFactory defaultFactory = null;

    public static BinaryFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = BinaryFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(BinaryFactory factory) {
        defaultFactory = factory;
    }

    public static BinaryFactory createDefaultFactory() {
        return new BinaryFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return BinaryFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    @Override
    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        switch (deviceConfiguration.getDeviceType()) {
            case GenericBinary: {
                return this.createGenericBinary((GenericBinaryConfiguration)deviceConfiguration);
            }
            case BinaryBattery: {
                return this.createBinaryBattery((BinaryBatteryConfiguration)deviceConfiguration);
            }
            case SetpointBattery: {
                return this.createSetpointBattery((SetpointBinaryBatteryConfiguration)deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createBinaryBattery(BinaryBatteryConfiguration deviceConfiguration) {
        Device device = this.createGenericBinary(deviceConfiguration);
        BatteryCheck sensor = new BatteryCheck(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Battery, deviceConfiguration.getBatterySensorId(), deviceConfiguration.getBatteryCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    protected Device createGenericBinary(GenericBinaryConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        DigitalSensor sensor = new DigitalSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Binary, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), sensor);
        device.addSensor(sensor);
        return device;
    }

    private ADevice createSetpointBattery(SetpointBinaryBatteryConfiguration deviceConfiguration) {
        Device device = this.createBasicDevice(deviceConfiguration);
        BatteryCheck batSensor = new BatteryCheck(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Battery, deviceConfiguration.getSensorId(), deviceConfiguration.getCurrentState(), batSensor);
        device.addSensor(batSensor);
        SetPointSensor sensor = new SetPointSensor(deviceConfiguration.getDeviceID());
        this.fillValueSensor(Enumerations.SensorName.SetPoint, deviceConfiguration.getSetpointSensorId(), deviceConfiguration.getValueSettings(), sensor);
        device.addSensor(sensor);
        WindowSensor winSensor = new WindowSensor(deviceConfiguration.getDeviceID());
        this.fillStateSensor(Enumerations.SensorName.Window, deviceConfiguration.getWindowSensorId(), deviceConfiguration.getWindowCurrentState(), winSensor);
        device.addSensor(winSensor);
        return device;
    }
}

