/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.objects.device;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.core.model.Device;
import bsc.api.modules.core.model.sensor.AStateSensor;
import bsc.api.modules.core.model.sensor.AValueSensor;
import bsc.sdk.api.objects.device.type.ADeviceConfiguration;
import bsc.sdk.api.objects.device.type.ValueSettings;
import bsc.sdk.api.objects.device.type.alarm.AlarmFactory;
import bsc.sdk.api.objects.device.type.battery.BatteryFactory;
import bsc.sdk.api.objects.device.type.binary.BinaryFactory;
import bsc.sdk.api.objects.device.type.brightness.BrightnessFactory;
import bsc.sdk.api.objects.device.type.bsc.BscFactory;
import bsc.sdk.api.objects.device.type.camera.CameraFactory;
import bsc.sdk.api.objects.device.type.cardswitch.CardSwitchFactory;
import bsc.sdk.api.objects.device.type.container.ContainerFactory;
import bsc.sdk.api.objects.device.type.detection.DetectionFactory;
import bsc.sdk.api.objects.device.type.dimmer.DimmerFactory;
import bsc.sdk.api.objects.device.type.direction.DirectionFactory;
import bsc.sdk.api.objects.device.type.eltako.EltakoFactory;
import bsc.sdk.api.objects.device.type.enabled.EnabledFactory;
import bsc.sdk.api.objects.device.type.gas.GasFactory;
import bsc.sdk.api.objects.device.type.jalousie.JalousieFactory;
import bsc.sdk.api.objects.device.type.keypad.KeypadFactory;
import bsc.sdk.api.objects.device.type.meter.MeterFactory;
import bsc.sdk.api.objects.device.type.multisensor.MultiSensorFactory;
import bsc.sdk.api.objects.device.type.open.OpenFactory;
import bsc.sdk.api.objects.device.type.pc.PCFactory;
import bsc.sdk.api.objects.device.type.pressed.PressedFactory;
import bsc.sdk.api.objects.device.type.roomcontroller.RoomControllerFactory;
import bsc.sdk.api.objects.device.type.setpoint.SetPointFactory;
import bsc.sdk.api.objects.device.type.switches.SwitchFactory;
import bsc.sdk.api.objects.device.type.temperature.TemperatureFactory;
import bsc.sdk.api.objects.device.type.timer.configuration.TimerFactory;
import bsc.sdk.api.objects.device.type.weatherstation.WeatherstationFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

public class DeviceFactory {
    private static DeviceFactory defaultFactory = null;

    public static DeviceFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = DeviceFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(DeviceFactory factory) {
        defaultFactory = factory;
    }

    public static DeviceFactory createDefaultFactory() {
        return new DeviceFactory();
    }

    public static ADevice createNewInstance(ADeviceConfiguration deviceConfiguration) {
        return DeviceFactory.getDefaultFactory().createInstance(deviceConfiguration);
    }

    public ADevice createInstance(ADeviceConfiguration deviceConfiguration) {
        if (deviceConfiguration == null) {
            return null;
        }
        switch (deviceConfiguration.getDeviceType()) {
            case SystemDevice: {
                return BscFactory.createNewInstance(deviceConfiguration);
            }
            case ActorContainer: {
                return ContainerFactory.createNewInstance(deviceConfiguration);
            }
            case Timer: 
            case TimerControl: {
                return TimerFactory.createNewInstance(deviceConfiguration);
            }
            case FGSM14: {
                return EltakoFactory.createNewInstance(deviceConfiguration);
            }
            case GenericCheck: 
            case GenericDetection: 
            case GenericOilWater: 
            case DetectionMode: 
            case DetectionBattery: 
            case DetectionVoltage: 
            case DetectionVoltagePushbutton: 
            case SmokeDetection2ndChannelRelais: 
            case SmokeDetection: {
                return DetectionFactory.createNewInstance(deviceConfiguration);
            }
            case GenericCardSwitch: {
                return CardSwitchFactory.createNewInstance(deviceConfiguration);
            }
            case GenericEnabled: {
                return EnabledFactory.createNewInstance(deviceConfiguration);
            }
            case PressedPriority: {
                return PressedFactory.createNewInstance(deviceConfiguration);
            }
            case GenericAlarm: 
            case AlarmRelay: 
            case SpecialAlarm: 
            case AlarmSiren: 
            case Smartguard_Window: {
                return AlarmFactory.createNewInstance(deviceConfiguration);
            }
            case GenericGas: 
            case GasLed: {
                return GasFactory.createNewInstance(deviceConfiguration);
            }
            case BinaryBattery: 
            case GenericBinary: 
            case SetpointBattery: {
                return BinaryFactory.createNewInstance(deviceConfiguration);
            }
            case GenericBatteryCheck: 
            case VoltageBatteryCheck: {
                return BatteryFactory.createNewInstance(deviceConfiguration);
            }
            case GenericVentilationControl: 
            case GenericHeaterControl: 
            case GenericHeaterValveControl: 
            case SetpointHeaterControl: 
            case PriorityHeaterControl: 
            case HeaterControlDetection: 
            case HeaterControlThreeStatePriority: {
                return RoomControllerFactory.createNewInstance(deviceConfiguration);
            }
            case SetPoint: 
            case SetPointOperatingMode: 
            case SetPointOperatingModePriority: 
            case SetPointOperatingModeRestriction: 
            case SetPointOperatingModeRestrictionPriority: 
            case SetPointPriority: {
                return SetPointFactory.createNewInstance(deviceConfiguration);
            }
            case WeatherstationElsner: 
            case WeatherstationEltako: {
                return WeatherstationFactory.createNewInstance(deviceConfiguration);
            }
            case GenericMeter: {
                return MeterFactory.createNewInstance(deviceConfiguration);
            }
            case Camera: {
                return CameraFactory.createNewInstance(deviceConfiguration);
            }
            case RGBDimmer: 
            case DimmerPriority: 
            case GenericDimmer: 
            case DimmerPriorityLimitMinimumBrightness: 
            case WhiteLightDimmer: 
            case DimmerPriorityColorTemperature: {
                return DimmerFactory.createNewInstance(deviceConfiguration);
            }
            case BrightnessVoltage: 
            case BrightnessVoltageDetection: 
            case GenericBrightness: 
            case BrightnessDetection: {
                return BrightnessFactory.createNewInstance(deviceConfiguration);
            }
            case JalousiePriority: 
            case JalousieSlatAdjustmentDirectionTimePriority: 
            case JalousieSlatAdjustmentTimePriority: 
            case JalousieAlignmentPriority: 
            case SwitchJalousie: 
            case GenericJalousie: {
                return JalousieFactory.createNewInstance(deviceConfiguration);
            }
            case GenericOnPriority: 
            case SceneSwitch: 
            case TwoRocker: 
            case GenericOn: 
            case SwitchEnergyBow: {
                return SwitchFactory.createNewInstance(deviceConfiguration);
            }
            case GenericWindow: 
            case GenericOpen: 
            case GenericLock: 
            case OpenBattery: 
            case OpenVoltage: 
            case WindowBattery: 
            case WindowBatteryAlarm: 
            case WindowVoltage: 
            case WindowVoltageVibration: {
                return OpenFactory.createNewInstance(deviceConfiguration);
            }
            case TempButton: 
            case TempCO2: 
            case TempCO2Humidity: 
            case TempDetection: 
            case TempHumidity: 
            case TempHumidityHSetPoint: 
            case TempHumidityVoltage: 
            case TempSetPoint: 
            case TempSetPointButton: 
            case TempSetPointButtonFan: 
            case TempSetPointFan: 
            case TempSetPointFanDetection: 
            case TempSetPointPriority: 
            case TempSetPointPriorityPercentage: 
            case TempSetPointDayNight: 
            case TempSetPointDetection: 
            case TempSetPointDetectionOn: 
            case TempSetPointHumidity: 
            case TempSetPointHumidityButton: 
            case TempSetPointSlideSwitch: 
            case TempSetPointSummerSettingWindowHeatPresence: 
            case TempSetPointWindow: 
            case TempSetPointWindowBattery: 
            case GenericTemperature: 
            case TempSetPointRelayAndOrPriority: {
                return TemperatureFactory.createNewInstance(deviceConfiguration);
            }
            case MultiSensorAcceleration: {
                return MultiSensorFactory.createNewInstance(deviceConfiguration);
            }
            case PC: 
            case PCGroup: {
                return PCFactory.createNewInstance(deviceConfiguration);
            }
            case F6TFKeypad: {
                return KeypadFactory.createNewInstance(deviceConfiguration);
            }
            case KeySwitch: {
                return DirectionFactory.createNewInstance(deviceConfiguration);
            }
        }
        return null;
    }

    protected Device createBasicDevice(ADeviceConfiguration deviceConfiguration) {
        Device device = new Device(deviceConfiguration.getDeviceType());
        this.fillDevice(deviceConfiguration, device);
        return device;
    }

    protected void fillDevice(ADeviceConfiguration deviceConfiguration, ADevice device) {
        device.setName(deviceConfiguration.getName());
        device.setDeviceID(deviceConfiguration.getDeviceID());
        device.setGrpIDs(deviceConfiguration.getGrpIDs());
        device.setState(deviceConfiguration.getState());
        device.setActuator(deviceConfiguration.isActor());
    }

    protected void fillSensor(Enumerations.SensorName sensorName, String sensorId, ISensor sensor) {
        sensor.setSensorID(Objects.requireNonNull(sensorId, "sensorId must not be null!"));
        sensor.setName(Objects.requireNonNull(sensorName, "sensorName must not be null!").name());
    }

    protected void fillValueSensor(Enumerations.SensorName sensorName, String sensorId, ValueSettings valueSettings, AValueSensor sensor) {
        this.fillSensor(sensorName, sensorId, sensor);
        this.fillValues(valueSettings.getCurrentValue(), valueSettings.getMaxValue(), valueSettings.getMinValue(), valueSettings.getStepping(), valueSettings.getMeasuringUnit(), sensor);
    }

    protected void fillValues(ValueSettings valueSettings, AValueSensor sensor) {
        this.fillValues(valueSettings.getCurrentValue(), valueSettings.getMaxValue(), valueSettings.getMinValue(), valueSettings.getStepping(), valueSettings.getMeasuringUnit(), sensor);
    }

    protected void fillValues(double currentValue, double maxValue, double minValue, double stepping, String measureingUnit, AValueSensor sensor) {
        if (currentValue >= maxValue) {
            currentValue = maxValue;
        } else if (currentValue <= minValue) {
            currentValue = minValue;
        }
        sensor.setValue(currentValue);
        sensor.setMaxValue(maxValue);
        sensor.setMinValue(minValue);
        sensor.setMeasuringUnit(Objects.requireNonNull(measureingUnit, "measureingUnit must not be null!"));
        sensor.setStepping(stepping);
    }

    protected <T extends Enum<T>> void fillStateSensor(Enumerations.SensorName sensorName, String sensorId, T currentState, AStateSensor<T> sensor) {
        this.fillSensor(sensorName, sensorId, sensor);
        this.fillStates(currentState, sensor);
    }

    protected <T extends Enum<T>> void fillStates(T currentState, AStateSensor<T> sensor) {
        sensor.setState(currentState);
    }

    public double scaleValueToStepping(double value, double stepping) {
        int steppingPrecision = this.getDoublePrecision(stepping);
        int quotient = (int)(value / stepping);
        double mod = value - stepping * (double)quotient;
        mod = this.roundDoubleWithPrecision(mod, steppingPrecision);
        double roundingDirectionValue = stepping - mod;
        double result = stepping * (double)quotient;
        if (roundingDirectionValue <= mod) {
            result += stepping;
        }
        return this.roundDoubleWithPrecision(result, steppingPrecision);
    }

    public int getDoublePrecision(double stepping) {
        String textRepresentation = Double.toString(Math.abs(stepping));
        int dividerPos = textRepresentation.indexOf(".") + 1;
        if (dividerPos > 0) {
            return textRepresentation.length() - dividerPos;
        }
        return 0;
    }

    public double roundDoubleWithPrecision(double value, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(precision, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

