/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.handler.manager;

import bsc.api.IApiObject;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.Result;
import bsc.api.transport.result.UnsupportedResult;
import bsc.sdk.api.AManager;
import bsc.sdk.api.handler.IObjectHandler;
import bsc.sdk.api.handler.ObjectHandlerIdentifier;
import bsc.sdk.api.handler.command.CommandHandler;
import bsc.sdk.api.handler.manager.IHandleManager;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;
import bsc.sdk.api.user.session.ISession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AHandleManager
extends AManager<ObjectHandlerIdentifier, IObjectHandler>
implements IHandleManager {
    private Map<String, List<IObjectHandler>> handlerMap = new ConcurrentHashMap<String, List<IObjectHandler>>();
    private Map<Class<? extends IApiObject>, Map<String, List<IObjectHandler>>> handlerMapping = new ConcurrentHashMap<Class<? extends IApiObject>, Map<String, List<IObjectHandler>>>();
    private Set<Class<? extends IApiObject>> supportedCommandclasses = new HashSet<Class<? extends IApiObject>>();
    private boolean useCache = true;

    public AHandleManager() {
    }

    public AHandleManager(boolean useCache) {
        this(null, useCache);
    }

    public AHandleManager(IObjectHandler objectHandler) {
        this(Arrays.asList(objectHandler), true);
    }

    public AHandleManager(Collection<IObjectHandler> objectHandler, boolean useCache) {
        if (objectHandler != null) {
            for (IObjectHandler iObjectHandler : objectHandler) {
                this.addHandlerToMap(iObjectHandler);
            }
        }
        this.useCache = useCache;
    }

    @Override
    public Result handle(TransceiverIdentifier identifier, TransmissionObject transmissionObject) {
        return this.handle(identifier, transmissionObject.getObject());
    }

    @Override
    public Result handle(TransceiverIdentifier identifier, IApiObject object) {
        Class<?> objectClass = Objects.requireNonNull(object, "object must not be null!").getClass();
        HashSet<IObjectHandler> handler = new HashSet<IObjectHandler>();
        this.logger.trace(identifier.getTransceiverID() + " | handle->" + objectClass);
        Map<String, List<IObjectHandler>> map = this.handlerMapping.get(objectClass);
        if (this.useCache && map != null) {
            for (String extensionId : map.keySet()) {
                List<IObjectHandler> handlerList = map.get(extensionId);
                if (handlerList == null || handlerList.size() == 0) continue;
                handler.addAll(handlerList);
            }
        }
        TransceiverController controller = this.getEnvironment().getTransceiverManager().getTransceiverControllerInstance(identifier);
        ISession session = controller.getCurrentSessionID().getObjectInstance();
        if (handler.size() == 0 && session != null) {
            handler.addAll(this.getSupportedHandler(object, identifier.getSubscriptionList()));
            if (handler.size() > 0 && this.useCache) {
                if (map == null) {
                    map = new ConcurrentHashMap<String, List<IObjectHandler>>();
                    this.handlerMapping.put(objectClass, map);
                }
                for (IObjectHandler iObjectHandler : handler) {
                    List<IObjectHandler> handlerList = map.get(iObjectHandler.getExtensionID());
                    if (handlerList == null) {
                        handlerList = new ArrayList<IObjectHandler>();
                        map.put(iObjectHandler.getExtensionID(), handlerList);
                    }
                    handlerList.add(iObjectHandler);
                }
            }
        }
        if (handler.isEmpty()) {
            return new UnsupportedResult();
        }
        for (IObjectHandler iObjectHandler : handler) {
            if (!this.getEnvironment().getExtensionManager().isSubscribedFor(identifier, iObjectHandler.getExtensionID())) continue;
            this.logger.trace("Execute handler: " + iObjectHandler.getClass().getName() + " | " + iObjectHandler.getURI().toString());
            return iObjectHandler.doHandle(identifier, object);
        }
        return new UnsupportedResult();
    }

    @Override
    public boolean registerHandler(IObjectHandler handler) {
        return this.addHandlerToMap(handler);
    }

    @Override
    public boolean removeHandler(ObjectHandlerIdentifier identifier) {
        this.freeID(identifier.getHandlerID());
        this.removeHandlerMapping(identifier.getObjectInstance());
        return this.removeHandlerFromMap(identifier.getObjectInstance());
    }

    private boolean addHandlerToMap(IObjectHandler handler) {
        String id;
        List<IObjectHandler> handlerList;
        if (handler instanceof CommandHandler) {
            CommandHandler c = (CommandHandler)handler;
            Set<Class<? extends IApiObject>> supportedCommands = c.getSupportedClasses();
            for (Class<? extends IApiObject> clazz : supportedCommands) {
                if (!this.supportedCommandclasses.contains(clazz)) continue;
                return false;
            }
            this.supportedCommandclasses.addAll(supportedCommands);
        }
        if ((handlerList = this.handlerMap.get(id = handler.getExtensionID())) == null) {
            handlerList = new ArrayList<IObjectHandler>();
            this.handlerMap.put(id, handlerList);
        }
        return handlerList.add(handler);
    }

    private boolean removeHandlerFromMap(IObjectHandler handler) {
        if (handler instanceof CommandHandler) {
            CommandHandler c = (CommandHandler)handler;
            Set<Class<? extends IApiObject>> supportedCommands = c.getSupportedClasses();
            this.supportedCommandclasses.removeAll(supportedCommands);
        }
        String id = handler.getExtensionID();
        boolean result = false;
        List<IObjectHandler> handlerList = this.handlerMap.get(id);
        if (handlerList != null) {
            result = handlerList.remove(handler);
            if (handlerList.size() == 0) {
                this.handlerMap.remove(id);
            }
        }
        return result;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    private Set<IObjectHandler> getSupportedHandler(IApiObject object, Collection<String> extensionIds) {
        HashSet<IObjectHandler> result = new HashSet<IObjectHandler>();
        for (String id : extensionIds) {
            List<IObjectHandler> handlerList = this.handlerMap.get(id);
            if (handlerList == null) continue;
            this.logger.trace("Searching handler for: " + object.getClass().getName());
            for (IObjectHandler iObjectHandler : handlerList) {
                boolean supported = iObjectHandler.isSupported(object);
                this.logger.trace(iObjectHandler.getClass().getName() + " | supported=" + supported);
                if (!supported) continue;
                result.add(iObjectHandler);
            }
        }
        return result;
    }

    private void removeHandlerMapping(IObjectHandler handler) {
        String id = handler.getExtensionID();
        for (Map.Entry<Class<? extends IApiObject>, Map<String, List<IObjectHandler>>> entry : this.handlerMapping.entrySet()) {
            List<IObjectHandler> handlerList = entry.getValue().get(id);
            if (handlerList == null) continue;
            handlerList.remove(handler);
            if (handlerList.size() == 0) {
                entry.getValue().remove(id);
                if (entry.getValue().size() == 0) {
                    this.handlerMapping.remove(entry.getKey());
                }
            }
            if (!handler.equals(entry.getValue())) continue;
            this.handlerMapping.remove(entry.getKey());
        }
    }

    @Override
    protected void _init() {
    }

    @Override
    protected IObjectHandler getNewObjectInstance(IObjectHandler orgObject) {
        return orgObject;
    }

    @Override
    public String getUniqueHandlerID() {
        return this.getUniqueID();
    }

    @Override
    public void objectReceived(String tag, Object object) {
    }
}

