/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.teachin.referenceid.tools;

import bsc.api.Enumerations;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ISensor;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class JsonExporter {
    protected Set<ReferenceIDNode> tree = null;
    protected ObjectMapper jsonMapper = null;
    protected Class<?>[] includedClasses = null;

    public static void main(String[] args) throws IOException {
        JsonExporter exporter = new JsonExporter();
        FileWriter f = new FileWriter(new File("sdkDeviceDef.json"));
        f.write(exporter.getTreeAsJson(true));
        f.flush();
        System.out.println(exporter.getTreeAsJson(true));
    }

    public JsonExporter() {
        this(ReferenceIDs.includedClasses);
    }

    public JsonExporter(Class<?> ... includedClasses) {
        this.includedClasses = includedClasses;
        this.tree = this.getAbstractObjects();
    }

    protected Set<ReferenceIDNode> getAbstractObjects() {
        HashSet<ReferenceIDNode> tree = new HashSet<ReferenceIDNode>();
        for (IReferenceID v : this.getAllRootNodes()) {
            tree.add(this.convertToAbstractObject(v, null));
        }
        return tree;
    }

    protected Set<IReferenceID> getAllRootNodes() {
        HashSet<IReferenceID> result = new HashSet<IReferenceID>();
        for (Class<?> f : this.includedClasses) {
            if (!IReferenceID.class.isAssignableFrom(f)) continue;
            for (Object e : f.getEnumConstants()) {
                IReferenceID refID;
                if (!(e instanceof IReferenceID) || (refID = (IReferenceID)e).getSuperType() != null) continue;
                result.add(refID);
            }
        }
        return result;
    }

    protected Set<ReferenceIDNode> convertToAbstractObjects(Set<IReferenceID> referenceIDs, IReferenceID newSupertype) {
        HashSet<ReferenceIDNode> result = null;
        if (referenceIDs != null) {
            result = new HashSet<ReferenceIDNode>();
            for (IReferenceID iReferenceID : referenceIDs) {
                result.add(this.convertToAbstractObject(iReferenceID, newSupertype));
            }
        }
        return result;
    }

    protected ReferenceIDNode convertToAbstractObject(IReferenceID referenceID, IReferenceID newSupertype) {
        ReferenceIDNode result = new ReferenceIDNode(referenceID.getReferenceId(), referenceID.getTeachInNames(), referenceID.getAcknowledgeNames(), newSupertype, referenceID.getSensorIndex());
        this.convertToAbstractObjects(referenceID.getSubTypes(), result);
        return result;
    }

    public Set<ReferenceIDNode> getTree() {
        return this.tree;
    }

    public String getTreeAsJson(boolean prettyPrint) throws JsonProcessingException {
        if (prettyPrint) {
            return this.getJsonMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.tree);
        }
        return this.getJsonMapper().writeValueAsString(this.tree);
    }

    protected ObjectMapper getJsonMapper() {
        if (this.jsonMapper == null) {
            this.jsonMapper = new ObjectMapper();
            this.jsonMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
            this.jsonMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        }
        return this.jsonMapper;
    }

    public class ReferenceIDNode
    implements IReferenceID {
        private final String id;
        private final Map<Integer, ReferenceIDs.SensorEntry> sensorIndex = new TreeMap<Integer, ReferenceIDs.SensorEntry>();
        private final List<String> teachInNames;
        private final List<String> acknowledgeNames;
        private final String superType;
        private final Set<IReferenceID> subTypes = new HashSet<IReferenceID>();

        ReferenceIDNode(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, Enumerations.SensorName ... sensorNames) {
            this(id, teachInNames, acknowledgeNames, superType);
            if (sensorNames != null) {
                for (int i = 0; i < sensorNames.length; ++i) {
                    this.sensorIndex.put(i, new ReferenceIDs.SensorEntry(sensorNames[i]));
                }
            }
        }

        ReferenceIDNode(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType, ArrayList<ReferenceIDs.SensorEntry> sensorNames) {
            this(id, teachInNames, acknowledgeNames, superType);
            if (sensorNames != null) {
                for (int i = 0; i < sensorNames.size(); ++i) {
                    this.sensorIndex.put(i, sensorNames.get(i));
                }
            }
        }

        ReferenceIDNode(String id, List<String> teachInNames, List<String> acknowledgeNames, IReferenceID superType) {
            this.id = id;
            if (superType != null) {
                this.superType = superType.getReferenceId();
                superType.registerSubType(this);
            } else {
                this.superType = null;
            }
            this.teachInNames = teachInNames;
            this.acknowledgeNames = acknowledgeNames;
        }

        public String toString() {
            return this.id;
        }

        @Override
        public void registerSubType(IReferenceID subType) {
            if (subType != null) {
                this.subTypes.add(subType);
            }
        }

        @Override
        public Set<IReferenceID> getSubTypes() {
            return Collections.unmodifiableSet(this.subTypes);
        }

        @Override
        public ISensor getMainSensor(ADevice device) {
            return device.getSensorByName(this.getSensorName(0));
        }

        @Override
        public String getSensorName(int index) {
            ReferenceIDs.SensorEntry entry = this.sensorIndex.get(index);
            return entry == null ? null : entry.getName();
        }

        @Override
        public ArrayList<ReferenceIDs.SensorEntry> getSensorIndex() {
            ArrayList<ReferenceIDs.SensorEntry> result = null;
            if (this.sensorIndex != null) {
                result = new ArrayList<ReferenceIDs.SensorEntry>();
                result.addAll(this.sensorIndex.values());
            }
            return result;
        }

        @Override
        public String getReferenceId() {
            return this.id;
        }

        @Override
        public List<String> getTeachInNames() {
            List<String> result = null;
            if (this.teachInNames != null) {
                result = Collections.unmodifiableList(this.teachInNames);
            }
            return result;
        }

        @Override
        public List<String> getAcknowledgeNames() {
            List<String> result = null;
            if (this.acknowledgeNames != null) {
                result = Collections.unmodifiableList(this.acknowledgeNames);
            }
            return result;
        }

        @Override
        public IReferenceID getSuperType() {
            return null;
        }
    }
}

