/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.teachin.referenceid.tools;

import bsc.api.modules.teachin.referenceid.AFRISO;
import bsc.api.modules.teachin.referenceid.BSC;
import bsc.api.modules.teachin.referenceid.EEP;
import bsc.api.modules.teachin.referenceid.ELTAKO;
import bsc.api.modules.teachin.referenceid.ENOCEAN;
import bsc.api.modules.teachin.referenceid.EUROTRONIC;
import bsc.api.modules.teachin.referenceid.GenericDevice;
import bsc.api.modules.teachin.referenceid.HOPPE;
import bsc.api.modules.teachin.referenceid.IQFY;
import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.KP;
import bsc.api.modules.teachin.referenceid.MACO;
import bsc.api.modules.teachin.referenceid.MSR;
import bsc.api.modules.teachin.referenceid.OVENTROP;
import bsc.api.modules.teachin.referenceid.SERVODAN;
import bsc.sdk.api.extension.modules.teachin.referenceid.tools.xml.ReferenceIdXml;
import bsc.sdk.api.extension.modules.teachin.referenceid.tools.xml.ReferenceIdXmlSaveObject;
import bsc.sdk.api.extension.modules.teachin.referenceid.tools.xml.Statistics;
import bsc.sdk.api.extension.modules.teachin.referenceid.tools.xml.XMLAccess;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JAXBExporter {
    private static void prepareXmlSaveObject(ReferenceIdXmlSaveObject saveObject) {
        ArrayList<ReferenceIdXml> references = new ArrayList<ReferenceIdXml>();
        JAXBExporter.process(AFRISO.class, references);
        JAXBExporter.process(BSC.class, references);
        JAXBExporter.process(EEP.class, references);
        JAXBExporter.process(ELTAKO.class, references);
        JAXBExporter.process(ENOCEAN.class, references);
        JAXBExporter.process(EUROTRONIC.class, references);
        JAXBExporter.process(GenericDevice.class, references);
        JAXBExporter.process(HOPPE.class, references);
        JAXBExporter.process(IQFY.class, references);
        JAXBExporter.process(KP.class, references);
        JAXBExporter.process(MACO.class, references);
        JAXBExporter.process(MSR.class, references);
        JAXBExporter.process(OVENTROP.class, references);
        JAXBExporter.process(SERVODAN.class, references);
        Statistics statistics = new Statistics();
        statistics.setGeneratedAt(new SimpleDateFormat("yyyy.MM.dd - HH:mm:ss.SSS").format(new Date(System.currentTimeMillis())));
        statistics.setNumberOfEntries(String.valueOf(references.size()));
        saveObject.setStatistics(statistics);
        saveObject.setReferenceIDs(references);
    }

    private static <T extends IReferenceID> void process(Class<T> clazz, List<ReferenceIdXml> references) {
        for (IReferenceID t : (IReferenceID[])clazz.getEnumConstants()) {
            String referenceId = t.getReferenceId();
            String mainSensorName = t.getSensorName(0);
            if (mainSensorName == null || mainSensorName.trim().isEmpty()) {
                System.err.println("Enum (" + t + ") has no main sensor!");
                continue;
            }
            String actionCategory = JAXBExporter.categoryFor(t);
            if (actionCategory == null || actionCategory.trim().isEmpty()) {
                System.err.println("Enum (" + t + ") was not assigned to a category!");
                continue;
            }
            ReferenceIdXml xml = new ReferenceIdXml();
            xml.setReferenceID(referenceId);
            xml.setMainSensorName(mainSensorName);
            xml.setActionCategory(actionCategory);
            references.add(xml);
        }
    }

    private static <T extends IReferenceID> String categoryFor(T enumConstant) {
        if (enumConstant instanceof ELTAKO) {
            return JAXBExporter.categoryFor((ELTAKO)enumConstant);
        }
        if (enumConstant instanceof BSC) {
            return JAXBExporter.categoryFor((BSC)enumConstant);
        }
        if (enumConstant instanceof AFRISO) {
            return JAXBExporter.categoryFor((AFRISO)enumConstant);
        }
        if (enumConstant instanceof EEP) {
            return JAXBExporter.categoryFor((EEP)enumConstant);
        }
        if (enumConstant instanceof ENOCEAN) {
            return JAXBExporter.categoryFor((ENOCEAN)enumConstant);
        }
        if (enumConstant instanceof EUROTRONIC) {
            return JAXBExporter.categoryFor((EUROTRONIC)enumConstant);
        }
        if (enumConstant instanceof GenericDevice) {
            return JAXBExporter.categoryFor((GenericDevice)enumConstant);
        }
        if (enumConstant instanceof HOPPE) {
            return JAXBExporter.categoryFor((HOPPE)enumConstant);
        }
        if (enumConstant instanceof IQFY) {
            return JAXBExporter.categoryFor((IQFY)enumConstant);
        }
        if (enumConstant instanceof KP) {
            return JAXBExporter.categoryFor((KP)enumConstant);
        }
        if (enumConstant instanceof MACO) {
            return JAXBExporter.categoryFor((MACO)enumConstant);
        }
        if (enumConstant instanceof MSR) {
            return JAXBExporter.categoryFor((MSR)enumConstant);
        }
        if (enumConstant instanceof OVENTROP) {
            return JAXBExporter.categoryFor((OVENTROP)enumConstant);
        }
        if (enumConstant instanceof SERVODAN) {
            return JAXBExporter.categoryFor((SERVODAN)enumConstant);
        }
        return null;
    }

    private static String categoryFor(ELTAKO iReferenceID) {
        switch (iReferenceID) {
            case FMZ61_230V: 
            case FSR14: 
            case FSR61_230V: 
            case FSSA_230V: 
            case FSVA_230V: 
            case FTN61: 
            case TF100L_230V: 
            case TF61L_230V: 
            case TF61R_230V: 
            case TF_TA65L: 
            case TF_TRHB_TF61: 
            case TF_TRHB55_TF61: 
            case TF_TA55L: 
            case F1FT65: 
            case F4SR14_LED: 
            case F4SR14_LED_V4_3: 
            case FLC61NP: 
            case FMS14: 
            case FSR14SSR: 
            case FSR14SSR_V4_3: 
            case FSR14_2X: 
            case FSR14_2X_V4_3: 
            case FSR14_4X: 
            case FSR14_4X_V4_3: 
            case FSR61: 
            case FSR61NP: 
            case FSR61NP_230V: 
            case FSR61VA_10A: 
            case FSR61_230V_V2_1: 
            case FSR61_8_24V_UC: 
            case FSR70_230V: 
            case FSR71NP_230V_V1_1: 
            case FSR71NP_230V_V2_3: 
            case FSR71NP_2X_230V_V1_2: 
            case FSR71NP_2X_230V_V2_3: 
            case FSR71NP_4X_230V_V1_3: 
            case FSR71NP_4X_230V_V2_3: 
            case FSR71SSR_2X_230V_V1_3: 
            case FSR71SSR_2X_230V_V2_3: 
            case FSR71_2X_230V_V1_2: 
            case FSR71_2X_230V_V2_3: 
            case FTN14: 
            case FTN61NP_230V: 
            case PL_SAM1L: 
            case TF_1FT: 
            case TF_2ZT: 
            case TF_2ZT55: 
            case TF_4FT: 
            case TF_4FT55: 
            case TF_4PT: 
            case TF_4PT55: 
            case TF_8FM: 
            case TF_AHDSB_TF: 
            case TF_TRHB_BA_TF61: 
            case TF_TRSB55_TF: 
            case TF_TRSB_TF: 
            case TF_WTB: 
            case TF_WTB55: {
                return "STATE";
            }
            case FSB14: 
            case FSB61: 
            case FSUD_230V: 
            case FUD14: 
            case FUD61_230V: 
            case TF100D_230V: 
            case TF61D_230V: 
            case TF61J_230V: 
            case TF_TA65DL: 
            case TF_TA65J: 
            case TF_TA65D: 
            case TF_TA55J: 
            case TF_TA55DL: 
            case TF_TA55D: 
            case FRGBW: 
            case FDG14_1_2: 
            case FDG14_1_3: 
            case FDG14_2_1: 
            case FDG14_3_1: 
            case FDG71L_230V_1_1: 
            case FDG71L_230V_2_1: 
            case FKLD61: 
            case FLD61: 
            case FRGBW71L: 
            case FSB14_1_1: 
            case FSB14_2_1: 
            case FSB14_4_2: 
            case FSB61NP_230V: 
            case FSB61NP_230V_1_1: 
            case FSB61NP_230V_2_1: 
            case FSB61NP_230V_3_1: 
            case FSB71_230V_V1_1: 
            case FSB71_230V_V3_1: 
            case FSB71_24VDC_V3_1: 
            case FSB71_2x_230V_V1_1: 
            case FSB71_2x_230V_V3_1: 
            case FSG14_1_10V_V1_1: 
            case FSG14_1_10V_V3_1: 
            case FSG14_1_10V_V3_8: 
            case FSG71_1_10V_V1_1: 
            case FSG71_1_10V_V1_5: 
            case FUD14_800W_V1_1: 
            case FUD14_800W_V3_1: 
            case FUD14_800W_V3_8: 
            case FUD14_V1_1: 
            case FUD14_V3_1: 
            case FUD14_V3_8: 
            case FUD61: 
            case FUD61NPN_230V: 
            case FUD61_230V_V2_1: 
            case FUD62NPN_BLE: 
            case FUD70: 
            case FUD71L_1200W_230V_V1_1: 
            case FUD71L_1200W_230V_V1_5: 
            case FUD71_230V_V1_5: 
            case FUD71_V1_1: 
            case FWWKW71L_SINGLE_V1_1: 
            case PL_SAM2: 
            case PL_SAMDR: 
            case PL_SAMDU: 
            case TF_DTB: 
            case TF_DTB55: 
            case TF_TAJ: {
                return "VALUE";
            }
            case FAE14LPR: 
            case FAE14SSR: 
            case FHK14: 
            case FUTH65D: 
            case TF_FKS: 
            case TF_UTH55: 
            case TF_UTH: 
            case TF_TRHB_FHK: 
            case TF_TRHB55_FHK: 
            case FTR78S: 
            case FTR65HS: 
            case FTR55H: 
            case FTR55D: 
            case BUTH65D: 
            case F4HK14: 
            case FHK14_V1_1: 
            case FHK14_V2_1: 
            case FHK61_FF: 
            case FHK61_U: 
            case FHK61_V0_3: 
            case FKS_E: 
            case FKS_E_MD15: 
            case FKS_MD15: 
            case FTR65: 
            case FTR86B: 
            case FTRF65SB: 
            case FUT55D: 
            case PL_SAMTEMP: 
            case TF_FKS_SMARTDRIVE: 
            case TF_TRHB_BA_FHK: 
            case TF_TRSB55_FHK: 
            case TF_TRSB_FHK: 
            case FAE14LPR_4_1: 
            case FAE14SSR_4_1: 
            case FHK14_V4_1: {
                return "TEMPERATURE";
            }
            case CHARGE_STATE: {
                break;
            }
            case DSZ14: {
                break;
            }
            case EMITTER: {
                break;
            }
            case F6T55B: {
                break;
            }
            case F6T65B: {
                break;
            }
            case FABH: {
                break;
            }
            case FABH65: {
                break;
            }
            case FAFT60: {
                break;
            }
            case FAH60: {
                break;
            }
            case FAH60B: {
                break;
            }
            case FAH65: {
                break;
            }
            case FAH65S: {
                break;
            }
            case FB65B: {
                break;
            }
            case FBH55: {
                break;
            }
            case FBH63AP: {
                break;
            }
            case FBH65: {
                break;
            }
            case FBH65TFB: {
                break;
            }
            case FCO2TF63: {
                break;
            }
            case FCO2TF65: {
                break;
            }
            case FFT65B: {
                break;
            }
            case FGSENSOR: {
                break;
            }
            case FHF: {
                break;
            }
            case FIFT65S: {
                break;
            }
            case FIH63B: {
                break;
            }
            case FIH65: {
                break;
            }
            case FIH65B: {
                break;
            }
            case FIH65S: {
                break;
            }
            case FKC: {
                break;
            }
            case FKF: {
                break;
            }
            case FMS61NP_230V: {
                break;
            }
            case FPE_V1: {
                break;
            }
            case FPE_V2: {
                break;
            }
            case FRW: {
                break;
            }
            case FSM60B_JP1: {
                break;
            }
            case FSM60B_JP2: {
                break;
            }
            case FSM60B_JP3: {
                break;
            }
            case FSM60B_JP4: {
                break;
            }
            case FSS12: {
                break;
            }
            case FTF55: {
                break;
            }
            case FTF65S: {
                break;
            }
            case FTK: {
                break;
            }
            case FTKB: {
                break;
            }
            case FTKB_GR: {
                break;
            }
            case FTKB_HG: {
                break;
            }
            case FTKE: {
                break;
            }
            case FTKE_US: {
                break;
            }
            case FWS60: {
                break;
            }
            case FWS61: {
                break;
            }
            case FWWKW71L_DUAL_V1_1: {
                break;
            }
            case FZK14: {
                break;
            }
            case PIO_TEK_TRACKER: {
                break;
            }
            case TF100A_230V: {
                break;
            }
            case TF_AHDSB: {
                break;
            }
            case TF_AHDSB_FAH: {
                break;
            }
            case TF_BHSB: {
                break;
            }
            case TF_BHSB_FBH: {
                break;
            }
            case TF_BHSB_TF: {
                break;
            }
            case TF_BSB: {
                break;
            }
            case TF_BSB55: {
                break;
            }
            case TF_FAHDSB: {
                break;
            }
            case TF_FGB: {
                break;
            }
            case TF_FKB: {
                break;
            }
            case TF_FKE: {
                break;
            }
            case TF_FTE: {
                break;
            }
            case TF_FTSB: {
                break;
            }
            case TF_FTSB55: {
                break;
            }
            case TF_HMB: {
                break;
            }
            case TF_IUS: {
                break;
            }
            case TF_IUS55: {
                break;
            }
            case TF_LGTF: {
                break;
            }
            case TF_RWB: {
                break;
            }
            case TF_TAD: {
                break;
            }
            case TF_TADL: {
                break;
            }
            case TF_TAL: {
                break;
            }
            case TF_TRHB: {
                break;
            }
            case TF_TRSB: {
                break;
            }
            case TF_TTB: {
                break;
            }
            case WEATHER_STATION_ELTAKO: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(BSC iReferenceID) {
        switch (iReferenceID) {
            case DIRECTION_TOGGLE_LEFT: 
            case DIRECTION_TOGGLE_RIGHT: {
                return "STATE";
            }
            case DIMMER_ABSOLUTE: 
            case DIMMER_RELATIVE: {
                return "VALUE";
            }
            case THERMOSTAT: {
                return "TEMPERATURE";
            }
            case WEATHER_STATION_ELSNER: {
                break;
            }
            case AMR_COLLECTION: {
                break;
            }
            case AMR_ELECTRICITY: {
                break;
            }
            case AMR_GAS: {
                break;
            }
            case AMR_GENERIC: {
                break;
            }
            case AMR_THERMAL: {
                break;
            }
            case AMR_WATER: {
                break;
            }
            case BURG_LOCK: {
                break;
            }
            case COMFORT_MULTIFUNCTION_DIMMMING_V_0_1: {
                break;
            }
            case COMFORT_MULTIFUNCTION_HEATING_V_0_1: {
                break;
            }
            case COMFORT_MULTIFUNCTION_SHADING_V_0_1: {
                break;
            }
            case SYNOLOGY_CAMERA: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(AFRISO iReferenceID) {
        switch (iReferenceID) {
            case FT: 
            case FTF: 
            case RFT: 
            case RFTF: {
                return "TEMPERATURE";
            }
            case ASD: {
                break;
            }
            case ASD10: {
                break;
            }
            case FTM_T: {
                break;
            }
            case FTM_TF: {
                break;
            }
            case FTM_UNIVERSAL: {
                break;
            }
            case WATERCONTROL: {
                break;
            }
            case WATERSENSOR: {
                break;
            }
            case WATERSENSOR_ECO: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(EEP iReferenceID) {
        switch (iReferenceID) {
            case F6_01_01: 
            case F6_02_01: 
            case F6_02_02: {
                return "STATE";
            }
            case A5_10_02: 
            case A5_10_03: 
            case A5_10_04: 
            case A5_10_06: 
            case A5_10_11: 
            case A5_10_12: 
            case A5_10_22: 
            case A5_10_23: 
            case A5_20_01: {
                return "TEMPERATURE";
            }
            case A5_02_01: {
                break;
            }
            case A5_02_02: {
                break;
            }
            case A5_02_03: {
                break;
            }
            case A5_02_04: {
                break;
            }
            case A5_02_05: {
                break;
            }
            case A5_02_06: {
                break;
            }
            case A5_02_07: {
                break;
            }
            case A5_02_08: {
                break;
            }
            case A5_02_09: {
                break;
            }
            case A5_02_0A: {
                break;
            }
            case A5_02_0B: {
                break;
            }
            case A5_02_10: {
                break;
            }
            case A5_02_11: {
                break;
            }
            case A5_02_12: {
                break;
            }
            case A5_02_13: {
                break;
            }
            case A5_02_14: {
                break;
            }
            case A5_02_15: {
                break;
            }
            case A5_02_16: {
                break;
            }
            case A5_02_17: {
                break;
            }
            case A5_02_18: {
                break;
            }
            case A5_02_19: {
                break;
            }
            case A5_02_1A: {
                break;
            }
            case A5_02_1B: {
                break;
            }
            case A5_02_20: {
                break;
            }
            case A5_02_30: {
                break;
            }
            case A5_04_01: {
                break;
            }
            case A5_04_02: {
                break;
            }
            case A5_04_03: {
                break;
            }
            case A5_06_01: {
                break;
            }
            case A5_06_02: {
                break;
            }
            case A5_06_03: {
                break;
            }
            case A5_09_04: {
                break;
            }
            case A5_14_09: {
                break;
            }
            case A5_14_0A: {
                break;
            }
            case A5_30_01: {
                break;
            }
            case D2_02_00: {
                break;
            }
            case D2_02_01: {
                break;
            }
            case D2_02_02: {
                break;
            }
            case D2_B0_51: {
                break;
            }
            case D5_00_01: {
                break;
            }
            case F6_04_01: {
                break;
            }
            case F6_05_01: {
                break;
            }
            case F6_10_00: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(ENOCEAN iReferenceID) {
        switch (iReferenceID) {
            case EDWS: {
                break;
            }
            case EKCS: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(EUROTRONIC iReferenceID) {
        switch (iReferenceID) {
            case STELLA_E: {
                return "TEMPERATURE";
            }
        }
        return null;
    }

    private static String categoryFor(GenericDevice iReferenceID) {
        switch (iReferenceID) {
            case ACTOR_CONTAINER: 
            case OFF_ON: 
            case ON_OFF: {
                return "STATE";
            }
            case DIMMER: {
                return "VALUE";
            }
            case SET_POINT: {
                return "TEMPERATURE";
            }
            case ALERT: {
                break;
            }
            case BRIGHTNESS: {
                break;
            }
            case CAMERA: {
                break;
            }
            case DETECTION: {
                break;
            }
            case GAS: {
                break;
            }
            case HUMIDITY: {
                break;
            }
            case OPEN: {
                break;
            }
            case SCHEDULE: {
                break;
            }
            case TEMPERATURE: {
                break;
            }
            case VIRTUAL: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(HOPPE iReferenceID) {
        switch (iReferenceID) {
            default: 
        }
        return null;
    }

    private static String categoryFor(IQFY iReferenceID) {
        switch (iReferenceID) {
            case MOTION_USB_BWM_FUS_2: {
                break;
            }
            case MOTION_USB_FUS_2: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(KP iReferenceID) {
        switch (iReferenceID) {
            case MD10: 
            case MD15: 
            case RPW_301: {
                return "TEMPERATURE";
            }
        }
        return null;
    }

    private static String categoryFor(MACO iReferenceID) {
        switch (iReferenceID) {
            default: 
        }
        return null;
    }

    private static String categoryFor(MSR iReferenceID) {
        switch (iReferenceID) {
            default: 
        }
        return null;
    }

    private static String categoryFor(OVENTROP iReferenceID) {
        switch (iReferenceID) {
            case MH_CON_B: 
            case R_TRONIC_RT_B_EEP_02: 
            case R_TRONIC_RT_B_EEP_03: 
            case R_TRONIC_RT_B_EEP_04: 
            case R_TRONIC_RT_B_EEP_06: 
            case R_TRONIC_RT_B_EEP_06_RPS: 
            case R_TRONIC_TF_EEP_11: 
            case R_TRONIC_TF_EEP_11_RPS: 
            case R_TRONIC_TF_EEP_12: 
            case R_TRONIC_TF_EEP_22: 
            case R_TRONIC_TF_EEP_23: {
                return "TEMPERATURE";
            }
            case R_TRONIC_RT_B: {
                break;
            }
        }
        return null;
    }

    private static String categoryFor(SERVODAN iReferenceID) {
        switch (iReferenceID) {
            default: 
        }
        return null;
    }

    public static boolean writeReferenceIdsToXML(String fileName) {
        ReferenceIdXmlSaveObject saveObject = new ReferenceIdXmlSaveObject();
        JAXBExporter.prepareXmlSaveObject(saveObject);
        boolean success = XMLAccess.writeToXML(saveObject, fileName);
        return success;
    }

    public static List<ReferenceIdXml> readReferenceIdsFromXML(String fileName) {
        ReferenceIdXmlSaveObject saveObject = XMLAccess.readFromXML(fileName);
        if (saveObject == null) {
            return new ArrayList<ReferenceIdXml>();
        }
        List<ReferenceIdXml> referenceIds = saveObject.getReferenceIDs();
        if (referenceIds == null) {
            return new ArrayList<ReferenceIdXml>();
        }
        return referenceIds;
    }

    public static ReferenceIdXml findReferenceIdInXML(String referenceID, String fileName) {
        ReferenceIdXmlSaveObject saveObject = XMLAccess.readFromXML(fileName);
        ReferenceIdXml xml = XMLAccess.findReferenceId(referenceID, saveObject);
        return xml;
    }

    public static ReferenceIdXml findReferenceIdInList(String referenceID, List<ReferenceIdXml> list) {
        return XMLAccess.findReferenceId(referenceID, list);
    }

    public static void main(String[] args) {
        String exportToFile = System.getProperty("user.home") + "/referenceIDs.xml";
        boolean success = JAXBExporter.writeReferenceIdsToXML(exportToFile);
        System.out.println("Exporting to *.xml success: " + success);
        System.out.println("=====================");
        List<ReferenceIdXml> referenceIds = JAXBExporter.readReferenceIdsFromXML(exportToFile);
        for (ReferenceIdXml referenceId : referenceIds) {
            System.out.println(referenceId);
        }
        System.out.println("=====================");
        ReferenceIdXml referenceID = JAXBExporter.findReferenceIdInXML("enocean.eltako.tf.tf100d-230v", exportToFile);
        System.out.println(referenceID);
    }
}

