/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.teachin.referenceid.tools;

import bsc.api.modules.teachin.referenceid.IReferenceID;
import bsc.api.modules.teachin.referenceid.ReferenceIDs;
import bsc.sdk.api.extension.modules.teachin.referenceid.tools.info.ReferenceIdInfo;
import java.util.ArrayList;

public class InfoParser {
    public static ReferenceIdInfo parseReferenceID(IReferenceID referenceID) {
        return InfoParser.parseReferenceID(referenceID.getReferenceId());
    }

    public static ReferenceIdInfo parseReferenceID(String referenceID) {
        if (referenceID == null) {
            return null;
        }
        String refID = null;
        String type = null;
        String manufacturer = null;
        String category = null;
        String product = null;
        String version = null;
        if (referenceID.contains("#")) {
            String[] tmpData = referenceID.split("#", 2);
            refID = tmpData[0];
            version = tmpData[1];
        } else {
            refID = referenceID;
        }
        String[] data = refID.split("\\.", 4);
        switch (data.length) {
            case 4: {
                product = data[3];
            }
            case 3: {
                if (data.length == 3) {
                    product = data[2];
                } else {
                    category = data[2];
                }
            }
            case 2: {
                manufacturer = data[1];
            }
            case 1: {
                type = data[0];
            }
        }
        return new ReferenceIdInfo(referenceID, type, manufacturer, category, product, version);
    }

    public static boolean validateReferenceID(IReferenceID referenceID) {
        return InfoParser.validateReferenceID(referenceID.getReferenceId());
    }

    public static boolean validateReferenceID(String referenceID) {
        ReferenceIdInfo info = InfoParser.parseReferenceID(referenceID);
        return info == null ? false : info.isValid();
    }

    public static void main(String[] args) throws InterruptedException {
        ArrayList<IReferenceID> toCheck = new ArrayList<IReferenceID>();
        for (Class<?> clazz : ReferenceIDs.includedClasses) {
            ?[] result;
            if (!IReferenceID.class.isAssignableFrom(clazz) || (result = clazz.getEnumConstants()) == null) continue;
            for (Object iReferenceID : result) {
                try {
                    toCheck.add((IReferenceID)iReferenceID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.print("Validate " + toCheck.size() + " reference ids");
        ArrayList<ReferenceIdInfo> valid = new ArrayList<ReferenceIdInfo>();
        ArrayList<ReferenceIdInfo> invalid = new ArrayList<ReferenceIdInfo>();
        for (IReferenceID iReferenceID : toCheck) {
            System.out.print(".");
            ReferenceIdInfo info = InfoParser.parseReferenceID(iReferenceID);
            if (info != null && info.isValid()) {
                valid.add(info);
                continue;
            }
            invalid.add(info);
        }
        System.out.println();
        System.out.println("---------------------------------------");
        System.out.println("Valid: " + valid.size());
        System.out.println("---------------------------------------");
        for (ReferenceIdInfo referenceIdInfo : valid) {
            System.out.println(referenceIdInfo);
        }
        System.out.println("---------------------------------------");
        System.out.println("Invalid: " + invalid.size());
        System.out.println("---------------------------------------");
        for (ReferenceIdInfo referenceIdInfo : invalid) {
            System.out.println(referenceIdInfo);
        }
    }
}

