/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.teachin.notification;

import bsc.api.IMetaInformation;
import bsc.api.basic.model.ADevice;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.api.modules.teachin.model.DeviceInfo;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.teachin.notification.ATeachInNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddMetaData;
import java.util.HashMap;
import java.util.Map;

public class AddMetaDataHandler
extends ATeachInNotification<AddMetaData> {
    public static final String KEY_VALUE_SEPERATOR = "=";
    public static final String ENTRY_SEPERATOR = ",";
    private static ANotificationExecutor<AddMetaData> executor = new ANotificationExecutor<AddMetaData>(){

        @Override
        public void execute(AObjectNotificationListener<AddMetaData> parent, AddMetaData object) {
            IMetaInformation metaInformation = object.getObject();
            HashMap<String, String> metaInformations = new HashMap<String, String>();
            if (metaInformation instanceof ServerInterface) {
                metaInformations.put(AUTO_PAIRING.AP_ENABLED.name(), "false");
                metaInformations.put(AUTO_PAIRING.AP_AUTO_STOP.name(), "0");
                metaInformations.put(AUTO_PAIRING.AP_TARGET_GRP.name(), "");
            } else if (metaInformation instanceof ADevice) {
                HashMap<String, String> acknowledgeIdNameValues = new HashMap<String, String>();
                acknowledgeIdNameValues.put("default", "");
                HashMap<String, String> signalStrengthTimeValues = new HashMap<String, String>();
                acknowledgeIdNameValues.put(String.valueOf(System.currentTimeMillis()), "-999");
                metaInformations.put(DETAILS.ACKNOWLEDGE_ID.name(), AddMetaDataHandler.generateKeyValueStringFromMap(acknowledgeIdNameValues));
                metaInformations.put(DETAILS.SIGNAL_STRENGTH.name(), AddMetaDataHandler.generateKeyValueStringFromMap(signalStrengthTimeValues));
                metaInformations.put(DETAILS.REFERENCE_ID.name(), "Here comes a new reference id");
            } else if (metaInformation instanceof DeviceInfo) {
                metaInformations.put(DETAILS.SIGNAL_STRENGTH.name(), System.currentTimeMillis() + "=-999");
            }
            if (!metaInformations.isEmpty()) {
                metaInformation.addMetaInformation(parent.getExtensionId(), metaInformations);
            }
        }
    };

    public AddMetaDataHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static String generateKeyValueStringFromMap(Map<String, String> nameValueMap) {
        StringBuilder sb = new StringBuilder();
        if (nameValueMap != null) {
            for (Map.Entry<String, String> entry : nameValueMap.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(ENTRY_SEPERATOR);
                }
                sb.append(entry.getKey() + KEY_VALUE_SEPERATOR + entry.getValue());
            }
        }
        return sb.toString();
    }

    public static ANotificationExecutor<AddMetaData> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddMetaData> executor) {
        AddMetaDataHandler.executor = executor;
    }

    public static enum AUTO_PAIRING {
        AP_TARGET_GRP,
        AP_AUTO_STOP,
        AP_ENABLED;

    }

    public static enum DETAILS {
        ACKNOWLEDGE_ID,
        SIGNAL_STRENGTH,
        REFERENCE_ID,
        TRANSMISSION_ID,
        PAIRING_MODE,
        PAIRING_TIMEOUT,
        DEFAULT_GATEWAY_ID,
        SIGNAL_STRENGTH_DBM,
        ENOCEAN_RORG,
        ENOCEAN_DATA_VALUE,
        ENOCEAN_STATUS_VALUE,
        ENOCEAN_TEACHIN_SIGNAL;

    }
}

