/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.qos.command.executor;

import bsc.api.modules.qos.QoSMode;
import bsc.api.modules.qos.commands.ConfigureQoSCommand;
import bsc.api.transport.result.FailResult;
import bsc.api.transport.result.ObjectResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.qos.command.AQoSExecutor;
import bsc.sdk.api.handler.command.Executable;
import bsc.sdk.api.transceiver.controller.impl.TransceiverController;
import bsc.sdk.api.transceiver.manager.TransceiverIdentifier;

public class ConfigureQoSExecutor
extends AQoSExecutor<ConfigureQoSCommand> {
    private static Executable<ConfigureQoSCommand> executable = new Executable<ConfigureQoSCommand>(){

        @Override
        public Result execute(TransceiverIdentifier identifier, ConfigureQoSCommand command) {
            TransceiverController controller = identifier.getControllerInstance();
            if (controller == null) {
                return new FailResult("Unable to configure QoS");
            }
            if (command.getMode().equals((Object)QoSMode.CUSTOM)) {
                controller.setQoSUpdateIntervalObjects(command.getUpdateIntervalObjects());
                controller.setQoSUpdateIntervalFrames(command.getUpdateIntervalFrames());
            }
            controller.setQoSDeviceWhitelist(command.getDeviceWhitelist());
            controller.setQoSGroupWhitelist(command.getGroupWhitelist());
            controller.setQoSMode(command.getMode());
            return new ObjectResult(controller.getQoSConfiguration());
        }
    };

    public ConfigureQoSExecutor(Environment enviromentSettings) {
        super(executable, enviromentSettings);
    }

    public static Executable<ConfigureQoSCommand> getExecutable() {
        return executable;
    }

    public static void setExecutable(Executable<ConfigureQoSCommand> executable) {
        ConfigureQoSExecutor.executable = executable;
    }
}

