/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.metainfo;

import bsc.api.Enumerations;
import bsc.api.IMetaInformation;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ASensor;
import bsc.api.modules.IModuleClass;
import bsc.api.modules.connections.model.condition.ConditionCollection;
import bsc.api.modules.connections.model.connection.Connection;
import bsc.api.modules.connections.model.executor.ExecutorCollection;
import bsc.api.modules.core.model.Group;
import bsc.api.modules.metainfo.IModuleMetaInfo;
import bsc.api.modules.metainfo.commands.ICommandsMetaInfo;
import bsc.api.modules.metainfo.commands.offers.IOfferMetaInfo;
import bsc.api.modules.metainfo.model.IModelMetaInfo;
import bsc.api.modules.tf.model.TapFunction;
import bsc.api.modules.usermanagement.model.User;
import bsc.sdk.api.extension.AExtension;
import bsc.sdk.api.extension.modules.metainfo.IMetaInfoIdParser;

public class MetaInfoExtension
extends AExtension {
    public static final String ID_SEPERATOR = "#";
    private static IMetaInfoIdParser metaInfoIdParser = null;
    public static final String RESERVED_ID_KEY = "id";
    private static boolean enabledByDefault = true;

    public MetaInfoExtension() {
        super(Enumerations.EXTENSION_ID.METAINFO);
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected void _init() {
    }

    @Override
    protected Class<? extends IModuleClass> getModuleInterfaceClass(IModuleClass.CLASS_TYPE type) {
        switch (type) {
            case COMMANDS: {
                return ICommandsMetaInfo.class;
            }
            case MODEL: {
                return IModelMetaInfo.class;
            }
            case MODULE: {
                return IModuleMetaInfo.class;
            }
            case OFFER: {
                return IOfferMetaInfo.class;
            }
        }
        return null;
    }

    public static boolean isEnabledByDefault() {
        return enabledByDefault;
    }

    public static void setEnabledByDefault(boolean enabledByDefault) {
        MetaInfoExtension.enabledByDefault = enabledByDefault;
    }

    public static String getMetaInfoID(IMetaInformation object) {
        return MetaInfoExtension.getMetaInfoIdParser().getMetaInfoID(object);
    }

    public static String getMetaIDfromMetaInfoObject(IMetaInformation object) {
        String result = null;
        if (object != null) {
            result = object.getMetaInformation(Enumerations.EXTENSION_ID.METAINFO.name(), RESERVED_ID_KEY);
        }
        return result;
    }

    public static IMetaInfoIdParser getMetaInfoIdParser() {
        if (metaInfoIdParser == null) {
            metaInfoIdParser = new IMetaInfoIdParser(){

                @Override
                public String getMetaInfoID(IMetaInformation object) {
                    String result = null;
                    if (object instanceof ADevice) {
                        ADevice o = (ADevice)object;
                        result = ADevice.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getDeviceID();
                    } else if (object instanceof ASensor) {
                        ASensor o = (ASensor)object;
                        result = ASensor.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getDeviceID() + MetaInfoExtension.ID_SEPERATOR + o.getSensorID();
                    } else if (object instanceof Group) {
                        Group o = (Group)object;
                        result = Group.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getId();
                    } else if (object instanceof ConditionCollection) {
                        ConditionCollection o = (ConditionCollection)object;
                        result = ConditionCollection.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getID();
                    } else if (object instanceof Connection) {
                        Connection o = (Connection)object;
                        result = Connection.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getID();
                    } else if (object instanceof ExecutorCollection) {
                        ExecutorCollection o = (ExecutorCollection)object;
                        result = ExecutorCollection.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getID();
                    } else if (object instanceof TapFunction) {
                        TapFunction o = (TapFunction)object;
                        result = TapFunction.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getId();
                    } else if (object instanceof User) {
                        User o = (User)object;
                        result = User.class.getSimpleName() + MetaInfoExtension.ID_SEPERATOR + o.getName();
                    }
                    return result;
                }
            };
        }
        return metaInfoIdParser;
    }

    public static void setMetaInfoParser(IMetaInfoIdParser metaInfoParser) {
        metaInfoIdParser = metaInfoParser;
    }
}

