/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.message.notification;

import bsc.api.basic.model.ISensor;
import bsc.api.modules.message.commands.offer.AcknowledgeMessagesOffer;
import bsc.api.modules.message.commands.offer.DeleteMessagesOffer;
import bsc.api.modules.message.commands.offer.sensor.AcknowledgeAllSensorMessagesOffer;
import bsc.api.modules.message.commands.offer.sensor.DeleteAllSensorMessagesOffer;
import bsc.api.modules.message.commands.offer.sensor.DisableSensorMessagesOffer;
import bsc.api.modules.message.commands.offer.sensor.EnableSensorMessagesOffer;
import bsc.api.modules.message.commands.offer.sensor.GetSensorMessagesOffer;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.message.notification.AMessageNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddSensorOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddSensorOffersHandler
extends AMessageNotification<AddSensorOffers> {
    private static ANotificationExecutor<AddSensorOffers> executor = new ANotificationExecutor<AddSensorOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddSensorOffers> parent, AddSensorOffers object) {
            ISensor sensor = object.getSensor();
            EnumSet<Permission> rights = object.getRights();
            if (rights.contains((Object)Permission.VIEW_EXTENDED)) {
                sensor.addCommandOffer(new GetSensorMessagesOffer());
            }
            if (rights.contains((Object)Permission.CONFIGURE)) {
                sensor.addCommandOffer(new EnableSensorMessagesOffer());
                sensor.addCommandOffer(new DisableSensorMessagesOffer());
            }
            if (rights.contains((Object)Permission.MODIFY)) {
                sensor.addCommandOffer(new DeleteAllSensorMessagesOffer());
                sensor.addCommandOffer(new DeleteMessagesOffer());
                sensor.addCommandOffer(new AcknowledgeAllSensorMessagesOffer());
                sensor.addCommandOffer(new AcknowledgeMessagesOffer());
            }
        }
    };

    public AddSensorOffersHandler(Environment enviromentSettings) {
        super(executor, enviromentSettings);
    }

    public static ANotificationExecutor<AddSensorOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddSensorOffers> executor) {
        AddSensorOffersHandler.executor = executor;
    }
}

