/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.m2m;

import bsc.api.Enumerations;
import bsc.api.modules.IModuleClass;
import bsc.api.modules.m2m.IModuleM2M;
import bsc.api.modules.m2m.commands.ICommandsM2M;
import bsc.api.modules.m2m.commands.offers.IOfferM2M;
import bsc.api.modules.m2m.model.IModelM2M;
import bsc.sdk.api.extension.AExtension;

public class M2MExtension
extends AExtension {
    private static boolean enabledByDefault = true;

    public M2MExtension() {
        super(Enumerations.EXTENSION_ID.M2M);
        this.setEnabled(enabledByDefault);
        this.addMetaInformationEnumClass(SETTINGS.class);
    }

    public void setDeviceToken(String deviceToken) {
        this.putExtensionSetting(SETTINGS.DEVICE_TOKEN, deviceToken);
    }

    public String getDeviceToken() {
        return this.getExtensionSetting(SETTINGS.DEVICE_TOKEN);
    }

    public void setVID(String vid) {
        this.putExtensionSetting(SETTINGS.VID, vid);
    }

    public String getVID() {
        return this.getExtensionSetting(SETTINGS.VID);
    }

    @Override
    protected void _init() {
    }

    @Override
    protected Class<? extends IModuleClass> getModuleInterfaceClass(IModuleClass.CLASS_TYPE type) {
        switch (type) {
            case COMMANDS: {
                return ICommandsM2M.class;
            }
            case MODEL: {
                return IModelM2M.class;
            }
            case MODULE: {
                return IModuleM2M.class;
            }
            case OFFER: {
                return IOfferM2M.class;
            }
        }
        return null;
    }

    public static boolean isEnabledByDefault() {
        return enabledByDefault;
    }

    public static void setEnabledByDefault(boolean enabledByDefault) {
        M2MExtension.enabledByDefault = enabledByDefault;
    }

    @Override
    public void shutdown() {
    }

    public static enum SETTINGS {
        DEVICE_TOKEN,
        VID;

    }
}

