/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.object;

import bsc.api.IApiObject;
import bsc.api.basic.commands.offer.AOffer;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ASensor;
import bsc.api.basic.model.ISensor;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.AObjectProcessor;
import bsc.sdk.api.objects.IProcessorExecutor;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanitizeObjectData
extends AObjectProcessor {
    private static Logger logger = LoggerFactory.getLogger(SanitizeObjectData.class);
    private static IProcessorExecutor executor = new IProcessorExecutor(){

        @Override
        public void processObject(UserCredentialIdentifier user, IApiObject object) {
            if (object instanceof ASensor) {
                ASensor sensor = (ASensor)object;
                SanitizeObjectData.removeDoubleOffers(sensor.getCommandOffers());
            } else if (object instanceof ADevice) {
                ADevice device = (ADevice)object;
                SanitizeObjectData.removeDoubleOffers(device.getCommandOffers());
                for (ISensor s : device.getSensors()) {
                    this.processObject(user, s);
                }
            }
        }
    };

    public static IProcessorExecutor getExecutor() {
        return executor;
    }

    public static void setExecutor(IProcessorExecutor executor) {
        SanitizeObjectData.executor = executor;
    }

    public SanitizeObjectData(Environment environment) {
        super(environment, executor);
    }

    @Override
    public void processObject(UserCredentialIdentifier user, IApiObject object) {
        if (object instanceof ASensor) {
            ASensor sensor = (ASensor)object;
            SanitizeObjectData.removeDoubleOffers(sensor.getCommandOffers());
        } else if (object instanceof ADevice) {
            ADevice device = (ADevice)object;
            SanitizeObjectData.removeDoubleOffers(device.getCommandOffers());
            for (ISensor s : device.getSensors()) {
                this.processObject(user, s);
            }
        }
    }

    private static void removeDoubleOffers(List<AOffer<?>> offers) {
        if (offers == null) {
            return;
        }
        HashSet existingOffers = new HashSet();
        Iterator<AOffer<?>> itr = offers.iterator();
        while (itr.hasNext()) {
            AOffer<?> o = itr.next();
            if (!existingOffers.contains(o)) {
                existingOffers.add(o);
                continue;
            }
            logger.trace("Remove double offer: " + o.toString());
            itr.remove();
        }
    }

    @Override
    public int getExecutePosition() {
        return Integer.MAX_VALUE;
    }
}

