/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.core.object;

import bsc.api.IApiObject;
import bsc.api.basic.model.ADevice;
import bsc.api.basic.model.ASensor;
import bsc.api.basic.model.ISensor;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.objects.AObjectProcessor;
import bsc.sdk.api.objects.IProcessorExecutor;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;

public class ResetObjectData
extends AObjectProcessor {
    private static IProcessorExecutor executor = new IProcessorExecutor(){

        @Override
        public void processObject(UserCredentialIdentifier user, IApiObject object) {
            if (object instanceof ASensor) {
                ASensor sensor = (ASensor)object;
                sensor.clearCommandOffers();
                sensor.clearMetaInformations();
            } else if (object instanceof ADevice) {
                ADevice device = (ADevice)object;
                device.clearCommandOffers();
                device.clearMetaInformations();
                for (ISensor s : device.getSensors()) {
                    this.processObject(user, s);
                }
            }
        }
    };

    public static IProcessorExecutor getExecutor() {
        return executor;
    }

    public static void setExecutor(IProcessorExecutor executor) {
        ResetObjectData.executor = executor;
    }

    public ResetObjectData(Environment environment) {
        super(environment, executor);
    }

    @Override
    public int getExecutePosition() {
        return 0;
    }
}

