/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.extension.modules.alexa.notification;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.alexa.commands.offer.GetAuthTokenOffer;
import bsc.api.modules.alexa.commands.offer.RevokeAuthTokenOffer;
import bsc.api.modules.alexa.commands.offer.SetDeviceLiveUpdateOffer;
import bsc.api.modules.alexa.commands.offer.UpdateCacheOffer;
import bsc.api.modules.bsc.model.ServerInterface;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.extension.modules.alexa.notification.AAlexaNotification;
import bsc.sdk.api.extension.notification.AObjectNotificationListener;
import bsc.sdk.api.notification.ANotificationExecutor;
import bsc.sdk.api.notification.objects.AddDeviceOffers;
import bsc.sdk.api.user.group.Permission;
import java.util.EnumSet;

public class AddDeviceOffersHandler
extends AAlexaNotification<AddDeviceOffers> {
    private static ANotificationExecutor<AddDeviceOffers> executor = new ANotificationExecutor<AddDeviceOffers>(){

        @Override
        public void execute(AObjectNotificationListener<AddDeviceOffers> parent, AddDeviceOffers object) {
            ADevice device = object.getDevice();
            EnumSet<Permission> rights = object.getPermissions();
            if (device instanceof ServerInterface) {
                if (rights.contains((Object)Permission.CONFIGURE)) {
                    device.addCommandOffer(new GetAuthTokenOffer());
                    device.addCommandOffer(new RevokeAuthTokenOffer());
                    device.addCommandOffer(new UpdateCacheOffer());
                }
            } else if (device instanceof ADevice && rights.contains((Object)Permission.CONFIGURE)) {
                device.addCommandOffer(new SetDeviceLiveUpdateOffer());
            }
        }
    };

    public AddDeviceOffersHandler(Environment enviromentSettings) {
        super(AddDeviceOffersHandler.getExecutor(), enviromentSettings);
    }

    public static ANotificationExecutor<AddDeviceOffers> getExecutor() {
        return executor;
    }

    public static void setExecutor(ANotificationExecutor<AddDeviceOffers> executor) {
        AddDeviceOffersHandler.executor = executor;
    }
}

