/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.crypt.aes;

import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.security.Checksum;
import bsc.sdk.security.bouncycastle.crypto.BufferedBlockCipher;
import bsc.sdk.security.bouncycastle.crypto.engines.AESFastEngine;
import bsc.sdk.security.bouncycastle.crypto.modes.CBCBlockCipher;
import bsc.sdk.security.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import bsc.sdk.security.bouncycastle.crypto.params.KeyParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESCipher
implements ICipher {
    private static Logger logger = LoggerFactory.getLogger(AESCipher.class);
    private BufferedBlockCipher encrypter;
    private BufferedBlockCipher decrypter;

    @Override
    public synchronized byte[] encrypt(byte[] data) {
        if (this.encrypter == null) {
            return data;
        }
        this.encrypter.reset();
        return this.doFinal(this.encrypter, data);
    }

    @Override
    public synchronized byte[] decrypt(byte[] data) {
        if (this.decrypter == null) {
            return data;
        }
        this.decrypter.reset();
        return this.doFinal(this.decrypter, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doFinal(BufferedBlockCipher cipher, byte[] inputBytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(inputBytes);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int inputLength = 0;
        int outputLength = 0;
        byte[] inputBuffer = new byte[1024];
        byte[] outputBuffer = new byte[cipher.getOutputSize(inputBuffer.length)];
        try {
            while ((inputLength = input.read(inputBuffer)) > -1) {
                outputLength = cipher.processBytes(inputBuffer, 0, inputLength, outputBuffer, 0);
                if (outputLength <= 0) continue;
                output.write(outputBuffer, 0, outputLength);
            }
            outputLength = cipher.doFinal(outputBuffer, 0);
            if (outputLength > 0) {
                output.write(outputBuffer, 0, outputLength);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
            try {
                output.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setShared(byte[] shared) {
        if (shared != null) {
            byte[] key = Checksum.getSHA256Checksum(shared);
            this.encrypter = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESFastEngine()));
            this.encrypter.init(true, new KeyParameter(key));
            this.decrypter = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESFastEngine()));
            this.decrypter.init(false, new KeyParameter(key));
        } else {
            this.encrypter = null;
            this.decrypter = null;
        }
    }
}

