/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.compression.zip;

import bsc.sdk.api.compression.ICompression;
import bsc.sdk.api.compression.zip.DeflaterOutputStream;
import bsc.sdk.api.compression.zip.InflaterInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZIPCompression
implements ICompression {
    private static Logger logger = LoggerFactory.getLogger(ZIPCompression.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] data) {
        if (data == null) {
            return null;
        }
        DeflaterOutputStream dout = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            dout = new DeflaterOutputStream(bout);
            dout.write(data);
            dout.finish();
            dout.close();
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                dout.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decompress(byte[] data) {
        if (data == null) {
            return null;
        }
        int chunk = 8192;
        int length = 0;
        ByteArrayOutputStream bout = null;
        InflaterInputStream iin = null;
        try {
            byte[] decompressed;
            bout = new ByteArrayOutputStream();
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            iin = new InflaterInputStream(bin);
            byte[] compressedData = new byte[chunk];
            while ((length = iin.read(compressedData, 0, chunk)) != -1) {
                bout.write(compressedData, 0, length);
            }
            byte[] byArray = decompressed = bout.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                bout.close();
            }
            catch (Exception exception) {}
            try {
                iin.close();
            }
            catch (Exception exception) {}
        }
    }
}

