/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server;

import bsc.sdk.api.application.server.ISocketAttachment;
import bsc.sdk.api.transceiver.ITransceiver;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketController
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(SocketController.class);
    private final Selector selector = Selector.open();
    private final Map<Integer, InetSocketAddress> destinationByLocalPort;
    private final boolean debug;
    private volatile boolean running;

    public SocketController(Map<Integer, InetSocketAddress> map, boolean debug) throws IOException {
        this.destinationByLocalPort = map;
        this.debug = debug;
        for (Integer portNum : map.keySet()) {
            ServerSocketChannel ssCh = ServerSocketChannel.open();
            ServerSocket ss = ssCh.socket();
            ss.bind(new InetSocketAddress(portNum));
            ssCh.configureBlocking(false);
            ssCh.register(this.selector, 16);
        }
        this.running = true;
        this.start();
    }

    @Override
    public void run() {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        while (this.running) {
            try {
                int anz = this.selector.select(1000L);
                if (anz <= 0) continue;
                Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectableChannel c;
                    SocketChannel channel;
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid()) {
                        key.cancel();
                        continue;
                    }
                    if (key.isAcceptable()) {
                        ServerSocketChannel ssCh = (ServerSocketChannel)key.channel();
                        channel = ssCh.accept();
                        channel.configureBlocking(false);
                        String sourceIP = channel.socket().getInetAddress().getHostAddress() + ":" + channel.socket().getPort();
                        int localPort = channel.socket().getLocalPort();
                        InetSocketAddress adr = this.destinationByLocalPort.get(new Integer(localPort));
                        if (adr != null) continue;
                        channel.close();
                        continue;
                    }
                    if (!key.isReadable() || !((c = key.channel()) instanceof SocketChannel)) continue;
                    channel = (SocketChannel)c;
                    buffer.clear();
                    try {
                        int count;
                        while ((count = channel.read(buffer)) > 0) {
                        }
                        if (count == -1) {
                            throw new EOFException();
                        }
                        buffer.flip();
                        byte[] data = new byte[buffer.remaining()];
                        buffer.get(data);
                        if (this.debug) {
                            StringBuilder sb = new StringBuilder("Msg=");
                            for (int i = 0; i < data.length; ++i) {
                                if (data[i] < 32) {
                                    sb.append('#');
                                    continue;
                                }
                                sb.append((char)(data[i] & 0xFF));
                            }
                        }
                        ITransceiver iTransceiver = (ITransceiver)key.attachment();
                    }
                    catch (IOException iox) {
                        ISocketAttachment attachment = (ISocketAttachment)key.attachment();
                        if (attachment != null) {
                            attachment.localSocketWasClosed();
                        }
                        logger.error(iox.getMessage(), (Throwable)iox);
                        channel.close();
                        key.cancel();
                    }
                }
            }
            catch (CancelledKeyException ckex) {
                logger.error(ckex.getMessage(), (Throwable)ckex);
            }
            catch (IOException ix) {
                logger.error(ix.getMessage(), (Throwable)ix);
            }
            catch (RuntimeException rx) {
                logger.error(rx.getMessage(), (Throwable)rx);
            }
        }
    }
}

