/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server;

import bsc.sdk.api.application.server.IServerChannel;
import bsc.sdk.api.transceiver.ChannelHandlerCompletionSync;
import bsc.sdk.api.transceiver.ChannelWorker;
import bsc.sdk.net.ISocket;
import bsc.sdk.net.SocketFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelSync
implements IServerChannel {
    private ServerSocket serverChannel;
    private ServerChannelType serverChannelType;
    private ExecutorService executorService;
    private static Logger logger = LoggerFactory.getLogger(ServerChannelSync.class);

    public ServerChannelSync(ServerSocket serverChannel, ExecutorService executorService, ServerChannelType serverChannelType) {
        this.serverChannel = serverChannel;
        this.executorService = executorService;
        this.serverChannelType = serverChannelType;
    }

    @Override
    public void close() throws IOException {
        this.serverChannel.close();
    }

    @Override
    public ChannelWorker accept() {
        try {
            Socket result = this.serverChannel.accept();
            switch (this.serverChannelType) {
                case AUTO_DETECTION: {
                    ISocket clientChannel = null;
                    clientChannel = SocketFactory.createNewWebsocketInstance(result, new BufferedInputStream(result.getInputStream()), result.getOutputStream());
                    if (clientChannel != null) {
                        logger.trace("WebSocket created...");
                    } else {
                        logger.trace("failed to create WebSocket");
                        clientChannel = SocketFactory.createNewMobileInstance(result, result.getInputStream(), result.getOutputStream());
                        logger.trace("MobileSocket created...");
                    }
                    ChannelHandlerCompletionSync handler = new ChannelHandlerCompletionSync(clientChannel, this.executorService);
                    return handler;
                }
                case SOCKET_SERVER: {
                    ISocket clientChannel = SocketFactory.createNewMobileInstance(result, result.getInputStream(), result.getOutputStream());
                    ChannelHandlerCompletionSync handler = new ChannelHandlerCompletionSync(clientChannel, this.executorService);
                    return handler;
                }
                case WEB_SOCKET_SERVER: {
                    ISocket clientChannel = SocketFactory.createNewWebsocketInstance(result, result.getInputStream(), result.getOutputStream());
                    ChannelHandlerCompletionSync handler = new ChannelHandlerCompletionSync(clientChannel, this.executorService);
                    return handler;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static enum ServerChannelType {
        AUTO_DETECTION,
        SOCKET_SERVER,
        WEB_SOCKET_SERVER;

    }
}

