/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server;

import bsc.sdk.api.application.server.IServerChannel;
import bsc.sdk.api.transceiver.ChannelHandlerCompletionAsync;
import bsc.sdk.api.transceiver.ChannelWorker;
import java.io.IOException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ServerChannelAsync
implements IServerChannel {
    private AsynchronousServerSocketChannel serverChannel;
    private ExecutorService executorService;

    public ServerChannelAsync(AsynchronousServerSocketChannel serverChannel, ExecutorService executorService) {
        this.serverChannel = serverChannel;
        this.executorService = executorService;
    }

    @Override
    public void close() throws IOException {
        this.serverChannel.close();
    }

    @Override
    public ChannelWorker accept() {
        try {
            Future<AsynchronousSocketChannel> result = this.serverChannel.accept();
            AsynchronousSocketChannel clientChannel = result.get();
            ChannelHandlerCompletionAsync handler = new ChannelHandlerCompletionAsync(clientChannel, this.executorService);
            return handler;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }
}

