/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.server;

import bsc.sdk.api.application.builder.IBuilder;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.manager.IApplicationManager;
import bsc.sdk.api.application.server.Server;
import bsc.sdk.api.transceiver.listener.ITransceiverListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ServerBuilder
implements IBuilder<Server> {
    private static Logger logger = LoggerFactory.getLogger(ServerBuilder.class);
    private Server server = new Server();
    protected static final String serverChennelIdPoolName = "ServerChannelId_";
    private int maxGlobalConnectionSlots = 1;
    private int maxUserConnectionSlots = 1;

    public ServerBuilder() {
        this.server.setPort(2021);
        this.server.setServing(false);
        this.server.setServerAddress("0.0.0.0");
        this.server.setApplicationHost("local");
    }

    private AsynchronousServerSocketChannel createServerSocketChannel() throws IOException {
        AsynchronousServerSocketChannel serverChannel = null;
        serverChannel = AsynchronousServerSocketChannel.open();
        serverChannel.bind(new InetSocketAddress(this.server.getServerAddress(), this.server.getPort()), 0);
        return serverChannel;
    }

    private Set<ITransceiverListener> createDefaultTransceiverListeners() {
        Set<ITransceiverListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
        return listeners;
    }

    public ServerBuilder setPort(int port) {
        if (port > 0) {
            this.server.setPort(port);
        }
        return this;
    }

    public ServerBuilder setServing(boolean serving) {
        this.server.setServing(serving);
        return this;
    }

    public ServerBuilder setServerAddress(String serverAddress) {
        this.server.setServerAddress(serverAddress);
        return this;
    }

    public ServerBuilder setTransceiverListeners(Set<ITransceiverListener> transceiverListeners) {
        this.server.setTransceiverListeners(transceiverListeners);
        return this;
    }

    public ServerBuilder setEnvironment(Environment environment) {
        this.server.setEnvironment(environment);
        return this;
    }

    public ServerBuilder setApplicationName(String applicationName) {
        this.server.setApplicationName(applicationName);
        return this;
    }

    public ServerBuilder setApplicationHost(String applicationHost) {
        this.server.setApplicationHost(applicationHost);
        return this;
    }

    public ServerBuilder setMaxGlobalConnectionSlots(int maxSlots) {
        this.maxGlobalConnectionSlots = maxSlots;
        return this;
    }

    public ServerBuilder setMaxUserConnectionSlots(int maxSlots) {
        this.maxUserConnectionSlots = maxSlots;
        return this;
    }

    public ServerBuilder setApplicationManager(IApplicationManager applicationManager) {
        this.server.setApplicationManager(applicationManager);
        this.server.setApplicationId(applicationManager.generateApplicationId());
        return this;
    }

    @Override
    public Server buildProduct() {
        Server newServer = new Server(this.server);
        return newServer;
    }
}

