/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.application.manager;

import bsc.sdk.api.application.IApplication;
import bsc.sdk.api.application.idpool.IdPool;
import bsc.sdk.api.application.manager.IApplicationManager;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ApplicationManager
implements IApplicationManager {
    private IdPool idPool = new IdPool(IdPool.GENERATOR_TYPE.RANDOM, "Application");
    protected Map<String, IApplication> objects = new ConcurrentHashMap<String, IApplication>();

    public ApplicationManager() {
        this.idPool.setBaseLength(14);
        this.idPool.setInsert("");
    }

    @Override
    public void shutdownAll() {
        for (IApplication application : this.objects.values()) {
            application.shutdown();
        }
    }

    @Override
    public String generateApplicationId() {
        return this.idPool.getId();
    }

    @Override
    public void addObject(IApplication object) {
        if (!this.objects.containsKey(object.getApplicationId())) {
            this.objects.put(object.getApplicationId(), object);
            object.addApplicationManager(this);
        }
    }

    @Override
    public void removeObject(IApplication object) {
        if (object != null) {
            this.objects.remove(object.getApplicationId());
            object.removeApplicationManager(this);
        }
    }

    @Override
    public IApplication getObjectInstance(String applicationID) {
        return this.objects.get(applicationID);
    }

    @Override
    public Collection<IApplication> getApplicationList() {
        return this.objects.values();
    }

    @Override
    public void applicationStateChanged(IApplication application, IApplicationManager.ApplicationState applicationState) {
        switch (applicationState) {
            case UNEXPECTED_SHUTDOWN: {
                System.err.println("UNEXPECTED SHUTDOWN. Calling shutdown on application.");
                this.idPool.freeID(application.getApplicationId());
                application.shutdown();
            }
        }
    }
}

